/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a)\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\u0010\u0006\u001a-\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0004\b\u0007\u0010\u0006\u001a\u0012\u0010\u0000\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0\u0003H\u0001\u001a\u0012\u0010\u0000\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0\tH\u0001\u001aE\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u0001\"\b\b\u0001\u0010\u000b*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\rH\u0001\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"sum", "T", "", "", "type", "Lkotlin/reflect/KType;", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;)Ljava/lang/Number;", "sumNullableT", "Ljava/math/BigDecimal;", "Lkotlin/sequences/Sequence;", "sumOf", "R", "selector", "Lkotlin/Function1;", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Number;", "core"})
public final class SumKt {
    @PublishedApi
    @NotNull
    public static final <T, R extends Number> R sumOf(@NotNull Iterable<? extends T> $this$sumOf, @NotNull KType type, @NotNull Function1<? super T, ? extends R> selector) {
        Number number;
        Intrinsics.checkNotNullParameter($this$sumOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        if (type.isMarkedNullable()) {
            Iterable seq = SequencesKt.asIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence($this$sumOf), selector));
            return (R)SumKt.sum(seq, type);
        }
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            double d = 0.0;
            for (T t : iterable) {
                d += ((Number)function1.invoke(t)).doubleValue();
            }
            number = d;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            int n = 0;
            for (T t : iterable) {
                n += ((Number)function1.invoke(t)).intValue();
            }
            number = n;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            long l = 0L;
            for (T t : iterable) {
                l += ((Number)function1.invoke(t)).longValue();
            }
            number = l;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            BigDecimal bigDecimal = BigDecimal.valueOf(0L);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            BigDecimal bigDecimal2 = bigDecimal;
            for (T t : iterable) {
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2.add((BigDecimal)function1.invoke(t)), (String)"add(...)");
            }
            BigDecimal bigDecimal3 = bigDecimal2;
            Intrinsics.checkNotNull((Object)bigDecimal3, (String)"null cannot be cast to non-null type R of org.jetbrains.kotlinx.dataframe.math.SumKt.sumOf");
            number = bigDecimal3;
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return (R)number;
    }

    @PublishedApi
    @NotNull
    public static final <T extends Number> T sum(@NotNull Iterable<? extends T> $this$sum, @NotNull KType type) {
        Number number;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = CollectionsKt.sumOfDouble($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf(CollectionsKt.sumOfFloat($this$sum));
        } else if ((Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = CollectionsKt.sumOfInt($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = CollectionsKt.sumOfLong($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = SumKt.sum($this$sum);
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.math.SumKt.sum");
            number = bigDecimal;
        } else {
            throw new IllegalArgumentException("Sum is not supported for " + type);
        }
        return (T)number;
    }

    @JvmName(name="sumNullableT")
    @PublishedApi
    @NotNull
    public static final <T extends Number> T sumNullableT(@NotNull Iterable<? extends T> $this$sum, @NotNull KType type) {
        Number number;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = SequencesKt.sumOfDouble((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf(SequencesKt.sumOfFloat((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum))));
        } else if ((Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = SequencesKt.sumOfInt((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = SequencesKt.sumOfLong((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = SumKt.sum((Sequence<? extends BigDecimal>)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.math.SumKt.sum");
            number = bigDecimal;
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return (T)number;
    }

    @PublishedApi
    @NotNull
    public static final BigDecimal sum(@NotNull Iterable<? extends BigDecimal> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        BigDecimal sum2 = bigDecimal;
        for (BigDecimal bigDecimal2 : $this$sum) {
            Intrinsics.checkNotNullExpressionValue((Object)sum2.add(bigDecimal2), (String)"add(...)");
        }
        return sum2;
    }

    @PublishedApi
    @NotNull
    public static final BigDecimal sum(@NotNull Sequence<? extends BigDecimal> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        BigDecimal sum2 = bigDecimal;
        for (BigDecimal element : $this$sum) {
            Intrinsics.checkNotNullExpressionValue((Object)sum2.add(element), (String)"add(...)");
        }
        return sum2;
    }
}

