/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.JSRemoveReadonlyModifierFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.codeInsight.Angular2HighlightingUtils;
import org.angular2.codeInsight.config.Angular2Compiler;
import org.angular2.entities.source.Angular2SourceUtil;
import org.angular2.inspections.AngularInaccessibleSymbolInspection;
import org.angular2.inspections.AngularInaccessibleSymbolInspectionKt;
import org.angular2.inspections.quickfixes.AngularChangeModifierQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.expr.psi.Angular2ElementVisitor;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.angular2.lang.html.psi.Angular2HtmlPropertyBinding;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.angular2.signals.Angular2SignalUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/angular2/inspections/AngularInaccessibleSymbolInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "getElementsToOptimizeForTSServiceHighlighting", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.angular"})
public final class AngularInaccessibleSymbolInspection
extends JSInspection {
    @NotNull
    public Set<Class<? extends PsiElement>> getElementsToOptimizeForTSServiceHighlighting() {
        Object[] objectArray = new Class[]{JSReferenceExpression.class, Angular2HtmlPropertyBinding.class};
        return SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Language language2 = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Language fileLang = language2;
        if (fileLang.isKindOf((Language)Angular2HtmlLanguage.INSTANCE) || Angular2Language.INSTANCE.is(fileLang)) {
            return (PsiElementVisitor)new Angular2ElementVisitor(holder){
                final /* synthetic */ ProblemsHolder $holder;
                {
                    this.$holder = $holder;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement psiElement = element;
                    if (psiElement instanceof JSReferenceExpression) {
                        this.checkReference((JSReferenceExpression)element);
                    } else if (psiElement instanceof Angular2HtmlPropertyBinding) {
                        this.checkPropertyBinding((Angular2HtmlPropertyBinding)element);
                    }
                    super.visitElement(element);
                }

                private final void checkReference(JSReferenceExpression node) {
                    Object[] objectArray;
                    PsiElement resolved;
                    TypeScriptClass clazz;
                    if ((node.getQualifier() == null || node.getQualifier() instanceof JSThisExpression) && (clazz = (TypeScriptClass)PsiTreeUtil.getContextOfType((PsiElement)(resolved = node.resolve()), (Class[])(objectArray = new Class[]{TypeScriptClass.class}))) != null && resolved instanceof JSElement && !AngularInaccessibleSymbolInspectionKt.isAccessible(resolved, JSAttributeList.AccessType.PROTECTED)) {
                        PsiElement psiElement = node.getReferenceNameElement();
                        if (psiElement == null) {
                            psiElement = (PsiElement)node;
                        }
                        objectArray = new Object[]{StringUtil.capitalize((String)AngularInaccessibleSymbolInspectionKt.access$getKind(resolved)), AngularInaccessibleSymbolInspectionKt.access$getHtmlName(resolved), AngularInaccessibleSymbolInspectionKt.access$getHtmlAccessModifier((JSElement)resolved), Angular2HighlightingUtils.INSTANCE.getHtmlName((JSClass)clazz)};
                        String string = Angular2Bundle.Companion.htmlMessage(Angular2Compiler.INSTANCE.isStrictTemplates((PsiElement)clazz) ? "angular.inspection.inaccessible-symbol.strict.private.message" : "angular.inspection.inaccessible-symbol.aot.message", objectArray);
                        objectArray = new LocalQuickFix[]{new AngularChangeModifierQuickFix(JSAttributeList.AccessType.PROTECTED, null, 2, null)};
                        this.$holder.registerProblem(psiElement, string, (LocalQuickFix[])objectArray);
                    }
                }

                private final void checkPropertyBinding(Angular2HtmlPropertyBinding element) {
                    if (element.getBindingType() == PropertyBindingType.PROPERTY) {
                        if (!Angular2Compiler.INSTANCE.isStrictInputAccessModifiers((PsiElement)element)) {
                            return;
                        }
                        List<JSAttributeListOwner> inputElements = AngularInaccessibleSymbolInspectionKt.getInputSourceElements(element);
                        TypeScriptClass typeScriptClass = Angular2SourceUtil.findComponentClass((PsiElement)element);
                        if (typeScriptClass == null) {
                            return;
                        }
                        TypeScriptClass owner = typeScriptClass;
                        for (JSAttributeListOwner input : inputElements) {
                            Object[] objectArray;
                            TypeScriptClass inputOwner;
                            JSAttributeList.AccessType minAccessType;
                            JSAttributeList jSAttributeList = input.getAttributeList();
                            JSAttributeList.AccessType accessType = jSAttributeList != null ? jSAttributeList.getAccessType() : null;
                            PsiElement $this$parentOfType_u24default$iv = (PsiElement)input;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            if ((TypeScriptClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TypeScriptClass.class, (boolean)true) == null) {
                                return;
                            }
                            JSAttributeList.AccessType accessType2 = minAccessType = Intrinsics.areEqual((Object)inputOwner, (Object)owner) ? JSAttributeList.AccessType.PROTECTED : JSAttributeList.AccessType.PUBLIC;
                            if (!AngularInaccessibleSymbolInspectionKt.isAccessible((PsiElement)input, minAccessType)) {
                                objectArray = new Object[]{StringUtil.capitalize((String)AngularInaccessibleSymbolInspectionKt.access$getKind((PsiElement)input)), AngularInaccessibleSymbolInspectionKt.access$getHtmlName((PsiElement)input), AngularInaccessibleSymbolInspectionKt.access$getHtmlAccessModifier((JSElement)input), Angular2HighlightingUtils.INSTANCE.getHtmlName((JSClass)inputOwner)};
                                String string = Angular2Bundle.Companion.htmlMessage(accessType == JSAttributeList.AccessType.PRIVATE ? "angular.inspection.inaccessible-symbol.strict.private.message" : "angular.inspection.inaccessible-symbol.strict.protected.message", objectArray);
                                objectArray = new LocalQuickFix[]{new AngularChangeModifierQuickFix(minAccessType, inputOwner.getName())};
                                this.$holder.registerProblem((PsiElement)element.getNameElement(), string, (LocalQuickFix[])objectArray);
                                continue;
                            }
                            JSAttributeList jSAttributeList2 = input.getAttributeList();
                            boolean bl = jSAttributeList2 != null ? jSAttributeList2.hasModifier(JSAttributeList.ModifierType.READONLY) : false;
                            if (!bl || ((Boolean)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)((PsiElement)element), () -> createVisitor.1.checkPropertyBinding$lambda$0(input))).booleanValue()) continue;
                            objectArray = new Object[]{AngularInaccessibleSymbolInspectionKt.access$getHtmlName((PsiElement)input), AngularInaccessibleSymbolInspectionKt.access$getHtmlAccessModifier((JSElement)input), Angular2HighlightingUtils.INSTANCE.getHtmlName((JSClass)inputOwner)};
                            String string = Angular2Bundle.Companion.htmlMessage("angular.inspection.inaccessible-symbol.strict.read-only.message", objectArray);
                            objectArray = new LocalQuickFix[]{new JSRemoveReadonlyModifierFix(input)};
                            this.$holder.registerProblem((PsiElement)element.getNameElement(), string, (LocalQuickFix[])objectArray);
                        }
                    }
                }

                private static final boolean checkPropertyBinding$lambda$0(JSAttributeListOwner $input) {
                    return Angular2SignalUtils.isSignal$default(Angular2SignalUtils.INSTANCE, (PsiElement)$input, null, false, 4, null);
                }
            };
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
        return psiElementVisitor;
    }
}

