/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DbOptionProvider<Target, T> {
    public static final ExtensionPointName<DbOptionProvider<?, ?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.optionProvider");

    public boolean isAcceptable(@NotNull Class<?> var1);

    public boolean isApplicable(@NotNull Target var1);

    @Nls
    public String getDisplayName();

    @Nls
    public String getDescription();

    default public T getValue(@Nullable Target target2) {
        return this.load(target2);
    }

    public T load(@Nullable Target var1);

    public void store(@NotNull Target var1, T var2);

    public EditorDesc<T> getEditor(Target var1, @NotNull DataContext var2);

    @NotNull
    public UiLocation getLocation();

    @Nullable
    default public String getPassToConnectKey() {
        return null;
    }

    default public boolean isAffectsIntrospection() {
        return false;
    }

    public static <Target> JBIterable<DbOptionProvider<Target, ?>> getProviders(@NotNull Class<? extends Target> clazz) {
        if (clazz == null) {
            DbOptionProvider.$$$reportNull$$$0(0);
        }
        return JBIterable.from((Iterable)EP_NAME.getIterable()).filter(e -> e.isAcceptable(clazz));
    }

    public static <Target> JBIterable<DbOptionProvider<Target, ?>> getProviders(@NotNull Target target2) {
        if (target2 == null) {
            DbOptionProvider.$$$reportNull$$$0(1);
        }
        return DbOptionProvider.getProviders(DbImplUtilCore.classOf(target2)).filter(e -> e.isApplicable(target2));
    }

    public static <Target, T> T getOptionValue(@NotNull Target target2, @NotNull Class<? extends DbOptionProvider<Target, T>> clazz) {
        DbOptionProvider<Target, T> provider;
        if (target2 == null) {
            DbOptionProvider.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            DbOptionProvider.$$$reportNull$$$0(3);
        }
        return (provider = DbOptionProvider.getProvider(target2, clazz)) == null ? null : (T)provider.getValue(target2);
    }

    @Nullable
    public static <Target, T> DbOptionProvider<Target, T> getProvider(@NotNull Target target2, @NotNull Class<? extends DbOptionProvider<Target, T>> clazz) {
        if (target2 == null) {
            DbOptionProvider.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            DbOptionProvider.$$$reportNull$$$0(5);
        }
        return (DbOptionProvider)DbOptionProvider.getProviders(DbImplUtilCore.classOf(target2)).filter(clazz).first();
    }

    public static EditorDesc<Boolean> getCheckBox(Boolean value) {
        JCheckBox component = new JCheckBox(null, null, value);
        EditorDesc<Boolean> res2 = new EditorDesc<Boolean>(component, component::setSelected, component::isSelected);
        component.addActionListener(e -> res2.fireChanged());
        return res2;
    }

    public static EditorDesc<String> getTextField(@Nls String value) {
        return DbOptionProvider.getTextField(value, Functions.id(), Functions.id());
    }

    public static <T> EditorDesc<T> getTextField(T value, Function<? super T, @Nls String> toStr, Function<? super String, T> fromStr) {
        JTextField component = new JTextField((String)toStr.fun(value));
        final EditorDesc res2 = new EditorDesc(component, v -> component.setText((String)toStr.fun(v)), () -> fromStr.fun((Object)component.getText()));
        component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                res2.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DbOptionProvider$1", "textChanged"));
            }
        });
        return res2;
    }

    @NotNull
    public static <T> EditorDesc<T> getComboBox(JComboBox<T> component) {
        EditorDesc res2 = new EditorDesc(component, v -> component.setSelectedItem(v), () -> component.getSelectedItem());
        component.addItemListener(e -> res2.fireChanged());
        EditorDesc editorDesc = res2;
        if (editorDesc == null) {
            DbOptionProvider.$$$reportNull$$$0(6);
        }
        return editorDesc;
    }

    @Nullable
    public static Double getDouble(@Nullable String v) {
        double res2 = v == null ? -1.0 : StringUtil.parseDouble((String)v, (double)-1.0);
        return res2 > 0.0 ? Double.valueOf(res2) : null;
    }

    @Nullable
    public static Integer getInteger(@Nullable String v) {
        int res2 = v == null ? -1 : StringUtil.parseInt((String)v, (int)-1);
        return res2 > 0 ? Integer.valueOf(res2) : null;
    }

    @Nullable
    public static Long getLong(@Nullable String v) {
        long res2 = v == null ? -1L : StringUtil.parseLong((String)v, (long)-1L);
        return res2 > 0L ? Long.valueOf(res2) : null;
    }

    @Nullable
    public static String getString(@Nullable Object v) {
        return v == null ? null : v.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DbOptionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DbOptionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOptionValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static class EditorDesc<T> {
        public final JComponent component;
        public final Setter<T> setter;
        public final Getter<T> getter;
        public final Ref<Runnable> changed;

        public EditorDesc(JComponent component, Setter<T> setter, Getter<T> getter) {
            this(component, setter, getter, (Ref<Runnable>)Ref.create());
        }

        public EditorDesc(JComponent component, Setter<T> setter, Getter<T> getter, Ref<Runnable> changed) {
            this.component = component;
            this.setter = setter;
            this.getter = getter;
            this.changed = changed;
        }

        public void fireChanged() {
            Runnable runnable = (Runnable)this.changed.get();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public static abstract class LocalDataSourceOptionProvider<T>
    implements DbOptionProvider<LocalDataSource, T> {
        @Override
        public boolean isAcceptable(@NotNull Class<?> targetClass) {
            if (targetClass == null) {
                LocalDataSourceOptionProvider.$$$reportNull$$$0(0);
            }
            return LocalDataSource.class.isAssignableFrom(targetClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/database/dataSource/DbOptionProvider$LocalDataSourceOptionProvider", "isAcceptable"));
        }
    }

    public static abstract class ConnectionPointOptionProvider<T>
    implements DbOptionProvider<DatabaseConnectionPoint, T> {
        @Override
        public boolean isAcceptable(@NotNull Class<?> targetClass) {
            if (targetClass == null) {
                ConnectionPointOptionProvider.$$$reportNull$$$0(0);
            }
            return DatabaseConnectionPoint.class.isAssignableFrom(targetClass);
        }

        @Override
        public void store(@NotNull DatabaseConnectionPoint point, T value) {
            if (point == null) {
                ConnectionPointOptionProvider.$$$reportNull$$$0(1);
            }
            if (point instanceof DatabaseConnectionConfig) {
                this.store((DatabaseConnectionConfig)point, value);
            }
        }

        @Override
        public abstract void store(@NotNull DatabaseConnectionConfig var1, T var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DbOptionProvider$ConnectionPointOptionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class DriverOptionProvider<T>
    implements DbOptionProvider<DatabaseDriver, T> {
        @Override
        public boolean isAcceptable(@NotNull Class<?> targetClass) {
            if (targetClass == null) {
                DriverOptionProvider.$$$reportNull$$$0(0);
            }
            return DatabaseDriver.class.isAssignableFrom(targetClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/database/dataSource/DbOptionProvider$DriverOptionProvider", "isAcceptable"));
        }
    }

    public static enum UiLocation {
        EXPERT,
        SCHEMAS,
        CONNECTION,
        INTROSPECTION,
        GENERAL,
        NEW_TAB;

    }
}

