/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.ReboundNotPossibleException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.dataSource.ui.DesktopActionsOptionProvider;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.remote.jdbc.SQLExceptionWithProperties;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandlerImpl;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.NetUtils;
import java.awt.HeadlessException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.NoRouteToHostException;
import java.rmi.RemoteException;
import java.security.Security;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDatabaseErrorHandler
implements DatabaseErrorHandler {
    @Override
    @NotNull
    public final ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original) {
        if (original == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(0);
        }
        if (AsyncUtil.isCancellation(original)) {
            throw new AssertionError("No PCE expected", original);
        }
        KnownDatabaseException knownException = (KnownDatabaseException)ExceptionUtil.findCause((Throwable)original, KnownDatabaseException.class);
        if (knownException != null) {
            ErrorInfo errorInfo = knownException.info;
            if (errorInfo == null) {
                BaseDatabaseErrorHandler.$$$reportNull$$$0(1);
            }
            return errorInfo;
        }
        ErrorInfo errorInfo = this.getErrorInfo(dataSource, original, BaseDatabaseErrorHandler.getRootCause(original));
        if (errorInfo == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(2);
        }
        return errorInfo;
    }

    @NotNull
    private static Throwable getRootCause(@NotNull Throwable original) {
        Throwable[] suppressed;
        if (original == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(3);
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)original);
        for (Throwable se : suppressed = cause.getSuppressed()) {
            if (AsyncTask.isFrameData(se)) continue;
            return BaseDatabaseErrorHandler.getRootCause(se);
        }
        Throwable throwable = cause;
        if (throwable == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(4);
        }
        return throwable;
    }

    @NotNull
    protected ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (original == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(5);
        }
        if (cause == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(6);
        }
        String origMsg = GridUtilCore.getMessage((Throwable)original);
        String causeMsg = GridUtilCore.getMessage((Throwable)cause);
        if (cause instanceof HeadlessException) {
            return new HeadlessErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof UnsupportedOperationException) {
            return new UnsupportedOperationErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof UnsatisfiedLinkError) {
            return new MissingNativeLibraryErrorInfo(dataSource, original, cause);
        }
        if (cause.getClass().getName().contains("Ssh") || cause.getClass().getName().equals("com.jcraft.jsch.JSchException")) {
            return new SshFailedErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof SQLException) {
            return new SQLErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof ClassNotFoundException) {
            return new DriverClassNotFoundErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof ExecutionException) {
            if (causeMsg.contains("java.lang.ClassNotFoundException")) {
                return new ExecutionDriverClassNotFoundErrorInfo(dataSource, original, cause);
            }
            if (causeMsg.contains("java.lang.InstantiationException")) {
                return new ExecutionDriverClassNotInstantiable(dataSource, original, cause);
            }
            if (causeMsg.contains("java.lang.UnsupportedClassVersionError")) {
                return new ExecutionDriverClassIsIncompatible(dataSource, original, cause);
            }
            return new ExecutionErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof RemoteException) {
            return new RemoteErrorInfo(dataSource, original, cause);
        }
        if (causeMsg.contains("Protocol family unavailable")) {
            return new ProtocolFamilyUnavailableErrorInfo(dataSource, original, cause);
        }
        if (BaseDatabaseErrorHandler.isNoSslProtocol(cause)) {
            return new NoSslProtocolErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof NoRouteToHostException && NetUtils.INSTANCE.getNetworkErrorSolutionMessage(original, false) != null) {
            return new NoRouteToHostErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof EOFException && original instanceof RemoteException) {
            return new DataSourceProcessExitedErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof IOException) {
            return new IOErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof SuppressUserStackTrace) {
            return new SuppressUserStackTraceErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof JdbcEngineUtils.UnsafeUpdateRolledBackException) {
            return new UnsafeUpdateRolledBackErrorInfo(dataSource, original, cause);
        }
        if (cause instanceof ReboundNotPossibleException) {
            return new ReboundNotPossibleErrorInfo(dataSource, (ReboundNotPossibleException)cause);
        }
        if (cause instanceof OutOfMemoryError) {
            return new OutOfMemoryErrorInfo(dataSource, original, cause);
        }
        if (original instanceof NoClassDefFoundError) {
            return new MissingDriverClassErrorInfo(dataSource, original, cause);
        }
        if (original instanceof SQLException && Objects.equals(origMsg, causeMsg)) {
            return new NativeErrorInfo(dataSource, original, cause);
        }
        return new UnknownErrorInfo(dataSource, original, cause);
    }

    protected static boolean isSslHandshake(Throwable cause) {
        return BaseDatabaseErrorHandler.isCausedBy(cause, "javax.net.ssl.SSLHandshakeException");
    }

    private static boolean isCausedBy(Throwable cause, String className) {
        return BaseDatabaseErrorHandler.findByClassName(cause, className) != null;
    }

    @Nullable
    protected static Throwable findByClassName(Throwable cause, String className) {
        return BaseDatabaseErrorHandler.findCause(cause, (Condition<Throwable>)((Condition)e -> BaseDatabaseErrorHandler.getClassName(e).equals(className)));
    }

    @Nullable
    protected static Throwable findCause(Throwable cause, Condition<Throwable> condition) {
        return (Throwable)JBIterable.generate((Object)cause, Throwable::getCause).find(condition);
    }

    @Nullable
    protected static Throwable findByClassNamePrefix(Throwable cause, String classNamePrefix) {
        return BaseDatabaseErrorHandler.findCause(cause, (Condition<Throwable>)((Condition)e -> BaseDatabaseErrorHandler.getClassName(e).startsWith(classNamePrefix)));
    }

    private static String getClassName(@NotNull Throwable e) {
        String string;
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(7);
        }
        if (e instanceof RemoteObject.ForeignException) {
            RemoteObject.ForeignException fe = (RemoteObject.ForeignException)e;
            string = fe.getOriginalClassName();
        } else {
            string = e.getClass().getName();
        }
        return string;
    }

    protected static boolean isNoSslProtocol(Throwable cause) {
        String causeMsg = BaseDatabaseErrorHandler.getMessage(cause);
        return BaseDatabaseErrorHandler.isSslHandshake(cause) && (causeMsg.contains("No appropriate protocol") || causeMsg.contains("protocol_version") || causeMsg.contains("The server selected protocol version"));
    }

    protected static int getOffsetImpl(@NotNull OffsetInfo offsetInfo, @NotNull String queryText, @Nullable StringFinder finder) {
        if (offsetInfo == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(8);
        }
        if (queryText == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(9);
        }
        return BaseDatabaseErrorHandler.getOffsetImpl(offsetInfo.near, offsetInfo.line, offsetInfo.column, queryText, finder);
    }

    protected static int getOffsetImpl(@Nullable String near, int line, int column2, @NotNull String queryText, @Nullable StringFinder finder) {
        int offset;
        if (queryText == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(10);
        }
        int n = line < 0 ? (column2 < 0 ? -1 : column2 - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText, (int)(line - 1), (int)(column2 < 0 ? 0 : column2 - 1)));
        if (line > -1 && column2 > -1) {
            return offset;
        }
        if (near == null || finder == null) {
            return offset;
        }
        int refined = finder.find(queryText, near, offset);
        return refined == -1 ? offset : refined;
    }

    protected static StringFinder byTokenFinder(@NotNull Language language, @NotNull Project project, int cropping) {
        if (language == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(11);
        }
        if (project == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(12);
        }
        return (query, piece, startOffset) -> {
            boolean croppedMode;
            ParserDefinition parser2 = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)language);
            if (parser2 == null) {
                return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
            }
            Lexer lexer = parser2.createLexer(project);
            lexer.start((CharSequence)query);
            boolean bl = croppedMode = piece.length() > cropping;
            while (lexer.getTokenType() != null) {
                if (lexer.getTokenStart() >= startOffset) {
                    boolean matched;
                    boolean bl2 = matched = croppedMode ? StringUtil.startsWithIgnoreCase((String)lexer.getTokenText(), (String)piece) : lexer.getTokenText().equalsIgnoreCase(piece);
                    if (matched) {
                        return lexer.getTokenStart();
                    }
                }
                lexer.advance();
            }
            return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
        };
    }

    @Override
    public boolean isConnectionUnusable(@NotNull Throwable th) {
        if (th == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(13);
        }
        return false;
    }

    protected static boolean isWrapped(@NotNull Throwable th, String clazz) {
        RemoteObject.ForeignException wrapper;
        if (th == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(14);
        }
        return (wrapper = (RemoteObject.ForeignException)ExceptionUtil.findCause((Throwable)th, RemoteObject.ForeignException.class)) != null && wrapper.getOriginalClassName().equals(clazz);
    }

    protected static int getErrorCode(@NotNull Throwable th) {
        if (th == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(15);
        }
        return th instanceof SQLException ? ((SQLException)th).getErrorCode() : 0;
    }

    @Nullable
    protected static String getSqlState(@NotNull Throwable th) {
        if (th == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(16);
        }
        return th instanceof SQLException ? ((SQLException)th).getSQLState() : null;
    }

    @NotNull
    protected static String getMessage(@NotNull Throwable th) {
        if (th == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(17);
        }
        String string = StringUtil.notNullize((String)th.getMessage());
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    protected static Map<String, Serializable> getProperties(@Nullable Throwable th) {
        return th instanceof SQLExceptionWithProperties ? ((SQLExceptionWithProperties)th).getProperties() : null;
    }

    @NotNull
    protected static String getMessagePrefix(@NotNull Throwable th) {
        if (th == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(19);
        }
        String defaultPrefix = GridUtilCore.getMessagePrefix((Throwable)th);
        Map<String, Serializable> properties2 = BaseDatabaseErrorHandler.getProperties(th);
        if (properties2 == null) {
            String string = defaultPrefix;
            if (string == null) {
                BaseDatabaseErrorHandler.$$$reportNull$$$0(20);
            }
            return string;
        }
        List<String> propertyPrefixes = BaseDatabaseErrorHandler.getMessagePropertyPrefixes(properties2);
        String string = defaultPrefix + (String)(propertyPrefixes.isEmpty() ? "" : String.join((CharSequence)", ", propertyPrefixes) + ": ");
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static List<String> getMessagePropertyPrefixes(@NotNull Map<String, Serializable> properties2) {
        Integer columnNumber;
        if (properties2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(22);
        }
        if (SQLExceptionWithProperties.HAS_FINAL_MESSAGE.is(properties2, false)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BaseDatabaseErrorHandler.$$$reportNull$$$0(23);
            }
            return list;
        }
        Integer position = (Integer)SQLExceptionWithProperties.POSITION.get(properties2);
        if (position != null) {
            List<String> list = Collections.singletonList(DatabaseBundle.message("message.text.position.prefix", position));
            if (list == null) {
                BaseDatabaseErrorHandler.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList<String> propertyPrefixes = new ArrayList<String>();
        Integer lineNumber = (Integer)SQLExceptionWithProperties.LINE_NUMBER.get(properties2);
        if (lineNumber != null) {
            propertyPrefixes.add(DatabaseBundle.message("message.text.line.prefix", lineNumber));
        }
        if ((columnNumber = (Integer)SQLExceptionWithProperties.COLUMN_NUMBER.get(properties2)) != null) {
            propertyPrefixes.add(DatabaseBundle.message("message.text.column.prefix", columnNumber));
        }
        ArrayList<String> arrayList = propertyPrefixes;
        if (arrayList == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static String getLongMessage(@NotNull Throwable e) {
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(26);
        }
        Throwable ex = AsyncUtil.unwrap(e);
        String message = GridUtilCore.getLongMessage((Throwable)ex);
        Object object = e == ex ? message : GridUtilCore.getLongMessage((Throwable)e) + "\n" + message;
        if (object == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(27);
        }
        return object;
    }

    public static boolean isMessageAboutThePassword(String user, Throwable e) {
        String message = BaseDatabaseErrorHandler.getLongMessage(e);
        String userPart = StringUtil.isNotEmpty((String)user) ? "|" + StringUtil.escapeToRegexp((String)user) : "";
        String regex = "(?i)\\b(access|denied|password|user|authentication failed" + userPart + ")\\b";
        return Pattern.compile(regex).matcher(message).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 18, 20, 21, 23, 24, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/BaseDatabaseErrorHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 7: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagePrefix";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagePropertyPrefixes";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "byTokenFinder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isConnectionUnusable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWrapped";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getErrorCode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSqlState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMessagePrefix";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMessagePropertyPrefixes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLongMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 18, 20, 21, 23, 24, 25, 27 -> new IllegalStateException(string);
        };
    }

    protected static class HeadlessErrorInfo
    extends DatabaseErrorInfo {
        HeadlessErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                HeadlessErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                HeadlessErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        @Nullable
        public ThreeState isCredentialsProblem() {
            return ThreeState.NO;
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            DbOptionProvider provider;
            if (sb == null) {
                HeadlessErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                HeadlessErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
            LocalDataSource dataSource = this.getDataSource();
            DatabaseDriver driver = dataSource == null ? null : dataSource.getDatabaseDriver();
            DbOptionProvider dbOptionProvider = provider = driver == null ? null : DbOptionProvider.getProvider(driver, DesktopActionsOptionProvider.class);
            if (provider != null && provider.getValue(driver) != RemoteDesktopActionsHandlerImpl.State.DISABLED) {
                sb.append(DatabaseBundle.message("jdbc.driver.is.attempting.to.show.ui.that.conflicts.with.browser.interception.functionality", new Object[0]));
                HeadlessErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.setOption(DatabaseBundle.message("disable.browser.interception", new Object[0]), driver, provider, RemoteDesktopActionsHandlerImpl.State.DISABLED)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$HeadlessErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class UnsupportedOperationErrorInfo
    extends DatabaseErrorInfo {
        UnsupportedOperationErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                UnsupportedOperationErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                UnsupportedOperationErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                UnsupportedOperationErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                UnsupportedOperationErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$UnsupportedOperationErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MissingNativeLibraryErrorInfo
    extends DatabaseErrorInfo {
        protected MissingNativeLibraryErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                MissingNativeLibraryErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MissingNativeLibraryErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.warn(this.myCause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MissingNativeLibraryErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                MissingNativeLibraryErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(DatabaseBundle.message("message.text.native.library.cannot.be.loaded", this.myCause.getMessage()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$MissingNativeLibraryErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SshFailedErrorInfo
    extends DatabaseErrorInfo {
        public SshFailedErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                SshFailedErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                SshFailedErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                SshFailedErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                SshFailedErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(DatabaseBundle.message("ssh.tunnel.creation.failed", new Object[0])).append(" ").append(this.myCause.getMessage());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$SshFailedErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class SQLErrorInfo
    extends DatabaseErrorInfo {
        protected SQLErrorInfo(@NotNull LocalDataSource dataSource, @NotNull Throwable original, Throwable cause) {
            if (original == null) {
                SQLErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                SQLErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                SQLErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                SQLErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            String causeMsg = GridUtilCore.getMessage((Throwable)this.myCause);
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)causeMsg) == -1) {
                SQLException next;
                sb.append(BaseDatabaseErrorHandler.getMessagePrefix(this.myCause)).append(causeMsg);
                Throwable throwable = this.myCause;
                if (throwable instanceof SQLException) {
                    SQLException ex = (SQLException)throwable;
                    v0 = ex.getNextException();
                } else {
                    v0 = next = null;
                }
                if (next != null && next != this.myCause) {
                    sb.append("\n");
                    ErrorInfo nextErrorInfo = BaseDatabaseErrorHandler.this.getErrorInfo(this.getDataSource(), next);
                    sb.append(nextErrorInfo.getMessage());
                    fixes.addAll(nextErrorInfo.getFixes());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$SQLErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DriverClassNotFoundErrorInfo
    extends DatabaseErrorInfo {
        DriverClassNotFoundErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                DriverClassNotFoundErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                DriverClassNotFoundErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                DriverClassNotFoundErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                DriverClassNotFoundErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            this.handleDriverClassNotFound(sb, fixes, this.myCause.getMessage());
        }

        protected final void handleDriverClassNotFound(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes, @Nullable String message) {
            if (sb == null) {
                DriverClassNotFoundErrorInfo.$$$reportNull$$$0(4);
            }
            if (fixes == null) {
                DriverClassNotFoundErrorInfo.$$$reportNull$$$0(5);
            }
            if (this.getDataSource() == null) {
                return;
            }
            sb.append(DatabaseBundle.message("message.driver.class.not.found.text", StringUtil.notNullize((String)message)));
            DatabaseDriver driver = this.getDataSource().getDatabaseDriver();
            DatabaseArtifactList artifactList = DatabaseArtifactLoader.getInstance().getDefaultArtifactList();
            if (driver == null || DbImplUtilCore.hasDriverFiles(this.getDataSource()) && DatabaseDriverUtils.isDriverFilesValid(artifactList, driver.getArtifacts(), this.getDataSource().getOwnClasspath())) {
                DriverClassNotFoundErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.changeDriverClass(driver)));
                return;
            }
            if (driver.getArtifacts().isEmpty()) {
                sb.append(" ").append(DatabaseBundle.message("DataSourceConfigurable.no.driver.files", new Object[0]));
                DriverClassNotFoundErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.editDriver(driver)));
                return;
            }
            boolean downloaded = DatabaseDriverUtils.isDriverFilesUpToDate(artifactList, driver, driver.getArtifacts());
            sb.append(" ").append(DatabaseBundle.message(downloaded ? "DataSourceConfigurable.drivers.not.configured" : "DataSourceConfigurable.drivers.not.downloaded", new Object[0]));
            DriverClassNotFoundErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.switchToLatestDriver(this.getDataSource(), downloaded)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$DriverClassNotFoundErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleDriverClassNotFound";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ExecutionDriverClassNotFoundErrorInfo
    extends DriverClassNotFoundErrorInfo {
        ExecutionDriverClassNotFoundErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                ExecutionDriverClassNotFoundErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                ExecutionDriverClassNotFoundErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                ExecutionDriverClassNotFoundErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                ExecutionDriverClassNotFoundErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            String causeMsg = GridUtilCore.getMessage((Throwable)this.myCause);
            Matcher matcher = Pattern.compile("java\\.lang\\.ClassNotFoundException:\\s+((?:\\w+\\.)*\\w+)").matcher(causeMsg);
            this.handleDriverClassNotFound(sb, fixes, matcher.find() ? matcher.group(1) : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$ExecutionDriverClassNotFoundErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ExecutionDriverClassNotInstantiable
    extends DatabaseErrorInfo {
        ExecutionDriverClassNotInstantiable(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                ExecutionDriverClassNotInstantiable.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                ExecutionDriverClassNotInstantiable.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                ExecutionDriverClassNotInstantiable.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                ExecutionDriverClassNotInstantiable.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            String causeMsg = GridUtilCore.getMessage((Throwable)this.myCause);
            Matcher matcher = Pattern.compile("java\\.lang\\.InstantiationException:\\s+((?:\\w+\\.)*\\w+)").matcher(causeMsg);
            sb.append(DatabaseBundle.message("message.driver.class.not.instantiable", matcher.find() ? matcher.group(1) : ""));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$ExecutionDriverClassNotInstantiable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ExecutionDriverClassIsIncompatible
    extends DatabaseErrorInfo {
        ExecutionDriverClassIsIncompatible(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                ExecutionDriverClassIsIncompatible.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                ExecutionDriverClassIsIncompatible.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                ExecutionDriverClassIsIncompatible.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                ExecutionDriverClassIsIncompatible.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            String causeMsg = GridUtilCore.getMessage((Throwable)this.myCause);
            Matcher matcher = Pattern.compile("java.lang.UnsupportedClassVersionError:\\s+((?:\\w+/)*\\w+)").matcher(causeMsg);
            sb.append(DatabaseBundle.message("message.driver.class.wrong.version", matcher.find() ? matcher.group(1).replace('/', '.') : ""));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$ExecutionDriverClassIsIncompatible";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ExecutionErrorInfo
    extends DatabaseErrorInfo {
        ExecutionErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                ExecutionErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                ExecutionErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.warn(this.myCause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                ExecutionErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                ExecutionErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$ExecutionErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class RemoteErrorInfo
    extends DatabaseErrorInfo {
        RemoteErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                RemoteErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                RemoteErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.warn(this.myCause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                RemoteErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                RemoteErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$RemoteErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ProtocolFamilyUnavailableErrorInfo
    extends DatabaseErrorInfo {
        ProtocolFamilyUnavailableErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                ProtocolFamilyUnavailableErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                ProtocolFamilyUnavailableErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                ProtocolFamilyUnavailableErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                ProtocolFamilyUnavailableErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
            this.addPreferIPv4(fixes);
        }

        private void addPreferIPv4(@NotNull List<ErrorInfo.Fix> fixes) {
            if (fixes == null) {
                ProtocolFamilyUnavailableErrorInfo.$$$reportNull$$$0(4);
            }
            if (this.getDataSource() == null) {
                return;
            }
            if (ProtocolFamilyUnavailableErrorInfo.removeOrRemoveForced(this.getDataSource(), fixes, false)) {
                return;
            }
            DatabaseDriver driver = this.getDataSource().getDatabaseDriver();
            if (driver != null && ProtocolFamilyUnavailableErrorInfo.removeOrRemoveForced(driver, fixes, false)) {
                return;
            }
            boolean idePreferIPv4 = Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")));
            if (idePreferIPv4) {
                if (!ProtocolFamilyUnavailableErrorInfo.removeOrRemoveForced(this.getDataSource(), fixes, true)) {
                    return;
                }
                if (driver != null && !ProtocolFamilyUnavailableErrorInfo.removeOrRemoveForced(driver, fixes, true)) {
                    return;
                }
            }
        }

        private static boolean removeOrRemoveForced(@NotNull Object driverOrDataSource, @NotNull List<ErrorInfo.Fix> fixes, boolean set) {
            if (driverOrDataSource == null) {
                ProtocolFamilyUnavailableErrorInfo.$$$reportNull$$$0(5);
            }
            if (fixes == null) {
                ProtocolFamilyUnavailableErrorInfo.$$$reportNull$$$0(6);
            }
            LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)driverOrDataSource, LocalDataSource.class);
            DatabaseDriver dr = (DatabaseDriver)ObjectUtils.tryCast((Object)driverOrDataSource, DatabaseDriver.class);
            assert (ds != null || dr != null);
            String options = dr == null ? ds.getVmOptions() : dr.getVmOptions();
            String forcedVal = ProtocolFamilyUnavailableErrorInfo.getPropValue(options, "java.net.preferIPv4Stack");
            if (set) {
                if ("false".equals(forcedVal)) {
                    return false;
                }
            } else {
                if (forcedVal == null) {
                    return false;
                }
                if (!"true".equals(forcedVal)) {
                    return true;
                }
            }
            String text2 = set ? DatabaseBundle.message("set.d.0.false.in.1.choice.0.driver.1.data.source.settings", "java.net.preferIPv4Stack", ds == null ? 0 : 1) : DatabaseBundle.message("remove.d.0.from.1.choice.0.driver.1.data.source.settings", "java.net.preferIPv4Stack", ds == null ? 0 : 1);
            ProtocolFamilyUnavailableErrorInfo.setOptionFix(driverOrDataSource, fixes, text2, "java.net.preferIPv4Stack", set ? "false" : null);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driverOrDataSource";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$ProtocolFamilyUnavailableErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPreferIPv4";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeOrRemoveForced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NoSslProtocolErrorInfo
    extends DatabaseErrorInfo {
        private static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";

        protected NoSslProtocolErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                NoSslProtocolErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                NoSslProtocolErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                NoSslProtocolErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                NoSslProtocolErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
            this.addEnableDisabledProtocols(sb, fixes);
        }

        private void addEnableDisabledProtocols(@NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                NoSslProtocolErrorInfo.$$$reportNull$$$0(4);
            }
            if (fixes == null) {
                NoSslProtocolErrorInfo.$$$reportNull$$$0(5);
            }
            if (this.getDataSource() == null) {
                return;
            }
            String disabledRemote = NoSslProtocolErrorInfo.getPropValue(this.getDataSource().getVmOptions(), PROPERTY_TLS_DISABLED_ALGS);
            String disabledLocal = Security.getProperty(PROPERTY_TLS_DISABLED_ALGS);
            String disabled = disabledRemote == null ? disabledLocal : disabledRemote;
            sb.append("\n\n").append(DatabaseBundle.message("required.algorithm.may.be.disabled", disabled));
            NoSslProtocolErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.setOption(DatabaseBundle.message("edit.disabled.algorithms", new Object[0]), this.getDataSource(), PROPERTY_TLS_DISABLED_ALGS, disabled)));
            String[] list = disabled == null ? ArrayUtil.EMPTY_STRING_ARRAY : disabled.split("\\s*,\\s");
            this.addEnableTls(fixes, list, "TLSv1");
            this.addEnableTls(fixes, list, "TLSv1.1");
        }

        private void addEnableTls(@NotNull List<ErrorInfo.Fix> fixes, String[] list, String tls) {
            if (fixes == null) {
                NoSslProtocolErrorInfo.$$$reportNull$$$0(6);
            }
            if (this.getDataSource() == null) {
                return;
            }
            if (ArrayUtil.indexOf((Object[])list, (Object)tls) != -1) {
                String newDisabled = StringUtil.join((Iterable)JBIterable.of((Object[])list).filter(o -> !o.equals(tls)), (String)", ");
                NoSslProtocolErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.setOption(DatabaseBundle.message("enable.0", tls), this.getDataSource(), PROPERTY_TLS_DISABLED_ALGS, newDisabled)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$NoSslProtocolErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addEnableDisabledProtocols";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addEnableTls";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class NoRouteToHostErrorInfo
    extends DatabaseErrorInfo {
        private static final ErrorInfo.Fix openUrl = new ErrorInfo.Fix(){

            @Nls
            public String getName() {
                return IdeCoreBundle.message((String)"mac15.local.network.issue.notification.button", (Object[])new Object[0]);
            }

            public void apply(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseCoreUiService.getInstance().browse("https://youtrack.jetbrains.com/articles/SUPPORT-A-564/Cannot-connect-to-remote-host-No-route-to-host-macOS-15-Sequoia");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/BaseDatabaseErrorHandler$NoRouteToHostErrorInfo$1", "apply"));
            }
        };

        NoRouteToHostErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                NoRouteToHostErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                NoRouteToHostErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.error(this.myCause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                NoRouteToHostErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                NoRouteToHostErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
            fixes.add(openUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$NoRouteToHostErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DataSourceProcessExitedErrorInfo
    extends DatabaseErrorInfo {
        DataSourceProcessExitedErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                DataSourceProcessExitedErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                DataSourceProcessExitedErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                DataSourceProcessExitedErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                DataSourceProcessExitedErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(this.getDataSource() == null ? "unknown data source" : this.getDataSource().getName()).append(": process exited");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$DataSourceProcessExitedErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class IOErrorInfo
    extends DatabaseErrorInfo {
        IOErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                IOErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                IOErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.warn(this.myCause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                IOErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                IOErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(GridUtilCore.getMessage((Throwable)this.myOriginal));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$IOErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class SuppressUserStackTraceErrorInfo
    extends DatabaseErrorInfo {
        SuppressUserStackTraceErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                SuppressUserStackTraceErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                SuppressUserStackTraceErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                SuppressUserStackTraceErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                SuppressUserStackTraceErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$SuppressUserStackTraceErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class UnsafeUpdateRolledBackErrorInfo
    extends DatabaseErrorInfo {
        UnsafeUpdateRolledBackErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                UnsafeUpdateRolledBackErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                UnsafeUpdateRolledBackErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                UnsafeUpdateRolledBackErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                UnsafeUpdateRolledBackErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$UnsafeUpdateRolledBackErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ReboundNotPossibleErrorInfo
    extends DatabaseErrorInfo {
        protected ReboundNotPossibleErrorInfo(@Nullable LocalDataSource dataSource, @NotNull ReboundNotPossibleException exception) {
            if (exception == null) {
                ReboundNotPossibleErrorInfo.$$$reportNull$$$0(0);
            }
            super(dataSource, exception, exception);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                ReboundNotPossibleErrorInfo.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                ReboundNotPossibleErrorInfo.$$$reportNull$$$0(2);
            }
            sb.append(this.myCause.getMessage());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$ReboundNotPossibleErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class OutOfMemoryErrorInfo
    extends DatabaseErrorInfo {
        OutOfMemoryErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                OutOfMemoryErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                OutOfMemoryErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                OutOfMemoryErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                OutOfMemoryErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(DatabaseBundle.message("error.message.remote.oomerror", this.getDataSource() == null ? null : this.getDataSource().getName()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$OutOfMemoryErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MissingDriverClassErrorInfo
    extends DatabaseErrorInfo {
        MissingDriverClassErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                MissingDriverClassErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MissingDriverClassErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.warn(this.myCause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MissingDriverClassErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                MissingDriverClassErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(DatabaseBundle.message("missing.driver.class", this.myOriginal.getMessage()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$MissingDriverClassErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class NativeErrorInfo
    extends DatabaseErrorInfo {
        NativeErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                NativeErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                NativeErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                NativeErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                NativeErrorInfo.$$$reportNull$$$0(3);
            }
            NativeErrorInfo.appendGenericMessage(this.myOriginal, sb);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$NativeErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class UnknownErrorInfo
    extends DatabaseErrorInfo {
        UnknownErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                UnknownErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                UnknownErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.warn(this.myOriginal);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                UnknownErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                UnknownErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$UnknownErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class OffsetInfo {
        int line;
        int column;
        String near;

        public OffsetInfo(int line, int column2, String near) {
            this.line = line;
            this.column = column2;
            this.near = near;
        }
    }

    @FunctionalInterface
    protected static interface StringFinder {
        public int find(@NotNull String var1, @NotNull String var2, int var3);
    }

    protected static class OffsetInfoBuilder {
        private final String message;
        @RegExp
        private final String pattern;
        private int groupNear;
        private int groupLine;
        private int groupColumn;
        private String defaultNear;
        private int defaultLine;
        private int defaultColumn;

        public OffsetInfoBuilder(@NotNull String message, @Nullable @RegExp String pattern) {
            if (message == null) {
                OffsetInfoBuilder.$$$reportNull$$$0(0);
            }
            this.groupNear = -1;
            this.groupLine = -1;
            this.groupColumn = -1;
            this.defaultNear = null;
            this.defaultLine = -1;
            this.defaultColumn = -1;
            this.message = message;
            this.pattern = pattern;
        }

        public OffsetInfoBuilder groupNear(int groupNear) {
            this.groupNear = groupNear;
            return this;
        }

        public OffsetInfoBuilder groupLine(int groupLine) {
            this.groupLine = groupLine;
            return this;
        }

        public OffsetInfoBuilder groupColumn(int groupColumn) {
            this.groupColumn = groupColumn;
            return this;
        }

        public OffsetInfoBuilder defaultNear(String defaultNear) {
            this.defaultNear = defaultNear;
            return this;
        }

        public OffsetInfoBuilder defaultLine(int defaultLine) {
            this.defaultLine = defaultLine;
            return this;
        }

        public OffsetInfoBuilder defaultColumn(int defaultColumn) {
            this.defaultColumn = defaultColumn;
            return this;
        }

        public OffsetInfo build() {
            int column2;
            int line;
            boolean matched;
            Matcher matcher = this.pattern == null ? null : Pattern.compile(this.pattern).matcher(this.message);
            boolean bl = matched = matcher != null && matcher.find();
            int n = this.defaultLine != -1 ? this.defaultLine : (line = matched && this.groupLine > 0 ? StringUtil.parseInt((String)matcher.group(this.groupLine), (int)-1) : -1);
            int n2 = this.defaultColumn != -1 ? this.defaultColumn : (column2 = matched && this.groupColumn > 0 ? StringUtil.parseInt((String)matcher.group(this.groupColumn), (int)-1) : -1);
            String near = this.defaultNear != null ? this.defaultNear : (matched && this.groupNear > 0 ? matcher.group(this.groupNear) : null);
            return new OffsetInfo(line, column2, near);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dialects/BaseDatabaseErrorHandler$OffsetInfoBuilder", "<init>"));
        }
    }

    public static class PasswordIsAboutExpireErrorInfo
    extends DatabaseErrorInfo {
        public PasswordIsAboutExpireErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                PasswordIsAboutExpireErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                PasswordIsAboutExpireErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                PasswordIsAboutExpireErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                PasswordIsAboutExpireErrorInfo.$$$reportNull$$$0(3);
            }
            PasswordIsAboutExpireErrorInfo.appendGenericMessage(this.myOriginal, sb);
            DatabaseFixFactory factory = DatabaseFixFactory.getInstance();
            if (factory != null) {
                ContainerUtil.addIfNotNull(fixes, (Object)factory.changePassword(this.getDataSource()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$PasswordIsAboutExpireErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PasswordExpiredErrorInfo
    extends DatabaseErrorInfo {
        public PasswordExpiredErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                PasswordExpiredErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                PasswordExpiredErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        @Nullable
        public ThreeState isCredentialsProblem() {
            return ThreeState.YES;
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                PasswordExpiredErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                PasswordExpiredErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(DatabaseBundle.message("message.text.password.is.expired", new Object[0]));
            PasswordExpiredErrorInfo.appendGenericMessage(this.myOriginal, sb);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$PasswordExpiredErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class DatabaseErrorInfo
    implements ErrorInfo,
    CredentialsErrorInfo {
        protected final Logger LOG;
        private final LocalDataSource myDataSource;
        protected final Throwable myOriginal;
        protected final Throwable myCause;
        private Pair<@Nls String, List<// Could not load outer class - annotation placement on inner may be incorrect
        ErrorInfo.Fix>> myInfoData;
        private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\n+");

        protected DatabaseErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(1);
            }
            this.LOG = Logger.getInstance(this.getClass());
            this.myDataSource = dataSource;
            this.myOriginal = original;
            this.myCause = cause;
            this.logIfNeeded();
        }

        protected void logIfNeeded() {
        }

        @Override
        @Nullable
        public ThreeState isCredentialsProblem() {
            if (!(this.myOriginal instanceof SQLException)) {
                return ThreeState.NO;
            }
            String user = LocalDataSource.getUsername(this.myDataSource);
            return BaseDatabaseErrorHandler.isMessageAboutThePassword(user, this.myOriginal) ? ThreeState.UNSURE : null;
        }

        @NotNull
        public Throwable getOriginalThrowable() {
            Throwable throwable = this.myOriginal;
            if (throwable == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(2);
            }
            return throwable;
        }

        @NotNull
        @NlsContexts.NotificationContent
        @NlsContexts.DetailedDescription
        public String getMessage() {
            String string = (String)this.getInfoData().first;
            if (string == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public List<ErrorInfo.Fix> getFixes() {
            List list = (List)this.getInfoData().second;
            if (list == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private @NotNull Pair<@Nls @NotNull String, @NotNull List<// Could not load outer class - annotation placement on inner may be incorrect
        ErrorInfo.Fix>> getInfoData() {
            if (this.myInfoData == null) {
                @Nls StringBuilder sb = new StringBuilder();
                ArrayList<ErrorInfo.Fix> fixes = new ArrayList<ErrorInfo.Fix>();
                this.fillInfoData(sb, fixes);
                this.myInfoData = Pair.create((Object)sb.toString().trim(), fixes);
            }
            Pair<String, List<ErrorInfo.Fix>> pair = this.myInfoData;
            if (pair == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(5);
            }
            return pair;
        }

        protected abstract void fillInfoData(@Nls @NotNull StringBuilder var1, @NotNull List<ErrorInfo.Fix> var2);

        protected void appendOriginalPrefixIfNeeded(@Nls @NotNull StringBuilder sb) {
            if (sb == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(6);
            }
            if (this.myOriginal != this.myCause && this.myOriginal instanceof SQLException && !StringUtil.endsWith((CharSequence)GridUtilCore.getMessage((Throwable)this.myOriginal), (CharSequence)GridUtilCore.getMessage((Throwable)this.myCause))) {
                DatabaseErrorInfo.appendGenericMessage(this.myOriginal, sb);
            }
        }

        @Nullable
        public LocalDataSource getDataSource() {
            return this.myDataSource;
        }

        protected static void appendGenericMessage(@NotNull Throwable e, @NotNull StringBuilder sb) {
            String message;
            if (e == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(7);
            }
            if (sb == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(8);
            }
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)(message = GridUtilCore.getMessage((Throwable)e))) == -1) {
                if (message.contains("\n")) {
                    String m = LINE_BREAK_PATTERN.matcher(message).replaceAll(r -> r.group(0) + "\t");
                    sb.append(BaseDatabaseErrorHandler.getMessagePrefix(e).trim());
                    sb.append("\n\t");
                    sb.append(m);
                    sb.append("\n");
                } else {
                    sb.append(BaseDatabaseErrorHandler.getMessagePrefix(e)).append(message).append("\n");
                }
            }
        }

        protected static void addFix(@NotNull List<ErrorInfo.Fix> fixes, @NotNull Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix> factory) {
            DatabaseFixFactory fixFactory;
            if (fixes == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(9);
            }
            if (factory == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(10);
            }
            if ((fixFactory = DatabaseFixFactory.getInstance()) == null) {
                return;
            }
            ErrorInfo.Fix fix = (ErrorInfo.Fix)factory.fun((Object)fixFactory);
            fixes.add(fix);
        }

        protected static void setOptionFix(@NotNull Object driverOrDataSource, @NotNull List<ErrorInfo.Fix> fixes, @NotNull @Nls String text2, @NotNull String name2, @Nullable String val) {
            if (driverOrDataSource == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(11);
            }
            if (fixes == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(12);
            }
            if (text2 == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(13);
            }
            if (name2 == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(14);
            }
            DatabaseErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> driverOrDataSource instanceof LocalDataSource ? f.setOption(text2, (LocalDataSource)driverOrDataSource, name2, val) : f.setOption(text2, (DatabaseDriver)driverOrDataSource, name2, val)));
        }

        @Nullable
        protected static String getPropValue(@Nullable String options, @NotNull String prop) {
            if (prop == null) {
                DatabaseErrorInfo.$$$reportNull$$$0(15);
            }
            ParametersList dsParams = new ParametersList();
            dsParams.addParametersString(options);
            return dsParams.getPropertyValue(prop);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$DatabaseErrorInfo";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driverOrDataSource";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prop";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler$DatabaseErrorInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalThrowable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixes";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfoData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "appendOriginalPrefixIfNeeded";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "appendGenericMessage";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addFix";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "setOptionFix";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getPropValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static interface CredentialsErrorInfo {
        @Nullable(value="no answer")
        public @Nullable(value="no answer") ThreeState isCredentialsProblem();
    }
}

