/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.util.DbSqlUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0000H&J\f\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H&J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH&J\b\u0010\t\u001a\u00020\nH&\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/base/generator/RefQualification;", "", "<init>", "()V", "parent", "getMetaObject", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getName", "", "isPlain", "", "Companion", "Resolved", "UnResolved", "Lcom/intellij/database/dialects/base/generator/RefQualification$Resolved;", "Lcom/intellij/database/dialects/base/generator/RefQualification$UnResolved;", "intellij.database.dialects.base"})
public abstract class RefQualification {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private RefQualification() {
    }

    @Nullable
    public abstract RefQualification parent();

    @NotNull
    public abstract BasicMetaObject<?> getMetaObject();

    @Nullable
    public abstract String getName();

    public abstract boolean isPlain();

    public /* synthetic */ RefQualification(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/base/generator/RefQualification$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/database/dialects/base/generator/RefQualification;", "info", "Lcom/intellij/database/model/properties/BasicReferenceInfo;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nRefQualification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefQualification.kt\ncom/intellij/database/dialects/base/generator/RefQualification$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RefQualification create(@NotNull BasicReferenceInfo<?> info2) {
            BasicMetaObject forcedMeta;
            BasicMetaObject basicMetaObject;
            BasicMetaObject basicMetaObject2;
            Object[] objectArray;
            Object obj2;
            Intrinsics.checkNotNullParameter(info2, (String)"info");
            BasicReferenceInfo<?> $this$create_u24lambda_u245 = info2;
            boolean bl = false;
            Object obj3 = obj2 = $this$create_u24lambda_u245.getTarget();
            if (obj3 != null) {
                Intrinsics.checkNotNull(obj3);
                Object it = obj2;
                boolean bl2 = false;
                return new Resolved((BasicElement)it);
            }
            Object[] it = objectArray = $this$create_u24lambda_u245.getReference().getKind($this$create_u24lambda_u245.getReferenceDesc());
            boolean bl3 = false;
            Object object = !Intrinsics.areEqual((Object)it, (Object)ObjectKind.NONE) ? objectArray : null;
            if (object != null) {
                Object object2;
                block7: {
                    Object[] forced = object;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue($this$create_u24lambda_u245.getReferenceDesc().targets, (String)"targets");
                    for (Object object3 : (Object[])$this$create_u24lambda_u245.getReferenceDesc().targets) {
                        BasicMetaObject it2 = (BasicMetaObject)object3;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it2.kind, (Object)forced)) continue;
                        object2 = object3;
                        break block7;
                    }
                    object2 = null;
                }
                basicMetaObject2 = (BasicMetaObject)object2;
            } else {
                basicMetaObject2 = null;
            }
            if ((basicMetaObject = (forcedMeta = basicMetaObject2)) == null) {
                BasicMetaObject<?> basicMetaObject3;
                Intrinsics.checkNotNullExpressionValue($this$create_u24lambda_u245.getReferenceDesc().targets, (String)"targets");
                objectArray = $this$create_u24lambda_u245.getReferenceDesc().targets;
                int n = 0;
                if (n < objectArray.length) {
                    basicMetaObject3 = objectArray[n];
                } else {
                    int it3 = n;
                    boolean bl6 = false;
                    basicMetaObject3 = info2.getSource().getMetaObject();
                }
                basicMetaObject = basicMetaObject3;
            }
            BasicMetaObject anyMeta = basicMetaObject;
            BasicReference basicReference = $this$create_u24lambda_u245.getReference();
            Intrinsics.checkNotNullExpressionValue((Object)basicReference, (String)"getReference(...)");
            Intrinsics.checkNotNull(anyMeta);
            return new UnResolved(basicReference, anyMeta, 0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0016J\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/base/generator/RefQualification$Resolved;", "Lcom/intellij/database/dialects/base/generator/RefQualification;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "<init>", "(Lcom/intellij/database/model/basic/BasicElement;)V", "parent", "getMetaObject", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getName", "", "isPlain", "", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nRefQualification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefQualification.kt\ncom/intellij/database/dialects/base/generator/RefQualification$Resolved\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
    private static final class Resolved
    extends RefQualification {
        @NotNull
        private final BasicElement element;

        public Resolved(@NotNull BasicElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(null);
            this.element = element;
        }

        @Override
        @Nullable
        public RefQualification parent() {
            Resolved resolved;
            BasicElement basicElement = this.element.getParent();
            if (basicElement != null) {
                BasicElement it = basicElement;
                boolean bl = false;
                resolved = new Resolved(it);
            } else {
                resolved = null;
            }
            return resolved;
        }

        @Override
        @NotNull
        public BasicMetaObject<?> getMetaObject() {
            BasicMetaObject<?> basicMetaObject = this.element.getMetaObject();
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
            return basicMetaObject;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.element.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        public boolean isPlain() {
            return !DbSqlUtilCore.isQuoted(this.element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0016J\f\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/base/generator/RefQualification$UnResolved;", "Lcom/intellij/database/dialects/base/generator/RefQualification;", "ref", "Lcom/intellij/database/model/properties/BasicReference;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "idx", "", "<init>", "(Lcom/intellij/database/model/properties/BasicReference;Lcom/intellij/database/model/meta/BasicMetaObject;I)V", "hasParent", "", "parent", "getMetaObject", "getName", "", "isPlain", "intellij.database.dialects.base"})
    private static final class UnResolved
    extends RefQualification {
        @NotNull
        private final BasicReference ref;
        @NotNull
        private final BasicMetaObject<?> meta;
        private final int idx;

        public UnResolved(@NotNull BasicReference ref2, @NotNull BasicMetaObject<?> meta, int idx) {
            Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
            Intrinsics.checkNotNullParameter(meta, (String)"meta");
            super(null);
            this.ref = ref2;
            this.meta = meta;
            this.idx = idx;
        }

        private final boolean hasParent() {
            return SequencesKt.elementAtOrNull((Sequence)SequencesKt.generateSequence((Object)this.ref, UnResolved::hasParent$lambda$0), (int)(this.idx + 1)) != null;
        }

        @Override
        @Nullable
        public RefQualification parent() {
            RefQualification refQualification;
            if (this.meta.getParent() != null && this.hasParent()) {
                BasicMetaObject<?> basicMetaObject = this.meta.getParent();
                Intrinsics.checkNotNull(basicMetaObject);
                refQualification = new UnResolved(this.ref, basicMetaObject, this.idx + 1);
            } else {
                refQualification = null;
            }
            return refQualification;
        }

        @Override
        @NotNull
        public BasicMetaObject<?> getMetaObject() {
            return this.meta;
        }

        @Override
        @Nullable
        public String getName() {
            return this.ref.getParentName(this.idx);
        }

        @Override
        public boolean isPlain() {
            return this.idx == 0 && this.ref.isPlain();
        }

        private static final BasicReference hasParent$lambda$0(BasicReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.subReference();
        }
    }
}

