/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.dataSource.ConfigUrlBean;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.ide.PlatformIdeService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.SafeFileOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

@Service
public final class ModelExternalData {
    private static final Logger LOG = Logger.getInstance(ModelExternalData.class);
    private static final ExtensionPointName<ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.modelExternalData");
    private static final String EXTERNAL_DATA_PATH = "EXTERNAL_DATA_PATH";
    private final MultiMap<Dbms, Data> myDataByDbms = MultiMap.createLinkedSet();
    private final Map<String, Pair<Data, Long>> myDataByFile = ContainerUtil.createSoftValueMap();

    public static ModelExternalData getInstance() {
        return (ModelExternalData)ApplicationManager.getApplication().getService(ModelExternalData.class);
    }

    public ModelExternalData() {
        try {
            for (URL url : ConfigUrlBean.getUrls(CONFIG_EP.getExtensionsIfPointIsRegistered())) {
                try {
                    InputStream stream = url.openStream();
                    try {
                        this.loadConfig(stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to load " + url.toExternalForm(), (Throwable)e);
                }
            }
        }
        catch (Throwable th) {
            LOG.error("Failed to load model external data", th);
        }
    }

    private void loadConfig(@NotNull InputStream stream) {
        if (stream == null) {
            ModelExternalData.$$$reportNull$$$0(0);
        }
        this.loadConfig(ModelExternalData.createReader(stream));
    }

    @NotNull
    private static HierarchicalStreamReader createReader(@NotNull InputStream stream) {
        if (stream == null) {
            ModelExternalData.$$$reportNull$$$0(1);
        }
        return new XppReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new MXParser());
    }

    private void loadConfig(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(2);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.loadData(reader);
            reader.moveUp();
        }
    }

    private void loadData(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(3);
        }
        if (!"data".equals(reader.getNodeName())) {
            return;
        }
        String dbms = reader.getAttribute("dbms");
        if (dbms == null) {
            return;
        }
        Data data = ModelExternalData.loadDataInner(reader);
        for (String s : StringUtil.tokenize((String)dbms, (String)",")) {
            boolean found = false;
            for (Dbms d : Dbms.allValues(HSet.create(s))) {
                found = true;
                this.myDataByDbms.putValue((Object)d, (Object)data);
            }
            if (found) continue;
            LOG.warn("No dbms " + s);
        }
    }

    @NotNull
    private static Data loadDataInner(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(4);
        }
        Data data = new Data();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ModelExternalData.loadObjectSet(data.objSet, reader);
            reader.moveUp();
        }
        Data data2 = data;
        if (data2 == null) {
            ModelExternalData.$$$reportNull$$$0(5);
        }
        return data2;
    }

    private static void loadObjectSet(@NotNull @NotNull MultiMap<@NotNull ObjectPath, ObjDesc> objSet, @NotNull HierarchicalStreamReader reader) {
        if (objSet == null) {
            ModelExternalData.$$$reportNull$$$0(6);
        }
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(7);
        }
        if (!"object-set".equals(reader.getNodeName()) && !"table-set".equals(reader.getNodeName())) {
            return;
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ModelExternalData.loadObjects(objSet, reader);
            reader.moveUp();
        }
    }

    private static void loadObjects(@NotNull @NotNull MultiMap<@NotNull ObjectPath, ObjDesc> objSet, @NotNull HierarchicalStreamReader reader) {
        if (objSet == null) {
            ModelExternalData.$$$reportNull$$$0(8);
        }
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(9);
        }
        ObjectPath objectPath = ModelExternalData.getPath(reader, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ObjDesc desc = ModelExternalData.loadFkDesc(reader);
            if (desc == null) {
                desc = ModelExternalData.loadColDesc(reader);
            }
            if (desc == null) {
                desc = ModelExternalData.loadViewDesc(reader);
            }
            if (desc != null) {
                objSet.putValue((Object)objectPath, (Object)desc);
            } else {
                LOG.warn("Failed to load " + reader.getNodeName());
            }
            reader.moveUp();
        }
    }

    private static FkDesc loadFkDesc(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(10);
        }
        ObjectPath ref2 = ModelExternalData.getPath(reader, true);
        String from = reader.getAttribute("from");
        if (from == null) {
            return null;
        }
        String to = reader.getAttribute("to");
        if (to == null) {
            LOG.warn("Missing to attr");
            return null;
        }
        String name2 = reader.getAttribute("name");
        return new FkDesc(StringUtil.nullize((String)name2), StringUtil.split((String)from, (String)","), ref2, StringUtil.split((String)to, (String)","));
    }

    private static ColDesc loadColDesc(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(11);
        }
        if (!"column".equals(reader.getNodeName())) {
            return null;
        }
        String expr = reader.getAttribute("expr");
        if (expr == null) {
            LOG.warn("Missing expr attr");
            return null;
        }
        String name2 = reader.getAttribute("name");
        return new ColDesc(name2, expr);
    }

    private static ViewDesc loadViewDesc(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(12);
        }
        if (!"view".equals(reader.getNodeName())) {
            return null;
        }
        String query = reader.getAttribute("query");
        if (query == null) {
            LOG.warn("Missing query attr");
            return null;
        }
        String name2 = reader.getAttribute("name");
        return new ViewDesc(name2, query);
    }

    @Nullable
    private static ObjectPath getPath(@NotNull HierarchicalStreamReader reader, boolean opt) {
        ObjectKind kind;
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(13);
        }
        if ((kind = ObjectKind.getKind(reader.getNodeName())) == null) {
            if (!opt) {
                LOG.warn("Invalid table kind " + reader.getNodeName());
            }
            return null;
        }
        String path = reader.getAttribute("path");
        return path == null && opt && kind != ObjectKind.ROOT ? null : ModelExternalData.loadPath(path, kind);
    }

    @Nullable
    private static ObjectPath loadPath(@Nullable String path, @NotNull ObjectKind kind) {
        if (kind == null) {
            ModelExternalData.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmpty((String)path) && kind == ObjectKind.ROOT) {
            return ObjectPath.create("", ObjectKind.ROOT);
        }
        if (path == null) {
            LOG.warn("Missing `path` attr");
            return null;
        }
        String[] split = path.split("\\.");
        if (split.length > 3) {
            LOG.warn("Path should be no longer than db.sc.tab, but it is " + path);
            return null;
        }
        ObjectPath p2 = null;
        for (int i2 = 0; i2 < split.length; ++i2) {
            int pd = split.length - i2 - 1;
            ObjectKind k = pd == 0 ? kind : (pd == 1 ? ObjectKind.SCHEMA : ObjectKind.DATABASE);
            p2 = ObjectPath.create(split[i2], k, true, null, p2);
        }
        return p2;
    }

    @NotNull
    public JBIterable<Data> getDataSourceData(@NotNull LocalDataSource dataSource, boolean editableOnly) {
        JBIterable data;
        if (dataSource == null) {
            ModelExternalData.$$$reportNull$$$0(15);
        }
        Data dsData = this.getDataSourceData(dataSource);
        JBIterable jBIterable = data = editableOnly ? JBIterable.empty() : JBIterable.from((Iterable)this.myDataByDbms.get((Object)dataSource.getDbms()));
        if (dsData != null) {
            data = data.append((Object)dsData);
        }
        JBIterable jBIterable2 = data;
        if (jBIterable2 == null) {
            ModelExternalData.$$$reportNull$$$0(16);
        }
        return jBIterable2;
    }

    @Nullable
    private Data getDataSourceData(@NotNull LocalDataSource dataSource) {
        String path;
        if (dataSource == null) {
            ModelExternalData.$$$reportNull$$$0(17);
        }
        return (path = ModelExternalData.getExternalDataPath(dataSource)) == null ? null : this.getData(path);
    }

    @NotNull
    public static <T> JBIterable<T> extract(@NotNull @NotNull MultiMap<@NotNull ObjectPath, T> ts2, @Nullable ObjectPath path) {
        if (ts2 == null) {
            ModelExternalData.$$$reportNull$$$0(18);
        }
        JBIterable jBIterable = path == null ? JBIterable.empty() : JBIterable.from((Iterable)ts2.get((Object)path)).append(ModelExternalData.extract(ts2, ModelExternalData.trimStart(path)));
        if (jBIterable == null) {
            ModelExternalData.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @NotNull
    public static <T> JBIterable<T> extract(@NotNull Data d, @NotNull ObjectPath path, Class<T> c2) {
        if (d == null) {
            ModelExternalData.$$$reportNull$$$0(20);
        }
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(21);
        }
        JBIterable jBIterable = ModelExternalData.extract(d.objSet, path).filter(c2);
        if (jBIterable == null) {
            ModelExternalData.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    @Nullable
    private static ObjectPath trimStart(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        if (path.parent == null) {
            if (path.name.isEmpty()) {
                return null;
            }
            return ObjectPath.create("", path.kind);
        }
        return ObjectPath.create(path.name, path.kind, path.isQuoted(), path.getIdentity(), ModelExternalData.trimStart(path.parent));
    }

    @NlsSafe
    public static @SystemDependent @Nullable String getExternalDataPath(@NotNull LocalDataSource ds) {
        if (ds == null) {
            ModelExternalData.$$$reportNull$$$0(23);
        }
        return StringUtil.nullize((String)ds.getAdditionalProperty(EXTERNAL_DATA_PATH));
    }

    public static void setExternalDataPath(@NotNull LocalDataSource ds, @SystemDependent @Nullable String path) {
        if (ds == null) {
            ModelExternalData.$$$reportNull$$$0(24);
        }
        ds.setAdditionalProperty(EXTERNAL_DATA_PATH, StringUtil.nullize((String)path));
    }

    @Nullable
    private static DasObject resolveSimilar(@Nullable DasObject anchor, @Nullable ObjectPath path) {
        if (path == null || anchor == null) {
            return anchor;
        }
        DasObject parent = anchor.getDasParent();
        DasObject resolvedParent = ModelExternalData.resolveSimilar(parent, path.parent);
        Condition condition = DbSqlUtilCore.byName(path.name, path.isQuoted(), null, DbImplUtilCore.getCasingProvider(anchor));
        if (parent == resolvedParent && anchor.getKind() == path.kind && condition.value((Object)anchor)) {
            return anchor;
        }
        if (resolvedParent == null) {
            return null;
        }
        return (DasObject)resolvedParent.getDasChildren(path.kind).filter(condition).first();
    }

    @Nullable
    private Data getData(@SystemDependent @NotNull String path) {
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(25);
        }
        File file = new File(path);
        long modified = file.lastModified();
        return this.getData(file, null, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Data getData(File file, @Nullable String canonical, long modified) {
        String key2 = canonical == null ? file.getPath() : canonical;
        Map<String, Pair<Data, Long>> map2 = this.myDataByFile;
        synchronized (map2) {
            Pair<Data, Long> cached = this.myDataByFile.get(key2);
            if (cached != null && (Long)cached.second >= modified) {
                return (Data)cached.first;
            }
        }
        Data res2 = canonical == null ? this.computeCanonicalData(file, modified) : ModelExternalData.computeData(file);
        Map<String, Pair<Data, Long>> map3 = this.myDataByFile;
        synchronized (map3) {
            Pair data = this.myDataByFile.get(key2);
            if (data != null && (Long)data.second >= modified) {
                return (Data)data.first;
            }
            data = Pair.create((Object)res2, (Object)modified);
            this.myDataByFile.put(key2, (Pair<Data, Long>)data);
            return res2;
        }
    }

    @Nullable
    private Data computeCanonicalData(File file, long modified) {
        try {
            String canonical = file.getCanonicalPath();
            if (!file.getPath().equals(canonical)) {
                return this.getData(file, canonical, modified);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return ModelExternalData.computeData(file);
    }

    @Nullable
    private static Data computeData(File file) {
        Data res2 = null;
        if (file.exists()) {
            try (FileInputStream stream = new FileInputStream(file);){
                res2 = ModelExternalData.loadDataInner(ModelExternalData.createReader(stream));
            }
            catch (Throwable e) {
                String message = DatabaseBundle.message("notification.content.unable.to.load", file.getPath());
                LOG.warn(message, e);
                PlatformIdeService.getInstance().notification("Database configuration", PlatformIdeService.NotificationType.ERROR, null, null, message, null, "ModelExternalData.load.failed");
            }
        }
        return res2;
    }

    public static void modify(@NotNull String path, @NotNull Consumer<? super Data> modifier) {
        Data data;
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(26);
        }
        if (modifier == null) {
            ModelExternalData.$$$reportNull$$$0(27);
        }
        if ((data = ModelExternalData.getInstance().getData(path)) == null) {
            data = new Data();
        }
        modifier.consume((Object)data);
        try {
            ModelExternalData.serialize(data, path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void serialize(@NotNull Data data, String path) throws IOException {
        if (data == null) {
            ModelExternalData.$$$reportNull$$$0(28);
        }
        try (SafeFileOutputStream out = new SafeFileOutputStream(new File(path));){
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            PrettyPrintWriter writer = new PrettyPrintWriter(printWriter);
            ModelExternalData.serialize(data, (HierarchicalStreamWriter)writer);
            writer.close();
        }
    }

    private static void serialize(@NotNull Data data, @NotNull HierarchicalStreamWriter writer) {
        if (data == null) {
            ModelExternalData.$$$reportNull$$$0(29);
        }
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(30);
        }
        writer.startNode("data");
        ModelExternalData.serialize(data.objSet, writer);
        writer.endNode();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void serialize(@NotNull @NotNull MultiMap<@NotNull ObjectPath, ObjDesc> objSet, @NotNull HierarchicalStreamWriter writer) {
        if (objSet == null) {
            ModelExternalData.$$$reportNull$$$0(31);
        }
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(32);
        }
        writer.startNode("object-set");
        @NotNull List sorted = ContainerUtil.sorted((Collection)objSet.entrySet(), Map.Entry.comparingByKey(ObjectPaths::compare));
        for (Map.Entry entry : sorted) {
            ModelExternalData.startPathNode(writer, (ObjectPath)entry.getKey(), ObjectKind.ROOT);
            for (ObjDesc o : ContainerUtil.sorted((Collection)((Collection)entry.getValue()))) {
                if (o instanceof FkDesc) {
                    ModelExternalData.serializeRef(writer, (FkDesc)o);
                    continue;
                }
                if (o instanceof ColDesc) {
                    ModelExternalData.serializeCol(writer, (ColDesc)o);
                    continue;
                }
                if (!(o instanceof ViewDesc)) continue;
                ModelExternalData.serializeView(writer, (ViewDesc)o);
            }
            writer.endNode();
        }
        writer.endNode();
    }

    private static void serializeRef(@NotNull HierarchicalStreamWriter writer, @NotNull FkDesc desc) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(33);
        }
        if (desc == null) {
            ModelExternalData.$$$reportNull$$$0(34);
        }
        ModelExternalData.startPathNode(writer, desc.ref, ObjectKind.TABLE);
        if (StringUtil.isNotEmpty((String)desc.name)) {
            writer.addAttribute("name", desc.name);
        }
        writer.addAttribute("from", StringUtil.join(desc.columns, (String)","));
        writer.addAttribute("to", StringUtil.join(desc.refColumns, (String)","));
        writer.endNode();
    }

    private static void serializeCol(@NotNull HierarchicalStreamWriter writer, @NotNull ColDesc desc) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(35);
        }
        if (desc == null) {
            ModelExternalData.$$$reportNull$$$0(36);
        }
        writer.startNode("column");
        if (StringUtil.isNotEmpty((String)desc.name)) {
            writer.addAttribute("name", desc.name);
        }
        writer.addAttribute("expr", desc.expr);
        writer.endNode();
    }

    private static void serializeView(@NotNull HierarchicalStreamWriter writer, @NotNull ViewDesc desc) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(37);
        }
        if (desc == null) {
            ModelExternalData.$$$reportNull$$$0(38);
        }
        writer.startNode("view");
        if (StringUtil.isNotEmpty((String)desc.name)) {
            writer.addAttribute("name", desc.name);
        }
        writer.addAttribute("query", desc.query);
        writer.endNode();
    }

    private static void startPathNode(@NotNull HierarchicalStreamWriter writer, @Nullable ObjectPath path, @NotNull ObjectKind defKind) {
        if (writer == null) {
            ModelExternalData.$$$reportNull$$$0(39);
        }
        if (defKind == null) {
            ModelExternalData.$$$reportNull$$$0(40);
        }
        writer.startNode((path == null ? defKind : path.kind).code());
        if (path != null) {
            writer.addAttribute("path", path.getDisplayName());
        }
    }

    public static JBIterable<ColDesc> getExtraColumns(@Nullable DasDataSource dataSource, boolean editableOnly, @Nullable DasObject table) {
        LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource(dataSource);
        if (lds != null && table instanceof DasTable) {
            return ModelExternalData.getExtraColumns(lds, editableOnly, (DasTable)table);
        }
        return JBIterable.empty();
    }

    public static JBIterable<ColDesc> getExtraColumns(@NotNull LocalDataSource dataSource, boolean editableOnly, @NotNull DasTable table) {
        if (dataSource == null) {
            ModelExternalData.$$$reportNull$$$0(41);
        }
        if (table == null) {
            ModelExternalData.$$$reportNull$$$0(42);
        }
        ModelExternalData instance = ModelExternalData.getInstance();
        ObjectPath path = ObjectPaths.of(table);
        JBIterable<Data> data = instance.getDataSourceData(dataSource, editableOnly);
        return data.flatten(d -> ModelExternalData.extract(d, path, ColDesc.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 16, 19, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelExternalData";
                break;
            }
            case 6: 
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objSet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: 
            case 17: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defKind";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelExternalData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDataInner";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceData";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadConfig";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createReader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDataInner";
                break;
            }
            case 5: 
            case 16: 
            case 19: 
            case 22: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadObjectSet";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadObjects";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFkDesc";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadColDesc";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadViewDesc";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadPath";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceData";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExternalDataPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setExternalDataPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "serializeRef";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "serializeCol";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "serializeView";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "startPathNode";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getExtraColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 16, 19, 22 -> new IllegalStateException(string);
        };
    }

    public static final class Data {
        public MultiMap<@NotNull ObjectPath, ObjDesc> objSet = new MultiMap<ObjectPath, ObjDesc>(CollectionFactory.createCustomHashingStrategyMap(ObjectPaths.SIMPLE_INSENSITIVE_STRATEGY)){

            @NotNull
            protected Collection<ObjDesc> createCollection() {
                return new LinkedHashSet<ObjDesc>();
            }
        };
    }

    public static final class FkDesc
    extends ObjDesc {
        public final String name;
        public final List<String> columns;
        public final ObjectPath ref;
        public final List<String> refColumns;

        public FkDesc(@Nullable String name2, @NotNull List<String> columns, @Nullable ObjectPath ref2, @NotNull List<String> refColumns) {
            if (columns == null) {
                FkDesc.$$$reportNull$$$0(0);
            }
            if (refColumns == null) {
                FkDesc.$$$reportNull$$$0(1);
            }
            this.name = name2;
            this.columns = columns;
            this.ref = ref2;
            this.refColumns = refColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FkDesc)) {
                return false;
            }
            FkDesc desc = (FkDesc)o;
            return Objects.equals(this.name, desc.name) && this.columns.equals(desc.columns) && Objects.equals(this.ref, desc.ref) && this.refColumns.equals(desc.refColumns);
        }

        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                FkDesc.$$$reportNull$$$0(2);
            }
            if (this == desc) {
                return 0;
            }
            if (desc instanceof FkDesc) {
                FkDesc fk = (FkDesc)desc;
                int res2 = ObjectPaths.compare(this.ref, fk.ref);
                if (res2 != 0) {
                    return res2;
                }
                res2 = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)fk.name));
                if (res2 != 0) {
                    return res2;
                }
                res2 = ContainerUtil.compareLexicographically(this.columns, fk.columns);
                if (res2 != 0) {
                    return res2;
                }
                res2 = ContainerUtil.compareLexicographically(this.refColumns, fk.refColumns);
                return res2;
            }
            return super.compareTo(desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.columns, this.ref, this.refColumns);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refColumns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/ModelExternalData$FkDesc";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ColDesc
    extends ObjDesc {
        public final String name;
        public final String expr;

        public ColDesc(@Nullable String name2, @NotNull String expr) {
            if (expr == null) {
                ColDesc.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.expr = expr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColDesc)) {
                return false;
            }
            ColDesc desc = (ColDesc)o;
            return Objects.equals(this.name, desc.name) && this.expr.equals(desc.expr);
        }

        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                ColDesc.$$$reportNull$$$0(1);
            }
            if (this == desc) {
                return 0;
            }
            if (desc instanceof ColDesc) {
                ColDesc c2 = (ColDesc)desc;
                int res2 = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)c2.name));
                if (res2 != 0) {
                    return res2;
                }
                res2 = Comparing.compare((Comparable)((Object)this.expr), (Comparable)((Object)c2.expr));
                return res2;
            }
            return super.compareTo(desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.expr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/ModelExternalData$ColDesc";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ViewDesc
    extends ObjDesc {
        @NotNull
        public final String name;
        public final String query;

        public ViewDesc(@NotNull String name2, @NotNull String query) {
            if (name2 == null) {
                ViewDesc.$$$reportNull$$$0(0);
            }
            if (query == null) {
                ViewDesc.$$$reportNull$$$0(1);
            }
            this.name = name2;
            this.query = query;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ViewDesc)) {
                return false;
            }
            ViewDesc desc = (ViewDesc)o;
            return this.name.equals(desc.name) && this.query.equals(desc.query);
        }

        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                ViewDesc.$$$reportNull$$$0(2);
            }
            if (this == desc) {
                return 0;
            }
            if (desc instanceof ViewDesc) {
                ViewDesc v = (ViewDesc)desc;
                int res2 = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)v.name));
                if (res2 != 0) {
                    return res2;
                }
                res2 = Comparing.compare((Comparable)((Object)this.query), (Comparable)((Object)v.query));
                return res2;
            }
            return super.compareTo(desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.query);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/ModelExternalData$ViewDesc";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ObjDesc
    implements Comparable<ObjDesc> {
        @Override
        public int compareTo(@NotNull ObjDesc desc) {
            if (desc == null) {
                ObjDesc.$$$reportNull$$$0(0);
            }
            if (desc == this) {
                return 0;
            }
            return Comparing.compare((Comparable)((Object)this.getClass().getSimpleName()), (Comparable)((Object)desc.getClass().getSimpleName()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/model/ModelExternalData$ObjDesc", "compareTo"));
        }
    }

    private static final class FakeColumn
    implements DasColumn {
        private final DasTable myTable;
        private final String myName;
        private final DasType myDasType;

        private FakeColumn(DasTable table, String name2, DasType dasType) {
            this.myTable = table;
            this.myName = name2;
            this.myDasType = dasType;
        }

        @Override
        public short getPosition() {
            return 0;
        }

        @Override
        @Nullable
        public DasTable getTable() {
            return this.myTable;
        }

        @Override
        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myDasType;
            if (dasType == null) {
                FakeColumn.$$$reportNull$$$0(0);
            }
            return dasType;
        }

        @Override
        public boolean isNotNull() {
            return false;
        }

        @Override
        @Nullable
        public String getDefault() {
            return null;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                FakeColumn.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FakeColumn.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/model/ModelExternalData$FakeColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class ExtraForeignKey
    extends ModelRelationManager.ExtraRelation {
        private final FkDesc myFk;

        private ExtraForeignKey(@NotNull DasTable table, @NotNull FkDesc fk, @Nullable DasTable refTable) {
            if (table == null) {
                ExtraForeignKey.$$$reportNull$$$0(0);
            }
            if (fk == null) {
                ExtraForeignKey.$$$reportNull$$$0(1);
            }
            super(table, refTable);
            this.myFk = fk;
        }

        @Override
        public String getProviderId() {
            return "External";
        }

        @Override
        public String getRefTableName() {
            return this.myFk.ref == null ? null : this.myFk.ref.name;
        }

        @Override
        public String getRefTableSchema() {
            ObjectPath parent = this.myFk.ref == null ? null : this.myFk.ref.parent;
            return parent == null ? null : parent.name;
        }

        @Override
        public String getRefTableCatalog() {
            ObjectPath parent = this.myFk.ref == null ? null : this.myFk.ref.parent;
            parent = parent == null ? null : parent.parent;
            return parent == null ? null : parent.name;
        }

        @Override
        @NotNull
        public MultiRef<? extends DasTypedObject> getRefColumns() {
            DasTable table = this.getRefTable();
            CasingProvider casingProvider = DbImplUtilCore.getCasingProvider(table);
            MultiRef multiRef = DasUtil.asRef(this.myFk.refColumns, Functions.id(), c2 -> ExtraForeignKey.resolveColumn(table, c2, casingProvider));
            if (multiRef == null) {
                ExtraForeignKey.$$$reportNull$$$0(2);
            }
            return multiRef;
        }

        private static DasColumn resolveColumn(DasTable table, String c2, CasingProvider casingProvider) {
            if (table == null) {
                return null;
            }
            DasColumn res2 = (DasColumn)table.getDasChildren(ObjectKind.COLUMN).filter(DbSqlUtilCore.byName(c2, true, null, casingProvider)).filter(DasColumn.class).first();
            if (res2 != null) {
                return res2;
            }
            return new FakeColumn(table, c2, DasUnresolvedTypeReference.of(DataTypeFactory.of("int")));
        }

        @Override
        @NotNull
        public MultiRef<? extends DasTypedObject> getColumnsRef() {
            CasingProvider casingProvider = DbImplUtilCore.getCasingProvider(this.getTable());
            MultiRef multiRef = DasUtil.asRef(this.myFk.columns, Functions.id(), c2 -> ExtraForeignKey.resolveColumn(this.getTable(), c2, casingProvider));
            if (multiRef == null) {
                ExtraForeignKey.$$$reportNull$$$0(3);
            }
            return multiRef;
        }

        @Override
        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myFk.name);
            if (string == null) {
                ExtraForeignKey.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtraForeignKey)) {
                return false;
            }
            ExtraForeignKey key2 = (ExtraForeignKey)o;
            if (!super.equals(o)) {
                return false;
            }
            return this.myFk.equals(key2.myFk);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myFk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelExternalData$ExtraForeignKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelExternalData$ExtraForeignKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefColumns";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsRef";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ExternalRelations
    implements ModelRelationManager.ModelRelationProvider {
        public static final String ID = "External";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @Nullable DasTable target2) {
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(0);
            }
            Dbms dbms = DbImplUtilCore.getDbms(table);
            JBIterable data = JBIterable.from((Iterable)ModelExternalData.getInstance().myDataByDbms.get((Object)dbms)).append(ExternalRelations.getDataSourceData(project, table));
            return ExternalRelations.getForeignKeys((JBIterable<Data>)data, table, target2);
        }

        public static JBIterable<DasForeignKey> getForeignKeys(@NotNull LocalDataSource dataSource, boolean editableOnly, @NotNull DasTable table) {
            if (dataSource == null) {
                ExternalRelations.$$$reportNull$$$0(1);
            }
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(2);
            }
            ModelExternalData instance = ModelExternalData.getInstance();
            JBIterable<Data> data = instance.getDataSourceData(dataSource, editableOnly);
            return ExternalRelations.getForeignKeys(data, table, null);
        }

        @NotNull
        private static @NotNull JBIterable<@NotNull DasForeignKey> getForeignKeys(@NotNull JBIterable<Data> data, @NotNull DasTable table, @Nullable DasTable target2) {
            if (data == null) {
                ExternalRelations.$$$reportNull$$$0(3);
            }
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(4);
            }
            ObjectPath path = ObjectPaths.of(table);
            JBIterable jBIterable = data.flatten(d -> ModelExternalData.extract(d, path, FkDesc.class)).filter(fk -> ExternalRelations.isApplicable(fk, table, target2)).filterMap(fk -> {
                DasTable refTable = target2 == null ? (DasTable)ObjectUtils.tryCast((Object)ModelExternalData.resolveSimilar(table, fk.ref), DasTable.class) : target2;
                return new ExtraForeignKey(table, (FkDesc)fk, refTable);
            });
            if (jBIterable == null) {
                ExternalRelations.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static Iterable<Data> getDataSourceData(@Nullable Project project, @NotNull DasObject object) {
            if (object == null) {
                ExternalRelations.$$$reportNull$$$0(6);
            }
            return project == null ? JBIterable.empty() : ExternalRelations.getDataSources(project, object).filterMap(ModelExternalData.getInstance()::getDataSourceData);
        }

        private static boolean isApplicable(@NotNull FkDesc fk, @NotNull DasTable table, @Nullable DasTable target2) {
            if (fk == null) {
                ExternalRelations.$$$reportNull$$$0(7);
            }
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(8);
            }
            return target2 == null || ExternalRelations.matches(target2, fk.ref);
        }

        private static boolean matches(@NotNull DasObject obj2, @Nullable ObjectPath path) {
            if (obj2 == null) {
                ExternalRelations.$$$reportNull$$$0(9);
            }
            if (path == null || !path.name.equals(obj2.getName()) || obj2.getKind() != path.kind) {
                return false;
            }
            if (path.parent == null) {
                return true;
            }
            DasObject parent = obj2.getDasParent();
            return parent != null && ExternalRelations.matches(parent, path.parent);
        }

        @NotNull
        private static JBIterable<LocalDataSource> getDataSources(@NotNull Project project, @NotNull DasObject obj2) {
            if (project == null) {
                ExternalRelations.$$$reportNull$$$0(10);
            }
            if (obj2 == null) {
                ExternalRelations.$$$reportNull$$$0(11);
            }
            if (obj2 instanceof DbElement) {
                JBIterable jBIterable = JBIterable.of((Object)DbImplUtilCore.getMaybeLocalDataSource(((DbElement)obj2).getDataSource()));
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(12);
                }
                return jBIterable;
            }
            if (obj2 instanceof BasicElement) {
                DbModelRegistry r = (DbModelRegistry)project.getService(DbModelRegistry.class);
                JBIterable jBIterable = JBIterable.of((Object)DbImplUtilCore.getMaybeLocalDataSource(r.findDbDataSource(obj2)));
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(13);
                }
                return jBIterable;
            }
            if (obj2 instanceof PsiElement) {
                PsiFile file = ((PsiElement)obj2).getContainingFile();
                JBIterable jBIterable = file == null ? JBIterable.empty() : DbSqlUtilCore.getAppropriateDataSources(file, false, true).filterMap(DbImplUtilCore::getMaybeLocalDataSource);
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(14);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ExternalRelations.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 5: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelExternalData$ExternalRelations";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelExternalData$ExternalRelations";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getForeignKeys";
                    break;
                }
                case 5: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSourceData";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSources";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

