/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.run.actions.CustomActionGroupWithPopup;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFileResolveMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0017\u0010\u000b\u001a\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\f2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/run/actions/SetFileResolveModeActionGroup;", "Lcom/intellij/database/run/actions/CustomActionGroupWithPopup;", "Lcom/intellij/psi/PsiFile;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getOwner", "Lorg/jetbrains/annotations/Nullable;", "getPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "owner", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "SetResolveModeAction", "intellij.database.impl"})
public final class SetFileResolveModeActionGroup
extends CustomActionGroupWithPopup<PsiFile> {
    public SetFileResolveModeActionGroup() {
        for (SqlFileResolveMode mode : SqlFileResolveMode.values()) {
            this.add((AnAction)new SetResolveModeAction(mode));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile file = this.getOwner(e);
        if (file == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setText(DbSqlUtilCore.getFileResolveMode((PsiElement)file).getDisplayName());
    }

    @Override
    @Nullable
    protected PsiFile getOwner(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
    }

    @Override
    @NotNull
    protected JBPopup getPopup(@NotNull PsiFile owner, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Ref.ObjectRef popup2 = new Ref.ObjectRef();
        popup2.element = new DescriptionPopup.ResolveModePopup(new DescriptionPopup.ItemSelector<SqlFileResolveMode>(owner, (Ref.ObjectRef<JBPopup>)popup2){
            final /* synthetic */ PsiFile $owner;
            final /* synthetic */ Ref.ObjectRef<JBPopup> $popup;
            {
                this.$owner = $owner;
                this.$popup = $popup;
            }

            public boolean isSelected(SqlFileResolveMode item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return DbSqlUtilCore.getFileResolveMode((PsiElement)this.$owner) == item;
            }

            public void select(SqlFileResolveMode item, AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    DbSqlUtilCore.setFileResolveMode((PsiElement)this.$owner, item);
                    JBPopup jBPopup = (JBPopup)this.$popup.element;
                    if (jBPopup == null) break block0;
                    jBPopup.closeOk(null);
                }
            }
        }).build(context);
        return (JBPopup)popup2.element;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/run/actions/SetFileResolveModeActionGroup$SetResolveModeAction;", "Lcom/intellij/openapi/actionSystem/ex/CheckboxAction;", "Lcom/intellij/openapi/project/DumbAware;", "mode", "Lcom/intellij/sql/psi/SqlFileResolveMode;", "<init>", "(Lcom/intellij/sql/psi/SqlFileResolveMode;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.database.impl"})
    private static final class SetResolveModeAction
    extends CheckboxAction
    implements DumbAware {
        @NotNull
        private final SqlFileResolveMode mode;

        public SetResolveModeAction(@NotNull SqlFileResolveMode mode) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            super(mode.getDisplayName(), mode.getDescription(), null);
            this.mode = mode;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return false;
            }
            PsiFile file = psiFile;
            return DbSqlUtilCore.getFileResolveMode((PsiElement)file) == this.mode;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!state) {
                return;
            }
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return;
            }
            PsiFile file = psiFile;
            DbSqlUtilCore.setFileResolveMode((PsiElement)file, this.mode);
        }
    }
}

