/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.PsiTable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlIntroduceTableAliasIntention;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlInlineTableAliasIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "<init>", "()V", "getFamilyName", "", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isSuitable", "asExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "findAsExpression", "invoke", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlInlineTableAliasIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlInlineTableAliasIntention.kt\ncom/intellij/sql/intentions/SqlInlineTableAliasIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1863#3,2:96\n*S KotlinDebug\n*F\n+ 1 SqlInlineTableAliasIntention.kt\ncom/intellij/sql/intentions/SqlInlineTableAliasIntention\n*L\n65#1:96,2\n*E\n"})
public final class SqlInlineTableAliasIntention
extends SqlBaseElementAtCaretIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"inline.table.alias", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.isSuitable(this.findAsExpression(element));
    }

    public final boolean isSuitable(@Nullable SqlAsExpression asExpression) {
        if (asExpression == null || !(asExpression.getExpression() instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlExpression sqlExpression = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        PsiElement element = ((SqlReferenceExpression)sqlExpression).resolve();
        if (!(element instanceof PsiTable)) {
            return false;
        }
        SqlResultSetExpression topExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, element);
        if (topExpression == null) {
            return false;
        }
        Collection<String> collection = SqlNamesGenerator.collectExistingNames((PsiElement)topExpression, (Condition<? super PsiElement>)((Condition)arg_0 -> SqlInlineTableAliasIntention.isSuitable$lambda$1(arg_0 -> SqlInlineTableAliasIntention.isSuitable$lambda$0(asExpression, arg_0), arg_0)));
        SqlExpression sqlExpression2 = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        return !collection.contains(((SqlReferenceExpression)sqlExpression2).getName());
    }

    private final SqlAsExpression findAsExpression(PsiElement element) {
        Object object;
        SqlAsExpression sqlAsExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlAsExpression.class);
        if (sqlAsExpression != null) {
            SqlAsExpression sqlAsExpression2;
            SqlAsExpression it = sqlAsExpression2 = sqlAsExpression;
            boolean bl = false;
            object = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)it.getNameElement()), (PsiElement)element, (boolean)false) ? sqlAsExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlAsExpression sqlAsExpression = this.findAsExpression(element);
        Intrinsics.checkNotNull((Object)sqlAsExpression);
        this.invoke(sqlAsExpression);
    }

    public final void invoke(@NotNull SqlAsExpression asExpression) {
        Intrinsics.checkNotNullParameter((Object)asExpression, (String)"asExpression");
        SqlExpression sqlExpression = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        PsiElement psiElement = ((SqlReferenceExpression)sqlExpression).resolve();
        PsiTable psiTable = psiElement instanceof PsiTable ? (PsiTable)psiElement : null;
        if (psiTable == null) {
            return;
        }
        PsiTable psiTable2 = psiTable;
        SqlResultSetExpression sqlResultSetExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, psiTable2);
        Intrinsics.checkNotNull((Object)sqlResultSetExpression);
        SqlResultSetExpression topExpression = sqlResultSetExpression;
        SqlExpression sqlExpression2 = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        SqlReferenceExpression expression = (SqlReferenceExpression)sqlExpression2;
        String text2 = expression.getText();
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"getInstance(...)");
        SqlEditorOptions options = sqlEditorOptions;
        SqlEditorOptions.QualificationType qualificationType = options.getTableQualification().and(options.getRefactoringQualification());
        Intrinsics.checkNotNullExpressionValue((Object)qualificationType, (String)"and(...)");
        SqlEditorOptions.QualificationType tableQualification = qualificationType;
        Iterable iterable = ReferencesSearch.search((PsiElement)((PsiElement)asExpression), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)topExpression))).asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"asIterable(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlReferenceExpression referenceFromText;
            PsiElement psiElement2;
            PsiReference it = (PsiReference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getElement(), (String)"getElement(...)");
            if (!(psiElement2 instanceof SqlReferenceExpression)) continue;
            PsiElement parent = ((SqlReferenceExpression)psiElement2).getParent();
            if (parent instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)((SqlReferenceExpression)parent).getQualifierExpression(), (Object)psiElement2) && tableQualification != SqlEditorOptions.QualificationType.ALWAYS) {
                SqlIdentifier sqlIdentifier = ((SqlReferenceExpression)parent).getIdentifier();
                String name2 = sqlIdentifier != null ? sqlIdentifier.getText() : null;
                SqlResultSetExpression top = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)parent, psiTable2);
                if (name2 != null && top != null && !SqlNamesGenerator.collectExistingNames((PsiElement)top, (Condition<? super PsiElement>)((Condition)arg_0 -> SqlInlineTableAliasIntention.invoke$lambda$5$lambda$4(arg_0 -> SqlInlineTableAliasIntention.invoke$lambda$5$lambda$3(asExpression, arg_0), arg_0))).contains(name2)) {
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)parent;
                    SqlReferenceExpression sqlReferenceExpression2 = SqlPsiElementFactory.createReferenceFromText(name2, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2);
                    Intrinsics.checkNotNull((Object)sqlReferenceExpression2);
                    sqlReferenceExpression.replace((PsiElement)sqlReferenceExpression2);
                    continue;
                }
            }
            Intrinsics.checkNotNull((Object)SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2));
            psiElement2.replace((PsiElement)referenceFromText);
        }
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe((PsiElement)asExpression), expression.getReferenceElementType(), (PsiElement)asExpression);
        Intrinsics.checkNotNull((Object)sqlReferenceExpression);
        asExpression.replace((PsiElement)sqlReferenceExpression);
    }

    private static final boolean isSuitable$lambda$0(SqlAsExpression $asExpression, PsiElement it) {
        if (Intrinsics.areEqual((Object)it, (Object)$asExpression)) {
            return true;
        }
        if (it instanceof SqlNameElement && Intrinsics.areEqual((Object)PsiTreeUtil.getParentOfType((PsiElement)it, SqlDefinition.class), (Object)$asExpression)) {
            return true;
        }
        return it instanceof SqlReferenceExpression;
    }

    private static final boolean isSuitable$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean invoke$lambda$5$lambda$3(SqlAsExpression $asExpression, PsiElement node) {
        PsiElement resolved;
        SqlExpression qualifierExpression;
        return node instanceof SqlReferenceExpression && (qualifierExpression = ((SqlReferenceExpression)node).getQualifierExpression()) instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)(resolved = ((SqlReferenceExpression)qualifierExpression).resolve()), (Object)$asExpression);
    }

    private static final boolean invoke$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

