/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCodeBlockElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.sql.psi.stubs.SqlFileStub;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileElementType
extends IStubFileElementType<SqlFileStub> {
    public static final Key<Language> HOST_LANGUAGE = Key.create((String)"FORCED_HOST_LANGUAGE");
    private static final Key<Boolean> PL_SUB_DIALECT = Key.create((String)"PL_SUB_DIALECT");
    public static final int VERSION = 35;

    public SqlFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
    }

    public int getStubVersion() {
        return 35;
    }

    public void indexStub(@NotNull SqlFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            SqlFileElementType.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            SqlFileElementType.$$$reportNull$$$0(1);
        }
    }

    public StubBuilder getBuilder() {
        return new DefaultStubBuilder(){

            @NotNull
            protected SqlFileStub createStubForFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new SqlFileStub((SqlFile)file, SqlFileElementType.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/stubs/SqlFileElementType$1", "createStubForFile"));
            }
        };
    }

    @NotNull
    public String getExternalId() {
        String string = "sql." + this.toString();
        if (string == null) {
            SqlFileElementType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public SqlFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlFileElementType.$$$reportNull$$$0(3);
        }
        return new SqlFileStub(null, this);
    }

    public void serialize(@NotNull SqlFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            SqlFileElementType.$$$reportNull$$$0(4);
        }
        if (stub == null) {
            SqlFileElementType.$$$reportNull$$$0(5);
        }
        super.serialize((PsiFileStub)stub, dataStream);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement outerPsi) {
        if (chameleon == null) {
            SqlFileElementType.$$$reportNull$$$0(6);
        }
        if (outerPsi == null) {
            SqlFileElementType.$$$reportNull$$$0(7);
        }
        PsiElement psi = chameleon.getPsi();
        Language language = this.getLanguageForParser(psi);
        SqlFileElementType.assertPlainSql(chameleon, outerPsi, language);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        PsiElement host = SqlFileElementType.getHostElement(SqlLazyElementTypeImpl.getContextElement(psi));
        Lexer lexer = this.createLexer(parserDefinition, psi, host);
        boolean isPl = SqlFileElementType.isPlSubDialect(psi, host);
        SqlFileElementType.setPlSubDialect(psi, isPl);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(psi.getProject(), chameleon, lexer, language, chameleon.getChars());
        long startTime = System.nanoTime();
        PsiParser parser2 = this.createParser(parserDefinition, psi, host, isPl);
        ASTNode result2 = parser2.parse((IElementType)this, builder).getFirstChildNode();
        ParsingDiagnostics.registerParse((PsiBuilder)builder, (Language)language, (long)(System.nanoTime() - startTime));
        return result2;
    }

    private static void assertPlainSql(@NotNull ASTNode chameleon, @NotNull PsiElement outerPsi, Language language) {
        if (chameleon == null) {
            SqlFileElementType.$$$reportNull$$$0(8);
        }
        if (outerPsi == null) {
            SqlFileElementType.$$$reportNull$$$0(9);
        }
        if (!language.getID().equals("SQL")) {
            return;
        }
        Logger logger2 = Logger.getInstance(SqlFileElementType.class);
        StringBuilder diagnostic = new StringBuilder();
        SqlFileElementType.dumpPath("outer psi", outerPsi, diagnostic, SyntaxTraverser.psiApi(), e -> SqlFileElementType.getHostElement(SqlLazyElementTypeImpl.getContextElement(e)));
        diagnostic.append("\n\n");
        SqlFileElementType.dumpPath("chameleon", chameleon, diagnostic, SyntaxTraverser.astApi(), null);
        logger2.error("Parsing of SQL without dialect should not be invoked", new Attachment[]{new Attachment("paths.txt", diagnostic.toString())});
    }

    private static <T> void dumpPath(String header, @NotNull T start2, StringBuilder diagnostic, SyntaxTraverser.ApiEx<T> api, @Nullable Function<T, T> context) {
        if (start2 == null) {
            SqlFileElementType.$$$reportNull$$$0(10);
        }
        Function parentNContext = n -> JBIterable.of((Object[])new Object[]{api.parent(n), context == null ? null : context.fun(n)}).filterNotNull().unique();
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)JBTreeTraverser.from((Function)parentNContext).withRoot(start2)).traverse().typedIterator();
        diagnostic.append(header).append(":\n");
        while (it.advance()) {
            int depth = it.backtrace().size();
            StringUtil.repeatSymbol((Appendable)diagnostic, (char)'\t', (int)depth);
            diagnostic.append(api.typeOf(it.current())).append("\n");
        }
    }

    public static void setPlSubDialect(PsiElement psi, boolean isPl) {
        PL_SUB_DIALECT.set((UserDataHolder)psi, (Object)(isPl ? Boolean.valueOf(true) : null));
    }

    public static boolean isInPl(PsiElement psi) {
        PsiElement root = PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{SqlCodeBlockElement.class, SqlFile.class});
        return Boolean.TRUE.equals(PL_SUB_DIALECT.get((UserDataHolder)root));
    }

    private static boolean isPlSubDialect(PsiElement psi, PsiElement host) {
        return Boolean.TRUE.equals(PL_SUB_DIALECT.get((UserDataHolder)(psi instanceof SqlCodeBlockElement || host == null ? psi : host)));
    }

    protected PsiParser createParser(@NotNull ParserDefinition parserDefinition, @NotNull PsiElement psi, @Nullable PsiElement host, boolean isPl) {
        if (parserDefinition == null) {
            SqlFileElementType.$$$reportNull$$$0(11);
        }
        if (psi == null) {
            SqlFileElementType.$$$reportNull$$$0(12);
        }
        return parserDefinition.createParser(psi.getProject());
    }

    @NotNull
    protected Lexer createLexer(@NotNull ParserDefinition parserDefinition, @NotNull PsiElement psi, @Nullable PsiElement host) {
        if (parserDefinition == null) {
            SqlFileElementType.$$$reportNull$$$0(13);
        }
        if (psi == null) {
            SqlFileElementType.$$$reportNull$$$0(14);
        }
        Project project = psi.getProject();
        Language hostLanguage = host != null ? SqlPreprocessingLexer.getHostLanguage(host) : (Language)psi.getUserData(HOST_LANGUAGE);
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(project, parserDefinition, hostLanguage);
        if (lexer == null) {
            SqlFileElementType.$$$reportNull$$$0(15);
        }
        return lexer;
    }

    @Nullable
    private static PsiElement getHostElement(PsiElement psi) {
        PsiLanguageInjectionHost host = InjectedLanguageUtilBase.findInjectionHost((PsiElement)psi);
        if (host == null && !(psi instanceof PsiFile)) {
            host = psi.getParent();
        }
        return host;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlFileElementType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerPsi";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlFileElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 2: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doParseContents";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertPlainSql";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dumpPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createParser";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 15 -> new IllegalStateException(string);
        };
    }
}

