/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.CachingArtifactTypeRegistry;
import org.eclipse.aether.internal.impl.collect.CollectStepDataImpl;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyGraphTransformationContext;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DependencyCollectorDelegate
implements DependencyCollector {
    protected static final String CONFIG_PROP_MAX_EXCEPTIONS = "aether.dependencyCollector.maxExceptions";
    protected static final int CONFIG_PROP_MAX_EXCEPTIONS_DEFAULT = 50;
    protected static final String CONFIG_PROP_MAX_CYCLES = "aether.dependencyCollector.maxCycles";
    protected static final int CONFIG_PROP_MAX_CYCLES_DEFAULT = 10;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RemoteRepositoryManager remoteRepositoryManager;
    protected ArtifactDescriptorReader descriptorReader;
    protected VersionRangeResolver versionRangeResolver;

    @Deprecated
    protected DependencyCollectorDelegate() {
    }

    protected DependencyCollectorDelegate(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setVersionRangeResolver(versionRangeResolver);
    }

    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
    }

    public DependencyCollector setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository manager cannot be null");
        return this;
    }

    public DependencyCollector setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.descriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DependencyCollector setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    @Override
    public final CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request2) throws DependencyCollectionException {
        DefaultDependencyNode node;
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request2, "request cannot be null");
        session = this.optimizeSession(session);
        RequestTrace trace = RequestTrace.newChild(request2.getTrace(), request2);
        CollectResult result2 = new CollectResult(request2);
        DependencyTraverser depTraverser = session.getDependencyTraverser();
        VersionFilter verFilter = session.getVersionFilter();
        Dependency root = request2.getRoot();
        List<RemoteRepository> repositories = request2.getRepositories();
        List<Dependency> dependencies = request2.getDependencies();
        List<Dependency> managedDependencies = request2.getManagedDependencies();
        LinkedHashMap<String, Long> stats = new LinkedHashMap<String, Long>();
        long time1 = System.nanoTime();
        if (root != null) {
            ArtifactDescriptorResult descriptorResult;
            List<? extends Version> versions;
            VersionRangeResult rangeResult;
            try {
                VersionRangeRequest rangeRequest = new VersionRangeRequest(root.getArtifact(), request2.getRepositories(), request2.getRequestContext());
                rangeRequest.setTrace(trace);
                rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
                versions = DependencyCollectorDelegate.filterVersions(root, rangeResult, verFilter, new DefaultVersionFilterContext(session));
            }
            catch (VersionRangeResolutionException e) {
                result2.addException(e);
                throw new DependencyCollectionException(result2, e.getMessage());
            }
            Version version = versions.get(versions.size() - 1);
            root = root.setArtifact(root.getArtifact().setVersion(version.toString()));
            try {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(root.getArtifact());
                descriptorRequest.setRepositories(request2.getRepositories());
                descriptorRequest.setRequestContext(request2.getRequestContext());
                descriptorRequest.setTrace(trace);
                descriptorResult = DependencyCollectorDelegate.isLackingDescriptor(root.getArtifact()) ? new ArtifactDescriptorResult(descriptorRequest) : this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
            }
            catch (ArtifactDescriptorException e) {
                result2.addException(e);
                throw new DependencyCollectionException(result2, e.getMessage());
            }
            root = root.setArtifact(descriptorResult.getArtifact());
            if (!session.isIgnoreArtifactDescriptorRepositories()) {
                repositories = this.remoteRepositoryManager.aggregateRepositories(session, repositories, descriptorResult.getRepositories(), true);
            }
            dependencies = this.mergeDeps(dependencies, descriptorResult.getDependencies());
            managedDependencies = this.mergeDeps(managedDependencies, descriptorResult.getManagedDependencies());
            node = new DefaultDependencyNode(root);
            node.setRequestContext(request2.getRequestContext());
            node.setRelocations(descriptorResult.getRelocations());
            node.setVersionConstraint(rangeResult.getVersionConstraint());
            node.setVersion(version);
            node.setAliases(descriptorResult.getAliases());
            node.setRepositories(request2.getRepositories());
        } else {
            node = new DefaultDependencyNode(request2.getRootArtifact());
            node.setRequestContext(request2.getRequestContext());
            node.setRepositories(request2.getRepositories());
        }
        result2.setRoot(node);
        boolean traverse = root == null || depTraverser == null || depTraverser.traverseDependency(root);
        String errorPath = null;
        if (traverse && !dependencies.isEmpty()) {
            DataPool pool = new DataPool(session);
            DefaultDependencyCollectionContext context = new DefaultDependencyCollectionContext(session, request2.getRootArtifact(), root, managedDependencies);
            DefaultVersionFilterContext versionContext = new DefaultVersionFilterContext(session);
            Results results2 = new Results(result2, session);
            this.doCollectDependencies(session, trace, pool, context, versionContext, request2, node, repositories, dependencies, managedDependencies, results2);
            errorPath = results2.getErrorPath();
        }
        long time2 = System.nanoTime();
        DependencyGraphTransformer transformer = session.getDependencyGraphTransformer();
        if (transformer != null) {
            try {
                DefaultDependencyGraphTransformationContext context = new DefaultDependencyGraphTransformationContext(session);
                context.put(TransformationContextKeys.STATS, stats);
                result2.setRoot(transformer.transformGraph(node, context));
            }
            catch (RepositoryException e) {
                result2.addException(e);
            }
        }
        long time3 = System.nanoTime();
        if (this.logger.isDebugEnabled()) {
            stats.put(this.getClass().getSimpleName() + ".collectTime", time2 - time1);
            stats.put(this.getClass().getSimpleName() + ".transformTime", time3 - time2);
            this.logger.debug("Dependency collection stats {}", stats);
        }
        if (errorPath != null) {
            throw new DependencyCollectionException(result2, "Failed to collect dependencies at " + errorPath);
        }
        if (!result2.getExceptions().isEmpty()) {
            throw new DependencyCollectionException(result2);
        }
        return result2;
    }

    protected RequestTrace collectStepTrace(RequestTrace trace, String context, List<DependencyNode> path, Dependency node) {
        return RequestTrace.newChild(trace, new CollectStepDataImpl(context, path, node));
    }

    protected abstract void doCollectDependencies(RepositorySystemSession var1, RequestTrace var2, DataPool var3, DefaultDependencyCollectionContext var4, DefaultVersionFilterContext var5, CollectRequest var6, DependencyNode var7, List<RemoteRepository> var8, List<Dependency> var9, List<Dependency> var10, Results var11);

    protected RepositorySystemSession optimizeSession(RepositorySystemSession session) {
        DefaultRepositorySystemSession optimized = new DefaultRepositorySystemSession(session);
        optimized.setArtifactTypeRegistry(CachingArtifactTypeRegistry.newInstance(session));
        return optimized;
    }

    protected List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive) {
        List<Dependency> result2;
        if (dominant == null || dominant.isEmpty()) {
            result2 = recessive;
        } else if (recessive == null || recessive.isEmpty()) {
            result2 = dominant;
        } else {
            int initialCapacity = dominant.size() + recessive.size();
            result2 = new ArrayList<Dependency>(initialCapacity);
            HashSet<String> ids = new HashSet<String>(initialCapacity, 1.0f);
            for (Dependency dependency : dominant) {
                ids.add(DependencyCollectorDelegate.getId(dependency.getArtifact()));
                result2.add(dependency);
            }
            for (Dependency dependency : recessive) {
                if (ids.contains(DependencyCollectorDelegate.getId(dependency.getArtifact()))) continue;
                result2.add(dependency);
            }
        }
        return result2;
    }

    protected static String getId(Artifact a) {
        return a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getClassifier() + ':' + a.getExtension();
    }

    protected static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d, Collection<Artifact> aliases, List<RemoteRepository> repos, String requestContext) {
        DefaultDependencyNode child = new DefaultDependencyNode(d);
        preManaged.applyTo(child);
        child.setRelocations(relocations);
        child.setVersionConstraint(rangeResult.getVersionConstraint());
        child.setVersion(version);
        child.setAliases(aliases);
        child.setRepositories(repos);
        child.setRequestContext(requestContext);
        return child;
    }

    protected static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d, ArtifactDescriptorResult descriptorResult, DependencyNode cycleNode) {
        DefaultDependencyNode child = DependencyCollectorDelegate.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), cycleNode.getRepositories(), cycleNode.getRequestContext());
        child.setChildren(cycleNode.getChildren());
        return child;
    }

    protected static ArtifactDescriptorRequest createArtifactDescriptorRequest(String requestContext, RequestTrace requestTrace, List<RemoteRepository> repositories, Dependency d) {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(d.getArtifact());
        descriptorRequest.setRepositories(repositories);
        descriptorRequest.setRequestContext(requestContext);
        descriptorRequest.setTrace(requestTrace);
        return descriptorRequest;
    }

    protected static VersionRangeRequest createVersionRangeRequest(String requestContext, RequestTrace requestTrace, List<RemoteRepository> repositories, Dependency dependency) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(dependency.getArtifact());
        rangeRequest.setRepositories(repositories);
        rangeRequest.setRequestContext(requestContext);
        rangeRequest.setTrace(requestTrace);
        return rangeRequest;
    }

    protected VersionRangeResult cachedResolveRangeResult(VersionRangeRequest rangeRequest, DataPool pool, RepositorySystemSession session) throws VersionRangeResolutionException {
        Object key2 = pool.toKey(rangeRequest);
        VersionRangeResult rangeResult = pool.getConstraint(key2, rangeRequest);
        if (rangeResult == null) {
            rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
            pool.putConstraint(key2, rangeResult);
        }
        return rangeResult;
    }

    protected static boolean isLackingDescriptor(Artifact artifact) {
        return artifact.getProperty("localPath", null) != null;
    }

    protected static List<RemoteRepository> getRemoteRepositories(ArtifactRepository repository, List<RemoteRepository> repositories) {
        if (repository instanceof RemoteRepository) {
            return Collections.singletonList((RemoteRepository)repository);
        }
        if (repository != null) {
            return Collections.emptyList();
        }
        return repositories;
    }

    protected static List<? extends Version> filterVersions(Dependency dependency, VersionRangeResult rangeResult, VersionFilter verFilter, DefaultVersionFilterContext verContext) throws VersionRangeResolutionException {
        List<Version> versions;
        if (rangeResult.getVersions().isEmpty()) {
            throw new VersionRangeResolutionException(rangeResult, "No versions available for " + dependency.getArtifact() + " within specified range");
        }
        if (verFilter != null && rangeResult.getVersionConstraint().getRange() != null) {
            verContext.set(dependency, rangeResult);
            try {
                verFilter.filterVersions(verContext);
            }
            catch (RepositoryException e) {
                throw new VersionRangeResolutionException(rangeResult, "Failed to filter versions for " + dependency.getArtifact(), e);
            }
            versions = verContext.get();
            if (versions.isEmpty()) {
                throw new VersionRangeResolutionException(rangeResult, "No acceptable versions for " + dependency.getArtifact() + ": " + rangeResult.getVersions());
            }
        } else {
            versions = rangeResult.getVersions();
        }
        return versions;
    }

    protected static class Results {
        private final CollectResult result;
        final int maxExceptions;
        final int maxCycles;
        String errorPath;

        public Results(CollectResult result2, RepositorySystemSession session) {
            this.result = result2;
            this.maxExceptions = ConfigUtils.getInteger(session, 50, DependencyCollectorDelegate.CONFIG_PROP_MAX_EXCEPTIONS);
            this.maxCycles = ConfigUtils.getInteger(session, 10, DependencyCollectorDelegate.CONFIG_PROP_MAX_CYCLES);
        }

        public String getErrorPath() {
            return this.errorPath;
        }

        public void addException(Dependency dependency, Exception e, List<DependencyNode> nodes2) {
            if (this.maxExceptions < 0 || this.result.getExceptions().size() < this.maxExceptions) {
                this.result.addException(e);
                if (this.errorPath == null) {
                    StringBuilder buffer = new StringBuilder(256);
                    for (DependencyNode node : nodes2) {
                        Dependency dep;
                        if (buffer.length() > 0) {
                            buffer.append(" -> ");
                        }
                        if ((dep = node.getDependency()) == null) continue;
                        buffer.append(dep.getArtifact());
                    }
                    if (buffer.length() > 0) {
                        buffer.append(" -> ");
                    }
                    buffer.append(dependency.getArtifact());
                    this.errorPath = buffer.toString();
                }
            }
        }

        public void addCycle(List<DependencyNode> nodes2, int cycleEntry, Dependency dependency) {
            if (this.maxCycles < 0 || this.result.getCycles().size() < this.maxCycles) {
                this.result.addCycle(new DefaultDependencyCycle(nodes2, cycleEntry, dependency));
            }
        }
    }
}

