/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter;

import com.intellij.jupyter.core.core.impl.project.UtilKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\f"}, d2={"getModuleToRunJupyterServer", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleToRunJupyterServerOrThrow", "getModulePath", "", "module", "getRelativePathFromProjectRoot", "Ljava/nio/file/Path;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterProjectUtil.kt\ncom/intellij/jupyter/core/jupyter/JupyterProjectUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,56:1\n1310#2,2:57\n*S KotlinDebug\n*F\n+ 1 JupyterProjectUtil.kt\ncom/intellij/jupyter/core/jupyter/JupyterProjectUtilKt\n*L\n28#1:57,2\n*E\n"})
public final class JupyterProjectUtilKt {
    @Nullable
    public static final Module getModuleToRunJupyterServer(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        Module module2;
        Object[] modules;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Module module3 = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module3 != null) {
                return module3;
            }
            Object[] $this$firstOrNull$iv = modules = UtilKt.getModules(project);
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Module element$iv;
                Module it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)JupyterProjectUtilKt.getModulePath(it), (Object)project.getBasePath())) continue;
                module2 = element$iv;
                break block3;
            }
            module2 = module = null;
        }
        if (module2 == null) {
            module = (Module)ArraysKt.firstOrNull((Object[])modules);
        }
        return module;
    }

    @Nullable
    public static final Module getModuleToRunJupyterServerOrThrow(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JupyterProjectUtilKt.getModuleToRunJupyterServer(project, file);
    }

    private static final String getModulePath(Module module) {
        String string;
        Object object;
        File moduleDirectory;
        File file = moduleDirectory = new File(module.getModuleFilePath()).getParentFile();
        if (Intrinsics.areEqual((Object)(file != null ? file.getName() : null), (Object)".idea")) {
            moduleDirectory = moduleDirectory.getParentFile();
        }
        if ((object = moduleDirectory) != null && (object = ((File)object).getPath()) != null) {
            Object it = object;
            boolean bl = false;
            string = FileUtil.toSystemIndependentName((String)it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final Path getRelativePathFromProjectRoot(@NotNull VirtualFile $this$getRelativePathFromProjectRoot, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getRelativePathFromProjectRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)project);
        if (projectRoot == null) {
            return VirtualFileUtil.toNioPathOrNull((VirtualFile)$this$getRelativePathFromProjectRoot);
        }
        String string = VfsUtilCore.getRelativePath((VirtualFile)$this$getRelativePathFromProjectRoot, (VirtualFile)projectRoot);
        return string != null ? NioPathUtil.toNioPathOrNull((String)string) : null;
    }
}

