/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputPathWithVariableName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputConvertToCodeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.jupyter.core"})
final class JupyterDataInputConvertToCodeAction
extends AnAction {
    private JupyterDataInputConvertToCodeAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval selectedInterval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (selectedInterval == null || JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(selectedInterval) != JupyterCellType.DATA_INPUT) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Object object = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext2);
        JupyterDataInputCellMetadata metadata = object != null && (object = object.getNotebook()) != null && (object = object.getCellOrNull(selectedInterval.getOrdinal())) != null ? JupyterDataInputCellMetadataKt.getDataInputMetadata((JupyterCell)object) : null;
        e.getPresentation().setEnabled(metadata != null && !((charSequence = (CharSequence)metadata.getFileName()) == null || StringsKt.isBlank((CharSequence)charSequence)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext2);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(notebookFile.getNotebook().getCell(interval2.getOrdinal()));
        if (jupyterDataInputCellMetadata == null) {
            return;
        }
        JupyterDataInputCellMetadata metadata = jupyterDataInputCellMetadata;
        String string = metadata.getFileName();
        if (string == null) {
            return;
        }
        String fileName = string;
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext3);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Path path = editor.getVirtualFile().toNioPath().getParent();
        Intrinsics.checkNotNull((Object)path);
        Path path2 = path.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2;
        String generatedCell = JupyterDataInputUtil.INSTANCE.generateCell(notebookFile, project2, new JupyterDataInputPathWithVariableName(path3, metadata.getVariableName()), DataInputCodeGenerationContext.FOR_CONVERSION);
        Object object = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
        if (object == null || (object = NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)object, generatedCell, NotebookCellLines.CellType.CODE, null, 4, null)) == null) {
            return;
        }
        Object cellText = object;
        WriteCommandAction.writeCommandAction((Project)project2).withName(e.getPresentation().getText()).run(() -> JupyterDataInputConvertToCodeAction.actionPerformed$lambda$0(editor, (String)cellText, interval2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final void actionPerformed$lambda$0(EditorImpl $editor, String $cellText, NotebookCellLines.Interval $interval) {
        NotebookCellConverter.Companion.replaceCellWithUndoSupport((Editor)$editor, $cellText, $interval, NotebookCellLines.Companion.get((Editor)$editor));
    }
}

