/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestProducer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/index/actions/GitStageCompareWithVersionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "currentVersion", "Lgit4idea/index/ContentVersion;", "compareWithVersion", "<init>", "(Lgit4idea/index/ContentVersion;Lgit4idea/index/ContentVersion;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createDiffRequest", "Lcom/intellij/diff/requests/DiffRequest;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lgit4idea/index/GitFileStatus;", "intellij.vcs.git"})
public abstract class GitStageCompareWithVersionAction
extends DumbAwareAction {
    @NotNull
    private final ContentVersion currentVersion;
    @NotNull
    private final ContentVersion compareWithVersion;

    public GitStageCompareWithVersionAction(@NotNull ContentVersion currentVersion, @NotNull ContentVersion compareWithVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentVersion), (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)compareWithVersion), (String)"compareWithVersion");
        this.currentVersion = currentVersion;
        this.compareWithVersion = compareWithVersion;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || !GitStageManagerKt.isStagingAreaAvailable(project) || file == null || file instanceof GitIndexVirtualFile != (this.currentVersion == ContentVersion.STAGED)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"getInstance(...)");
        GitFileStatus status = GitStageTrackerKt.status(gitStageTracker, file);
        e.getPresentation().setVisible(status != null);
        GitFileStatus gitFileStatus = status;
        e.getPresentation().setEnabled(gitFileStatus != null ? GitFileStatusKt.has(gitFileStatus, this.compareWithVersion) : false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        VirtualFile virtualFile2 = GitStageTrackerKt.getRoot(project2, file);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile root = virtualFile2;
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"getInstance(...)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, root, file);
        if (gitFileStatus == null) {
            return;
        }
        GitFileStatus status = gitFileStatus;
        DiffRequestProducer diffRequestProducer = SimpleDiffRequestProducer.create((FilePath)GitIndexVirtualFileKt.filePath(file), () -> GitStageCompareWithVersionAction.actionPerformed$lambda$0(this, project2, root, status));
        Intrinsics.checkNotNullExpressionValue((Object)diffRequestProducer, (String)"create(...)");
        DiffRequestProducer producer = diffRequestProducer;
        DiffManager.getInstance().showDiff(e.getProject(), (DiffRequestChain)SimpleDiffRequestChain.fromProducer((DiffRequestProducer)producer), DiffDialogHints.DEFAULT);
    }

    @NotNull
    public abstract DiffRequest createDiffRequest(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GitFileStatus var3);

    private static final DiffRequest actionPerformed$lambda$0(GitStageCompareWithVersionAction this$0, Project $project, VirtualFile $root, GitFileStatus $status) {
        return this$0.createDiffRequest($project, $root, $status);
    }
}

