/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.shelf;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.vcs.impl.frontend.VcsFrontendConfiguration;
import com.intellij.platform.vcs.impl.frontend.changes.ChangesTreeEditorDiffPreviewKt;
import com.intellij.platform.vcs.impl.frontend.navigation.FrontendNavigateToSourceAction;
import com.intellij.platform.vcs.impl.frontend.shelf.ShelfRenameTreeCellEditor;
import com.intellij.platform.vcs.impl.frontend.shelf.ShelfService;
import com.intellij.platform.vcs.impl.frontend.shelf.ShelfServiceKt;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ShelfTree;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ShelfTreeEditorDiffPreview;
import com.intellij.platform.vcs.impl.shared.changes.PreviewDiffSplitterComponent;
import com.intellij.platform.vcs.impl.shared.rhizome.DiffSplitterEntity;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001d\u001e\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelfToolWindowPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelfTree;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelfTree;Lkotlinx/coroutines/CoroutineScope;)V", "mainPanelContent", "Lcom/intellij/ui/components/panels/Wrapper;", "scrollPane", "Ljavax/swing/JScrollPane;", "shelvePanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "diffEditorPreview", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelfTreeEditorDiffPreview;", "splitterPreview", "Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelfToolWindowPanel$ShelveSplitterDiffPreview;", "vcsConfiguration", "Lcom/intellij/platform/vcs/impl/frontend/VcsFrontendConfiguration;", "updatePanelLayout", "", "isPanelVertical", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "ShelveSplitterDiffPreview", "TogglePreviewAction", "Companion", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public final class ShelfToolWindowPanel
extends SimpleToolWindowPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Wrapper mainPanelContent;
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private BorderLayoutPanel shelvePanel;
    @NotNull
    private final ShelfTreeEditorDiffPreview diffEditorPreview;
    @Nullable
    private ShelveSplitterDiffPreview splitterPreview;
    @NotNull
    private final VcsFrontendConfiguration vcsConfiguration;
    @NotNull
    private static final String SHELVED_CHANGES_TOOLBAR_ID = "ShelvedChangesToolbarFrontend";
    @NotNull
    private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.Companion.get("show.diff.preview.as.editor.tab.with.single.click");
    @NonNls
    @NotNull
    public static final String SHELF_CONTEXT_MENU = "Frontend.Vcs.Shelf.ContextMenu";

    public ShelfToolWindowPanel(@NotNull Project project, @NotNull ShelfTree tree, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(true);
        this.project = project;
        this.mainPanelContent = new Wrapper();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)tree)), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.scrollPane = jScrollPane;
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)this.scrollPane);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(...)");
        this.shelvePanel = borderLayoutPanel;
        this.diffEditorPreview = new ShelfTreeEditorDiffPreview(tree, cs, this.project);
        this.vcsConfiguration = VcsFrontendConfiguration.Companion.getInstance(this.project);
        this.mainPanelContent.setContent((JComponent)this.shelvePanel);
        this.setContent((JComponent)this.mainPanelContent);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction(SHELVED_CHANGES_TOOLBAR_ID);
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        actionGroup.addAll((ActionGroup)anAction);
        actionGroup.add((AnAction)Separator.getInstance());
        actionGroup.add((AnAction)new TogglePreviewAction());
        AnAction showDiffAction = actionManager.getAction("Frontend.ChangesView.ShowDiff");
        showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)tree));
        FrontendNavigateToSourceAction editSourceAction = new FrontendNavigateToSourceAction(false, 1, null);
        editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)tree));
        ActionToolbar actionToolbar = actionManager.createActionToolbar("ShelvedChanges", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent((JComponent)((Object)tree));
        this.shelvePanel.addToTop((Component)toolbar.getComponent());
        tree.setEditable(true);
        tree.setCellEditor(new ShelfRenameTreeCellEditor(tree));
        BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cs, null){
            int label;
            final /* synthetic */ ShelfToolWindowPanel this$0;
            final /* synthetic */ CoroutineScope $cs;
            {
                this.this$0 = $receiver;
                this.$cs = $cs;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ShelfServiceKt.subscribeToDiffPreviewChanged(this.this$0.project, this.$cs, (Function1<? super DiffSplitterEntity, Unit>)((Function1)arg_0 -> 1.invokeSuspend$lambda$0(this.this$0, this.$cs, arg_0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ShelfToolWindowPanel this$0, CoroutineScope $cs, DiffSplitterEntity it) {
                PreviewDiffSplitterComponent splitterComponent = it.getSplitter();
                if (!this$0.isPanelVertical()) {
                    BuildersKt.launch$default((CoroutineScope)$cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, splitterComponent, null){
                        int label;
                        final /* synthetic */ ShelfToolWindowPanel this$0;
                        final /* synthetic */ PreviewDiffSplitterComponent $splitterComponent;
                        {
                            this.this$0 = $receiver;
                            this.$splitterComponent = $splitterComponent;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    ShelfToolWindowPanel.access$setSplitterPreview$p(this.this$0, this.this$0.new ShelveSplitterDiffPreview(this.$splitterComponent));
                                    ShelveSplitterDiffPreview shelveSplitterDiffPreview = ShelfToolWindowPanel.access$getSplitterPreview$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)shelveSplitterDiffPreview);
                                    DiffPreview.Companion.setPreviewVisible((DiffPreview)shelveSplitterDiffPreview, ShelfToolWindowPanel.access$getVcsConfiguration$p(this.this$0).getShelveDetailsPreviewShown());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
                return Unit.INSTANCE;
            }
        }), (int)3, null);
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(cs);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                this.updatePanelLayout();
            }
        });
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)tree)), (String)"ShelvedChangesPopupMenuFrontend", (String)SHELF_CONTEXT_MENU);
    }

    private final void updatePanelLayout() {
        boolean needUpdatePreview;
        boolean hasSplitterPreview = !this.isPanelVertical();
        boolean bl = needUpdatePreview = hasSplitterPreview != (this.splitterPreview != null);
        if (!needUpdatePreview) {
            return;
        }
        ShelfService shelfService = ShelfService.Companion.getInstance(this.project);
        if (!hasSplitterPreview) {
            this.splitterPreview = null;
            shelfService.deleteSplitterPreview();
        } else {
            shelfService.createPreviewDiffSplitter();
        }
    }

    private final boolean isPanelVertical() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Commit");
        return !(toolWindow != null && (toolWindow = toolWindow.getAnchor()) != null ? toolWindow.isHorizontal() : false);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        sink.set(ChangesTreeEditorDiffPreviewKt.getEDITOR_TAB_DIFF_PREVIEW(), (Object)this.diffEditorPreview);
    }

    public static final /* synthetic */ void access$setSplitterPreview$p(ShelfToolWindowPanel $this, ShelveSplitterDiffPreview shelveSplitterDiffPreview) {
        $this.splitterPreview = shelveSplitterDiffPreview;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelfToolWindowPanel$Companion;", "", "<init>", "()V", "SHELVED_CHANGES_TOOLBAR_ID", "", "isOpenEditorDiffPreviewWithSingleClick", "Lcom/intellij/openapi/util/registry/RegistryValue;", "SHELF_CONTEXT_MENU", "intellij.platform.vcs.impl.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelfToolWindowPanel$ShelveSplitterDiffPreview;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "splitterComponent", "Lcom/intellij/platform/vcs/impl/shared/changes/PreviewDiffSplitterComponent;", "<init>", "(Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelfToolWindowPanel;Lcom/intellij/platform/vcs/impl/shared/changes/PreviewDiffSplitterComponent;)V", "getSplitterComponent", "()Lcom/intellij/platform/vcs/impl/shared/changes/PreviewDiffSplitterComponent;", "openPreview", "", "requestFocus", "closePreview", "", "intellij.platform.vcs.impl.frontend"})
    public final class ShelveSplitterDiffPreview
    implements DiffPreview {
        @NotNull
        private final PreviewDiffSplitterComponent splitterComponent;

        public ShelveSplitterDiffPreview(PreviewDiffSplitterComponent splitterComponent) {
            Intrinsics.checkNotNullParameter((Object)splitterComponent, (String)"splitterComponent");
            this.splitterComponent = splitterComponent;
            this.splitterComponent.setFirstComponent((JComponent)ShelfToolWindowPanel.this.shelvePanel);
            ShelfToolWindowPanel.this.mainPanelContent.setContent((JComponent)this.splitterComponent);
        }

        @NotNull
        public final PreviewDiffSplitterComponent getSplitterComponent() {
            return this.splitterComponent;
        }

        public boolean openPreview(boolean requestFocus) {
            return this.splitterComponent.openPreview(requestFocus);
        }

        public void closePreview() {
            this.splitterComponent.closePreview();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelfToolWindowPanel$TogglePreviewAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/intellij/platform/vcs/impl/frontend/shelf/ShelfToolWindowPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.vcs.impl.frontend"})
    public final class TogglePreviewAction
    extends ToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return ShelfToolWindowPanel.this.vcsConfiguration.getShelveDetailsPreviewShown();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ShelveSplitterDiffPreview preview = ShelfToolWindowPanel.this.splitterPreview;
            if (preview != null) {
                DiffPreview.Companion.setPreviewVisible((DiffPreview)preview, state);
                ShelfToolWindowPanel.this.vcsConfiguration.setShelveDetailsPreviewShown(state);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            e.getPresentation().setEnabledAndVisible(isOpenEditorDiffPreviewWithSingleClick.asBoolean() || !ShelfToolWindowPanel.this.isPanelVertical());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

