"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
var react_1 = __importStar(require("react"));
var index_1 = require("./index");
var helpers_1 = require("../helpers");
var SchemaContext = react_1.default.createContext({
    reverse: false,
    deepExpanded: false,
});
var Schema = function (_a) {
    var schemaName = _a.schemaName, schema = _a.schema, _b = _a.required, required = _b === void 0 ? false : _b, _c = _a.isPatternProperty, isPatternProperty = _c === void 0 ? false : _c, _d = _a.isProperty, isProperty = _d === void 0 ? false : _d, _e = _a.isCircular, isCircular = _e === void 0 ? false : _e, dependentRequired = _a.dependentRequired, _f = _a.expanded, propExpanded = _f === void 0 ? false : _f, _g = _a.onlyTitle, onlyTitle = _g === void 0 ? false : _g;
    var _h = (0, react_1.useContext)(SchemaContext), reverse = _h.reverse, deepExpanded = _h.deepExpanded;
    var _j = (0, react_1.useState)(propExpanded), expanded = _j[0], setExpanded = _j[1];
    var _k = (0, react_1.useState)(false), deepExpand = _k[0], setDeepExpand = _k[1];
    (0, react_1.useEffect)(function () {
        setDeepExpand(deepExpanded);
    }, [deepExpanded, setDeepExpand]);
    (0, react_1.useEffect)(function () {
        setExpanded(deepExpand);
    }, [deepExpand, setExpanded]);
    if (!schema ||
        (typeof schemaName === 'string' &&
            ((schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-parser-')) ||
                (schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-schema-private-'))))) {
        return null;
    }
    var dependentSchemas = helpers_1.SchemaHelpers.getDependentSchemas(schema);
    var constraints = helpers_1.SchemaHelpers.humanizeConstraints(schema);
    var externalDocs = schema.externalDocs();
    var renderType = schema.ext(helpers_1.SchemaHelpers.extRenderType) !== false;
    var rawValue = schema.ext(helpers_1.SchemaHelpers.extRawValue) === true;
    var parameterLocation = schema.ext(helpers_1.SchemaHelpers.extParameterLocation);
    var isExpandable = helpers_1.SchemaHelpers.isExpandable(schema) || dependentSchemas;
    var schemaType = helpers_1.SchemaHelpers.toSchemaType(schema);
    isCircular =
        isCircular ||
            schema.isCircular() ||
            schema.ext('x-parser-circular') ||
            false;
    var uid = schema.uid();
    var schemaItems = schema.items();
    if (schemaItems && !Array.isArray(schemaItems)) {
        isCircular =
            isCircular ||
                schemaItems.isCircular() ||
                schemaItems.ext('x-parser-circular') ||
                false;
        if (isCircular &&
            typeof schemaItems.circularSchema === 'function') {
            schemaType = helpers_1.SchemaHelpers.toSchemaType(schemaItems.circularSchema());
        }
    }
    else if (isCircular &&
        typeof schema.circularSchema === 'function') {
        schemaType = helpers_1.SchemaHelpers.toSchemaType(schema.circularSchema());
    }
    var styledSchemaName = isProperty ? 'italic' : '';
    var renderedSchemaName = typeof schemaName === 'string' ? (react_1.default.createElement("span", { className: "break-words text-sm ".concat(styledSchemaName) }, schemaName)) : (schemaName);
    return (react_1.default.createElement(SchemaContext.Provider, { value: { reverse: !reverse, deepExpanded: deepExpand } },
        react_1.default.createElement("div", null,
            react_1.default.createElement("div", { className: "flex py-2" },
                react_1.default.createElement("div", { className: "".concat(onlyTitle ? '' : 'min-w-1/4', " mr-2") },
                    isExpandable && !isCircular ? (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement(index_1.CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded }, renderedSchemaName),
                        react_1.default.createElement("button", { type: "button", onClick: function () { return setDeepExpand(function (prev) { return !prev; }); }, className: "ml-1 text-sm text-gray-500" }, deepExpand ? 'Collapse all' : 'Expand all'))) : (react_1.default.createElement("span", { className: "break-words text-sm ".concat(isProperty ? 'italic' : '') }, schemaName)),
                    isPatternProperty && (react_1.default.createElement("div", { className: "text-gray-500 text-xs italic" }, "(pattern property)")),
                    required && react_1.default.createElement("div", { className: "text-red-600 text-xs" }, "required"),
                    dependentRequired && (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement("div", { className: "text-gray-500 text-xs" }, "required when defined:"),
                        react_1.default.createElement("div", { className: "text-red-600 text-xs" }, dependentRequired.join(', ')))),
                    schema.deprecated() && (react_1.default.createElement("div", { className: "text-red-600 text-xs" }, "deprecated")),
                    schema.writeOnly() && (react_1.default.createElement("div", { className: "text-gray-500 text-xs" }, "write-only")),
                    schema.readOnly() && (react_1.default.createElement("div", { className: "text-gray-500 text-xs" }, "read-only"))),
                rawValue ? (react_1.default.createElement("div", null,
                    react_1.default.createElement("div", { className: "text-sm" }, helpers_1.SchemaHelpers.prettifyValue(schema.const(), false)))) : (react_1.default.createElement("div", null,
                    react_1.default.createElement("div", null,
                        renderType && (react_1.default.createElement("div", { className: "capitalize text-sm text-teal-500 font-bold inline-block mr-2" }, isCircular ? "".concat(schemaType, " [CIRCULAR]") : schemaType)),
                        react_1.default.createElement("div", { className: "inline-block" },
                            schema.format() && (react_1.default.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "format: ",
                                schema.format())),
                            schema.pattern() !== undefined && (react_1.default.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded mr-2 p-1 text-xs" },
                                "must match: ",
                                schema.pattern())),
                            schema.contentMediaType() !== undefined && (react_1.default.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "media type: ",
                                schema.contentMediaType())),
                            schema.contentEncoding() !== undefined && (react_1.default.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "encoding: ",
                                schema.contentEncoding())),
                            !!constraints.length &&
                                constraints.map(function (c) { return (react_1.default.createElement("span", { className: "bg-purple-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs", key: c }, c)); }),
                            uid && !uid.startsWith('<anonymous-') && (react_1.default.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" },
                                "uid: ",
                                uid))),
                        schema.hasDescription() && (react_1.default.createElement("div", null,
                            react_1.default.createElement(index_1.Markdown, null, schema.description()))),
                        schema.default() !== undefined && (react_1.default.createElement("div", { className: "text-xs" },
                            "Default value:",
                            react_1.default.createElement("span", { className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2" }, helpers_1.SchemaHelpers.prettifyValue(schema.default())))),
                        schema.const() !== undefined && (react_1.default.createElement("div", { className: "text-xs" },
                            "Const:",
                            react_1.default.createElement("span", { className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2" }, helpers_1.SchemaHelpers.prettifyValue(schema.const())))),
                        schema.enum() && (react_1.default.createElement("ul", { className: "text-xs" },
                            "Allowed values:",
                            ' ',
                            schema.enum().map(function (e, idx) { return (react_1.default.createElement("li", { key: idx, className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2" },
                                react_1.default.createElement("span", null, helpers_1.SchemaHelpers.prettifyValue(e)))); }))),
                        parameterLocation && (react_1.default.createElement("div", { className: "text-xs" },
                            "Parameter location:",
                            ' ',
                            react_1.default.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" }, parameterLocation))),
                        externalDocs && (react_1.default.createElement("span", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-2 py-0" },
                            react_1.default.createElement(index_1.Href, { href: externalDocs.url(), title: externalDocs.description() || '' }, "Documentation"))),
                        schema.examples() && (react_1.default.createElement("ul", { className: "text-xs" },
                            "Examples values:",
                            ' ',
                            schema.examples().map(function (e, idx) { return (react_1.default.createElement("li", { key: idx, className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2 break-all" },
                                react_1.default.createElement("span", null, helpers_1.SchemaHelpers.prettifyValue(e)))); }))))))),
            isCircular || !isExpandable ? null : (react_1.default.createElement("div", { className: "rounded p-4 py-2 border bg-gray-100 ".concat(reverse ? 'bg-gray-200' : '', " ").concat(expanded ? 'block' : 'hidden') },
                react_1.default.createElement(SchemaProperties, { schema: schema }),
                react_1.default.createElement(SchemaItems, { schema: schema }),
                schema.oneOf() &&
                    schema
                        .oneOf()
                        .map(function (s, idx) { return (react_1.default.createElement(exports.Schema, { key: idx, schema: s, schemaName: idx === 0 ? 'Adheres to:' : 'Or to:' })); }),
                schema.anyOf() &&
                    schema
                        .anyOf()
                        .map(function (s, idx) { return (react_1.default.createElement(exports.Schema, { key: idx, schema: s, schemaName: idx === 0 ? 'Can adhere to:' : 'Or to:' })); }),
                schema.allOf() &&
                    schema
                        .allOf()
                        .map(function (s, idx) { return (react_1.default.createElement(exports.Schema, { key: idx, schema: s, schemaName: idx === 0 ? 'Consists of:' : 'And with:' })); }),
                schema.not() && (react_1.default.createElement(exports.Schema, { schema: schema.not(), schemaName: "Cannot adhere to:" })),
                schema.propertyNames() && (react_1.default.createElement(exports.Schema, { schema: schema.propertyNames(), schemaName: "Property names must adhere to:" })),
                schema.contains() && (react_1.default.createElement(exports.Schema, { schema: schema.contains(), schemaName: "Array must contain at least one of:" })),
                schema.if() && (react_1.default.createElement(exports.Schema, { schema: schema.if(), schemaName: "If schema adheres to:" })),
                schema.then() && (react_1.default.createElement(exports.Schema, { schema: schema.then(), schemaName: "Then must adhere to:" })),
                schema.else() && (react_1.default.createElement(exports.Schema, { schema: schema.else(), schemaName: "Otherwise:" })),
                dependentSchemas && (react_1.default.createElement(exports.Schema, { schema: dependentSchemas, schemaName: "Dependent schemas:" })),
                react_1.default.createElement(index_1.Extensions, { item: schema }),
                react_1.default.createElement(AdditionalProperties, { schema: schema }),
                react_1.default.createElement(AdditionalItems, { schema: schema }))))));
};
exports.Schema = Schema;
var SchemaProperties = function (_a) {
    var schema = _a.schema;
    var properties = schema.properties() || {};
    if (!Object.keys(properties)) {
        return null;
    }
    var required = schema.required() || [];
    var patternProperties = schema.patternProperties();
    var circularProps = schema.ext('x-parser-circular-props') || [];
    return (react_1.default.createElement(react_1.default.Fragment, null,
        Object.entries(properties).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (react_1.default.createElement(exports.Schema, { schema: property, schemaName: propertyName, required: required.includes(propertyName), isProperty: true, isCircular: circularProps.includes(propertyName), dependentRequired: helpers_1.SchemaHelpers.getDependentRequired(propertyName, schema), key: propertyName }));
        }),
        Object.entries(patternProperties).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (react_1.default.createElement(exports.Schema, { schema: property, schemaName: propertyName, isPatternProperty: true, isProperty: true, isCircular: circularProps.includes(propertyName), key: propertyName }));
        })));
};
var AdditionalProperties = function (_a) {
    var schema = _a.schema;
    if (schema.ext(helpers_1.SchemaHelpers.extRenderAdditionalInfo) === false) {
        return null;
    }
    var type = schema.type();
    type = Array.isArray(type) ? type : [type];
    if (!type.includes('object')) {
        return null;
    }
    var additionalProperties = schema.additionalProperties();
    if (additionalProperties === true || additionalProperties === undefined) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional properties are allowed."));
    }
    if (additionalProperties === false) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional properties are ",
            react_1.default.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return (react_1.default.createElement(exports.Schema, { schemaName: "Additional properties:", schema: additionalProperties }));
};
var SchemaItems = function (_a) {
    var schema = _a.schema;
    var type = schema.type();
    type = Array.isArray(type) ? type : [type];
    if (!type.includes('array')) {
        return null;
    }
    var items = schema.items();
    if (items &&
        !Array.isArray(items) &&
        Object.keys(items.properties() || {}).length) {
        return react_1.default.createElement(SchemaProperties, { schema: items });
    }
    else if (Array.isArray(items)) {
        return (react_1.default.createElement(react_1.default.Fragment, null, items.map(function (item, idx) { return (react_1.default.createElement(exports.Schema, { schema: item, schemaName: "".concat(idx + 1, " item:"), key: idx })); })));
    }
    return react_1.default.createElement(exports.Schema, { schema: items, schemaName: "Items:" });
};
var AdditionalItems = function (_a) {
    var schema = _a.schema;
    if (schema.ext(helpers_1.SchemaHelpers.extRenderAdditionalInfo) === false) {
        return null;
    }
    var type = schema.type();
    type = Array.isArray(type) ? type : [type];
    if (!type.includes('array')) {
        return null;
    }
    if (!Array.isArray(schema.items())) {
        return null;
    }
    var additionalItems = schema.additionalItems();
    if (additionalItems === true || additionalItems === undefined) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional items are allowed."));
    }
    if (additionalItems === false) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional items are ",
            react_1.default.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return react_1.default.createElement(exports.Schema, { schemaName: "Additional items:", schema: additionalItems });
};
//# sourceMappingURL=Schema.js.map