# C23 status

cproc implements some C23 features applied to the latest drafts.

## [N2265]: `_Static_assert` without message

C11 required that static assertions always contained a message. C23
now allows `_Static_assert` with just an expression.

## [N2418]: UTF-8 character constants

C23 introduces UTF-8 character constants using the syntax `u8'a'`.
Compared to an unprefixed character constant, they have type `unsigned
char` instead of `int`, and are guaranteed to use UTF-8 encoding
rather than the execution character set. Since the character in a
UTF-8 character constant must have a single-byte UTF-8 encoding,
this type of character constant could be useful when you need the
ASCII value of a character, but do not want to depend on any
particular execution character set.

## [N2508]: Free positioning of labels inside compound statements

In previous revisions of C, labels like `foo:`, `case 123:`, or
`default:` could only precede statements. This was relaxed in C23,
and they can now appear intermixed with declarations in compound
statements.

## [N2510]: Allow unnamed parameters in a function definition

C23 allows you to omit the name of a parameter in the prototype of
a function definition that does not use that parameter.

## [N2549]: Binary integer constants

C23 allows binary integer constants in addition to octal, decimal,
and hexadecimal, using syntax like `0b01101011`.

## [N2900]: Consistent, warningless, and intuitive initialization with {}

C23 allows empty initializers to initialize an object as if it had
static storage duration.

## [N2927]: Not-so-magic typeof for C

C23 adds the `typeof(E)` type specifier to specify type of expression
`E`. Arrays and function designator expressions do not decay into
pointers, just like when used with `sizeof`. You can use a typename
with `typeof` to specify that same type.

C23 also introduces `typeof_unqual`, which behaves the same as
`typeof` except that the specified type is unqualified.

## [N3029]: Improved Normal Enumerations

C23 allows enumerators outside the range of `int`. When an enum
type contains such an enumerator, its type during processing of the
enum is the type of the initializing expression, or the type of the
previous enumerator if there is no initializing expression. In the
latter case, if the type of the previous enumerator can't represent
the current value, an integer type with the same signedness capable
of representing the value is chosen. Outside of an enum containing
a large enumerator, the types of all enumerators are changed to the
the enum type.

## [N3030]: Enhancements to Enumerations

C23 allows enum types with fixed underlying types using syntax like
`enum E : unsigned long`. These enum types are compatible with the
underlying type, and all enumerator constants have the enum type.

Enum types with fixed underlying types are complete by the end of
the underlying type specifier, so they can be forward-declared and
used inside the enum.

[N2265]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n2265.pdf
[N2418]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n2418.pdf
[N2508]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n2508.pdf
[N2510]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n2510.pdf
[N2549]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n2549.pdf
[N2900]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n2900.htm
[N2927]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n2927.htm
[N3029]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n3029.htm
[N3030]: https://www.open-std.org/jtc1/sc22/wg14/www/docs/n3030.htm
