package v1

const VulnerabilityStoreFileName = "vulnerability.db"

// Vulnerability represents the minimum data fields necessary to perform package-to-vulnerability matching. This can represent a CVE, 3rd party advisory, or any source that relates back to a CVE.
type Vulnerability struct {
	ID                   string   // The identifier of the vulnerability or advisory
	RecordSource         string   // The source of the vulnerability information
	PackageName          string   // The name of the package that is vulnerable
	Namespace            string   // The ecosystem where the package resides
	VersionConstraint    string   // The version range which the given package is vulnerable
	VersionFormat        string   // The format which all version fields should be interpreted as
	CPEs                 []string // The CPEs which are considered vulnerable
	ProxyVulnerabilities []string // IDs of other Vulnerabilities that are related to this one (this is how advisories relate to CVEs)
	FixedInVersion       string   // The version which this particular vulnerability was fixed in
}

type VulnerabilityStore interface {
	VulnerabilityStoreReader
	VulnerabilityStoreWriter
}

type VulnerabilityStoreReader interface {
	// GetVulnerability retrieves vulnerabilities associated with a namespace and a package name
	GetVulnerability(namespace, name string) ([]Vulnerability, error)
}

type VulnerabilityStoreWriter interface {
	// AddVulnerability inserts a new record of a vulnerability into the store
	AddVulnerability(vulnerabilities ...Vulnerability) error
}
