/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support;

import java.util.List;

public class MultiException
extends Exception {
    public MultiException(String message) {
        super(message);
    }

    public MultiException(String message, List<Exception> exceptions) {
        super(message);
        if (exceptions != null) {
            for (Exception exception : exceptions) {
                this.addSuppressed(exception);
            }
        }
    }

    @Deprecated
    public void addException(Exception e) {
        this.addSuppressed(e);
    }

    public void throwIfExceptions() throws MultiException {
        if (this.getSuppressed().length > 0) {
            throw this;
        }
    }

    @Deprecated
    public Throwable[] getCauses() {
        return this.getSuppressed();
    }

    public static void throwIf(String message, List<Exception> exceptions) throws MultiException {
        if (exceptions != null && !exceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder(message);
            sb.append(":");
            for (Exception e : exceptions) {
                sb.append("\n\t");
                sb.append(e.getMessage());
            }
            throw new MultiException(sb.toString(), exceptions);
        }
    }
}

