/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusResponse;

public final class WriteMultipleRegistersResponse
extends ModbusResponse {
    private int m_WordCount;
    private int m_Reference;

    public WriteMultipleRegistersResponse() {
    }

    public WriteMultipleRegistersResponse(int reference, int wordcount) {
        this.m_Reference = reference;
        this.m_WordCount = wordcount;
        this.setDataLength(4);
    }

    private void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public int getByteCount() {
        return this.m_WordCount * 2;
    }

    public int getWordCount() {
        return this.m_WordCount;
    }

    private void setWordCount(int count) {
        this.m_WordCount = count;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.getWordCount());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.setReference(din.readUnsignedShort());
        this.setWordCount(din.readUnsignedShort());
        this.setDataLength(4);
    }
}

