// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/ad.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad.
type Ad struct {
	// Output only. The ID of the ad.
	Id *wrappers.Int64Value `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,2,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of final app URLs that will be used on mobile if the user has the
	// specific app installed.
	FinalAppUrls []*common.FinalAppUrl `protobuf:"bytes,35,rep,name=final_app_urls,json=finalAppUrls,proto3" json:"final_app_urls,omitempty"`
	// The list of possible final mobile URLs after all cross-domain redirects
	// for the ad.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,16,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,12,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings that can be used to substitute custom parameter tags
	// in a `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,10,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The URL that appears in the ad description for some ad formats.
	DisplayUrl *wrappers.StringValue `protobuf:"bytes,4,opt,name=display_url,json=displayUrl,proto3" json:"display_url,omitempty"`
	// Output only. The type of ad.
	Type enums.AdTypeEnum_AdType `protobuf:"varint,5,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.AdTypeEnum_AdType" json:"type,omitempty"`
	// Output only. Indicates if this ad was automatically added by Google Ads and not by a
	// user. For example, this could happen when ads are automatically created as
	// suggestions for new ads based on knowledge of how existing ads are
	// performing.
	AddedByGoogleAds *wrappers.BoolValue `protobuf:"bytes,19,opt,name=added_by_google_ads,json=addedByGoogleAds,proto3" json:"added_by_google_ads,omitempty"`
	// The device preference for the ad. You can only specify a preference for
	// mobile devices. When this preference is set the ad will be preferred over
	// other ads when being displayed on a mobile device. The ad can still be
	// displayed on other device types, e.g. if no other ads are available.
	// If unspecified (no device preference), all devices are targeted.
	// This is only supported by some ad types.
	DevicePreference enums.DeviceEnum_Device `protobuf:"varint,20,opt,name=device_preference,json=devicePreference,proto3,enum=google.ads.googleads.v1.enums.DeviceEnum_Device" json:"device_preference,omitempty"`
	// Additional URLs for the ad that are tagged with a unique identifier that
	// can be referenced from other fields in the ad.
	UrlCollections []*common.UrlCollection `protobuf:"bytes,26,rep,name=url_collections,json=urlCollections,proto3" json:"url_collections,omitempty"`
	// Immutable. The name of the ad. This is only used to be able to identify the ad. It
	// does not need to be unique and does not affect the served ad.
	Name *wrappers.StringValue `protobuf:"bytes,23,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. If this ad is system managed, then this field will indicate the source.
	// This field is read-only.
	SystemManagedResourceSource enums.SystemManagedResourceSourceEnum_SystemManagedResourceSource `protobuf:"varint,27,opt,name=system_managed_resource_source,json=systemManagedResourceSource,proto3,enum=google.ads.googleads.v1.enums.SystemManagedResourceSourceEnum_SystemManagedResourceSource" json:"system_managed_resource_source,omitempty"`
	// Details pertinent to the ad type. Exactly one value must be set.
	//
	// Types that are valid to be assigned to AdData:
	//	*Ad_TextAd
	//	*Ad_ExpandedTextAd
	//	*Ad_CallOnlyAd
	//	*Ad_ExpandedDynamicSearchAd
	//	*Ad_HotelAd
	//	*Ad_ShoppingSmartAd
	//	*Ad_ShoppingProductAd
	//	*Ad_GmailAd
	//	*Ad_ImageAd
	//	*Ad_VideoAd
	//	*Ad_ResponsiveSearchAd
	//	*Ad_LegacyResponsiveDisplayAd
	//	*Ad_AppAd
	//	*Ad_LegacyAppInstallAd
	//	*Ad_ResponsiveDisplayAd
	//	*Ad_DisplayUploadAd
	//	*Ad_AppEngagementAd
	//	*Ad_ShoppingComparisonListingAd
	AdData               isAd_AdData `protobuf_oneof:"ad_data"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Ad) Reset()         { *m = Ad{} }
func (m *Ad) String() string { return proto.CompactTextString(m) }
func (*Ad) ProtoMessage()    {}
func (*Ad) Descriptor() ([]byte, []int) {
	return fileDescriptor_2cfecfd7772c305a, []int{0}
}

func (m *Ad) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ad.Unmarshal(m, b)
}
func (m *Ad) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ad.Marshal(b, m, deterministic)
}
func (m *Ad) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ad.Merge(m, src)
}
func (m *Ad) XXX_Size() int {
	return xxx_messageInfo_Ad.Size(m)
}
func (m *Ad) XXX_DiscardUnknown() {
	xxx_messageInfo_Ad.DiscardUnknown(m)
}

var xxx_messageInfo_Ad proto.InternalMessageInfo

func (m *Ad) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Ad) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *Ad) GetFinalAppUrls() []*common.FinalAppUrl {
	if m != nil {
		return m.FinalAppUrls
	}
	return nil
}

func (m *Ad) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *Ad) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *Ad) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *Ad) GetDisplayUrl() *wrappers.StringValue {
	if m != nil {
		return m.DisplayUrl
	}
	return nil
}

func (m *Ad) GetType() enums.AdTypeEnum_AdType {
	if m != nil {
		return m.Type
	}
	return enums.AdTypeEnum_UNSPECIFIED
}

func (m *Ad) GetAddedByGoogleAds() *wrappers.BoolValue {
	if m != nil {
		return m.AddedByGoogleAds
	}
	return nil
}

func (m *Ad) GetDevicePreference() enums.DeviceEnum_Device {
	if m != nil {
		return m.DevicePreference
	}
	return enums.DeviceEnum_UNSPECIFIED
}

func (m *Ad) GetUrlCollections() []*common.UrlCollection {
	if m != nil {
		return m.UrlCollections
	}
	return nil
}

func (m *Ad) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Ad) GetSystemManagedResourceSource() enums.SystemManagedResourceSourceEnum_SystemManagedResourceSource {
	if m != nil {
		return m.SystemManagedResourceSource
	}
	return enums.SystemManagedResourceSourceEnum_UNSPECIFIED
}

type isAd_AdData interface {
	isAd_AdData()
}

type Ad_TextAd struct {
	TextAd *common.TextAdInfo `protobuf:"bytes,6,opt,name=text_ad,json=textAd,proto3,oneof"`
}

type Ad_ExpandedTextAd struct {
	ExpandedTextAd *common.ExpandedTextAdInfo `protobuf:"bytes,7,opt,name=expanded_text_ad,json=expandedTextAd,proto3,oneof"`
}

type Ad_CallOnlyAd struct {
	CallOnlyAd *common.CallOnlyAdInfo `protobuf:"bytes,13,opt,name=call_only_ad,json=callOnlyAd,proto3,oneof"`
}

type Ad_ExpandedDynamicSearchAd struct {
	ExpandedDynamicSearchAd *common.ExpandedDynamicSearchAdInfo `protobuf:"bytes,14,opt,name=expanded_dynamic_search_ad,json=expandedDynamicSearchAd,proto3,oneof"`
}

type Ad_HotelAd struct {
	HotelAd *common.HotelAdInfo `protobuf:"bytes,15,opt,name=hotel_ad,json=hotelAd,proto3,oneof"`
}

type Ad_ShoppingSmartAd struct {
	ShoppingSmartAd *common.ShoppingSmartAdInfo `protobuf:"bytes,17,opt,name=shopping_smart_ad,json=shoppingSmartAd,proto3,oneof"`
}

type Ad_ShoppingProductAd struct {
	ShoppingProductAd *common.ShoppingProductAdInfo `protobuf:"bytes,18,opt,name=shopping_product_ad,json=shoppingProductAd,proto3,oneof"`
}

type Ad_GmailAd struct {
	GmailAd *common.GmailAdInfo `protobuf:"bytes,21,opt,name=gmail_ad,json=gmailAd,proto3,oneof"`
}

type Ad_ImageAd struct {
	ImageAd *common.ImageAdInfo `protobuf:"bytes,22,opt,name=image_ad,json=imageAd,proto3,oneof"`
}

type Ad_VideoAd struct {
	VideoAd *common.VideoAdInfo `protobuf:"bytes,24,opt,name=video_ad,json=videoAd,proto3,oneof"`
}

type Ad_ResponsiveSearchAd struct {
	ResponsiveSearchAd *common.ResponsiveSearchAdInfo `protobuf:"bytes,25,opt,name=responsive_search_ad,json=responsiveSearchAd,proto3,oneof"`
}

type Ad_LegacyResponsiveDisplayAd struct {
	LegacyResponsiveDisplayAd *common.LegacyResponsiveDisplayAdInfo `protobuf:"bytes,28,opt,name=legacy_responsive_display_ad,json=legacyResponsiveDisplayAd,proto3,oneof"`
}

type Ad_AppAd struct {
	AppAd *common.AppAdInfo `protobuf:"bytes,29,opt,name=app_ad,json=appAd,proto3,oneof"`
}

type Ad_LegacyAppInstallAd struct {
	LegacyAppInstallAd *common.LegacyAppInstallAdInfo `protobuf:"bytes,30,opt,name=legacy_app_install_ad,json=legacyAppInstallAd,proto3,oneof"`
}

type Ad_ResponsiveDisplayAd struct {
	ResponsiveDisplayAd *common.ResponsiveDisplayAdInfo `protobuf:"bytes,31,opt,name=responsive_display_ad,json=responsiveDisplayAd,proto3,oneof"`
}

type Ad_DisplayUploadAd struct {
	DisplayUploadAd *common.DisplayUploadAdInfo `protobuf:"bytes,33,opt,name=display_upload_ad,json=displayUploadAd,proto3,oneof"`
}

type Ad_AppEngagementAd struct {
	AppEngagementAd *common.AppEngagementAdInfo `protobuf:"bytes,34,opt,name=app_engagement_ad,json=appEngagementAd,proto3,oneof"`
}

type Ad_ShoppingComparisonListingAd struct {
	ShoppingComparisonListingAd *common.ShoppingComparisonListingAdInfo `protobuf:"bytes,36,opt,name=shopping_comparison_listing_ad,json=shoppingComparisonListingAd,proto3,oneof"`
}

func (*Ad_TextAd) isAd_AdData() {}

func (*Ad_ExpandedTextAd) isAd_AdData() {}

func (*Ad_CallOnlyAd) isAd_AdData() {}

func (*Ad_ExpandedDynamicSearchAd) isAd_AdData() {}

func (*Ad_HotelAd) isAd_AdData() {}

func (*Ad_ShoppingSmartAd) isAd_AdData() {}

func (*Ad_ShoppingProductAd) isAd_AdData() {}

func (*Ad_GmailAd) isAd_AdData() {}

func (*Ad_ImageAd) isAd_AdData() {}

func (*Ad_VideoAd) isAd_AdData() {}

func (*Ad_ResponsiveSearchAd) isAd_AdData() {}

func (*Ad_LegacyResponsiveDisplayAd) isAd_AdData() {}

func (*Ad_AppAd) isAd_AdData() {}

func (*Ad_LegacyAppInstallAd) isAd_AdData() {}

func (*Ad_ResponsiveDisplayAd) isAd_AdData() {}

func (*Ad_DisplayUploadAd) isAd_AdData() {}

func (*Ad_AppEngagementAd) isAd_AdData() {}

func (*Ad_ShoppingComparisonListingAd) isAd_AdData() {}

func (m *Ad) GetAdData() isAd_AdData {
	if m != nil {
		return m.AdData
	}
	return nil
}

func (m *Ad) GetTextAd() *common.TextAdInfo {
	if x, ok := m.GetAdData().(*Ad_TextAd); ok {
		return x.TextAd
	}
	return nil
}

func (m *Ad) GetExpandedTextAd() *common.ExpandedTextAdInfo {
	if x, ok := m.GetAdData().(*Ad_ExpandedTextAd); ok {
		return x.ExpandedTextAd
	}
	return nil
}

func (m *Ad) GetCallOnlyAd() *common.CallOnlyAdInfo {
	if x, ok := m.GetAdData().(*Ad_CallOnlyAd); ok {
		return x.CallOnlyAd
	}
	return nil
}

func (m *Ad) GetExpandedDynamicSearchAd() *common.ExpandedDynamicSearchAdInfo {
	if x, ok := m.GetAdData().(*Ad_ExpandedDynamicSearchAd); ok {
		return x.ExpandedDynamicSearchAd
	}
	return nil
}

func (m *Ad) GetHotelAd() *common.HotelAdInfo {
	if x, ok := m.GetAdData().(*Ad_HotelAd); ok {
		return x.HotelAd
	}
	return nil
}

func (m *Ad) GetShoppingSmartAd() *common.ShoppingSmartAdInfo {
	if x, ok := m.GetAdData().(*Ad_ShoppingSmartAd); ok {
		return x.ShoppingSmartAd
	}
	return nil
}

func (m *Ad) GetShoppingProductAd() *common.ShoppingProductAdInfo {
	if x, ok := m.GetAdData().(*Ad_ShoppingProductAd); ok {
		return x.ShoppingProductAd
	}
	return nil
}

func (m *Ad) GetGmailAd() *common.GmailAdInfo {
	if x, ok := m.GetAdData().(*Ad_GmailAd); ok {
		return x.GmailAd
	}
	return nil
}

func (m *Ad) GetImageAd() *common.ImageAdInfo {
	if x, ok := m.GetAdData().(*Ad_ImageAd); ok {
		return x.ImageAd
	}
	return nil
}

func (m *Ad) GetVideoAd() *common.VideoAdInfo {
	if x, ok := m.GetAdData().(*Ad_VideoAd); ok {
		return x.VideoAd
	}
	return nil
}

func (m *Ad) GetResponsiveSearchAd() *common.ResponsiveSearchAdInfo {
	if x, ok := m.GetAdData().(*Ad_ResponsiveSearchAd); ok {
		return x.ResponsiveSearchAd
	}
	return nil
}

func (m *Ad) GetLegacyResponsiveDisplayAd() *common.LegacyResponsiveDisplayAdInfo {
	if x, ok := m.GetAdData().(*Ad_LegacyResponsiveDisplayAd); ok {
		return x.LegacyResponsiveDisplayAd
	}
	return nil
}

func (m *Ad) GetAppAd() *common.AppAdInfo {
	if x, ok := m.GetAdData().(*Ad_AppAd); ok {
		return x.AppAd
	}
	return nil
}

func (m *Ad) GetLegacyAppInstallAd() *common.LegacyAppInstallAdInfo {
	if x, ok := m.GetAdData().(*Ad_LegacyAppInstallAd); ok {
		return x.LegacyAppInstallAd
	}
	return nil
}

func (m *Ad) GetResponsiveDisplayAd() *common.ResponsiveDisplayAdInfo {
	if x, ok := m.GetAdData().(*Ad_ResponsiveDisplayAd); ok {
		return x.ResponsiveDisplayAd
	}
	return nil
}

func (m *Ad) GetDisplayUploadAd() *common.DisplayUploadAdInfo {
	if x, ok := m.GetAdData().(*Ad_DisplayUploadAd); ok {
		return x.DisplayUploadAd
	}
	return nil
}

func (m *Ad) GetAppEngagementAd() *common.AppEngagementAdInfo {
	if x, ok := m.GetAdData().(*Ad_AppEngagementAd); ok {
		return x.AppEngagementAd
	}
	return nil
}

func (m *Ad) GetShoppingComparisonListingAd() *common.ShoppingComparisonListingAdInfo {
	if x, ok := m.GetAdData().(*Ad_ShoppingComparisonListingAd); ok {
		return x.ShoppingComparisonListingAd
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Ad) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Ad_TextAd)(nil),
		(*Ad_ExpandedTextAd)(nil),
		(*Ad_CallOnlyAd)(nil),
		(*Ad_ExpandedDynamicSearchAd)(nil),
		(*Ad_HotelAd)(nil),
		(*Ad_ShoppingSmartAd)(nil),
		(*Ad_ShoppingProductAd)(nil),
		(*Ad_GmailAd)(nil),
		(*Ad_ImageAd)(nil),
		(*Ad_VideoAd)(nil),
		(*Ad_ResponsiveSearchAd)(nil),
		(*Ad_LegacyResponsiveDisplayAd)(nil),
		(*Ad_AppAd)(nil),
		(*Ad_LegacyAppInstallAd)(nil),
		(*Ad_ResponsiveDisplayAd)(nil),
		(*Ad_DisplayUploadAd)(nil),
		(*Ad_AppEngagementAd)(nil),
		(*Ad_ShoppingComparisonListingAd)(nil),
	}
}

func init() {
	proto.RegisterType((*Ad)(nil), "google.ads.googleads.v1.resources.Ad")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/ad.proto", fileDescriptor_2cfecfd7772c305a)
}

var fileDescriptor_2cfecfd7772c305a = []byte{
	// 1248 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x97, 0x4d, 0x73, 0x1b, 0x35,
	0x18, 0xc7, 0xb1, 0xd3, 0x26, 0x54, 0x2d, 0x79, 0x51, 0x9a, 0x76, 0x9b, 0x84, 0xbe, 0x41, 0x67,
	0x4a, 0x3b, 0xac, 0x9b, 0x94, 0x96, 0x19, 0x77, 0x3a, 0xb0, 0x6e, 0x43, 0x13, 0xa6, 0x85, 0xe0,
	0x34, 0x3e, 0x74, 0x02, 0x3b, 0xca, 0x4a, 0xde, 0x08, 0xb4, 0x92, 0x46, 0x5a, 0x9b, 0x9a, 0x13,
	0x27, 0xae, 0x7c, 0x07, 0x86, 0x13, 0x1f, 0x85, 0x4f, 0xc1, 0x99, 0x33, 0x1f, 0x80, 0x91, 0xb4,
	0x2b, 0xc7, 0x49, 0x9d, 0xdd, 0x8b, 0x67, 0x25, 0x3d, 0xff, 0xdf, 0xff, 0xd1, 0x23, 0xad, 0xb4,
	0x06, 0xf7, 0x52, 0x21, 0x52, 0x46, 0x5a, 0x08, 0xeb, 0x96, 0x7b, 0x34, 0x4f, 0xc3, 0x8d, 0x96,
	0x22, 0x5a, 0x0c, 0x54, 0x42, 0x74, 0x0b, 0xe1, 0x50, 0x2a, 0x91, 0x0b, 0x78, 0xcb, 0x05, 0x84,
	0x08, 0xeb, 0xd0, 0xc7, 0x86, 0xc3, 0x8d, 0xd0, 0xc7, 0xae, 0x6e, 0x4e, 0xc3, 0x25, 0x22, 0xcb,
	0x04, 0x6f, 0x21, 0x1c, 0xe7, 0x23, 0x49, 0x62, 0xca, 0xfb, 0x42, 0x3b, 0xec, 0xea, 0xa3, 0x0a,
	0x4d, 0x32, 0xd0, 0xb9, 0xc8, 0x62, 0x89, 0x14, 0xca, 0x48, 0x4e, 0x54, 0x21, 0xab, 0xb2, 0xea,
	0x53, 0x8e, 0x58, 0x8c, 0xa4, 0x8c, 0x07, 0x8a, 0x15, 0x9a, 0x87, 0x15, 0x9a, 0x81, 0x62, 0x71,
	0x22, 0x18, 0x23, 0x49, 0x4e, 0x05, 0x2f, 0x44, 0xf7, 0xa7, 0x89, 0x08, 0x1f, 0x64, 0xba, 0x9c,
	0x52, 0x11, 0x7c, 0xef, 0xec, 0x60, 0x4c, 0x86, 0x34, 0x29, 0x63, 0xbf, 0x3c, 0x3b, 0x56, 0x8f,
	0x74, 0x4e, 0xb2, 0x38, 0x43, 0x1c, 0xa5, 0x04, 0xc7, 0x84, 0xe7, 0x34, 0x1f, 0xc5, 0xae, 0xd2,
	0x05, 0xe1, 0x46, 0x49, 0x90, 0xb4, 0xd5, 0xa7, 0x84, 0xe1, 0xf8, 0x90, 0x1c, 0xa1, 0x21, 0x15,
	0x65, 0x91, 0xae, 0x17, 0x01, 0xb6, 0x75, 0x38, 0xe8, 0xb7, 0x7e, 0x56, 0x48, 0x4a, 0xa2, 0xca,
	0xda, 0xaf, 0x1f, 0x03, 0x20, 0xce, 0x45, 0x8e, 0xcc, 0xc4, 0x8b, 0xd1, 0xdb, 0xbf, 0x5f, 0x01,
	0xcd, 0x08, 0xc3, 0x07, 0xa0, 0x49, 0x71, 0xd0, 0xb8, 0xd9, 0xb8, 0x7b, 0x71, 0x73, 0xad, 0x58,
	0xf9, 0xb0, 0x24, 0x86, 0x3b, 0x3c, 0x7f, 0xfc, 0x59, 0x0f, 0xb1, 0x01, 0xe9, 0xcc, 0xfc, 0x13,
	0xcd, 0x74, 0x9b, 0x14, 0xc3, 0x27, 0x00, 0xb8, 0xf2, 0x0f, 0x14, 0xd3, 0x41, 0xf3, 0xe6, 0xcc,
	0xdd, 0x8b, 0x9b, 0xeb, 0xa7, 0x94, 0x7b, 0xb9, 0xa2, 0x3c, 0xb5, 0xd2, 0xee, 0x05, 0x1b, 0xbf,
	0xaf, 0x98, 0x86, 0xdf, 0x81, 0xf9, 0x89, 0xb5, 0xd3, 0xc1, 0x47, 0x16, 0x70, 0x3f, 0x9c, 0xb6,
	0xff, 0xdc, 0xea, 0x85, 0x5f, 0x19, 0x55, 0x24, 0xe5, 0xbe, 0x62, 0xdd, 0x4b, 0xfd, 0x71, 0x43,
	0xc3, 0x6d, 0xb0, 0xe4, 0x90, 0x99, 0x38, 0xa4, 0x8c, 0x38, 0xea, 0x62, 0x8d, 0xb4, 0x16, 0xac,
	0xec, 0x95, 0x55, 0x59, 0xd2, 0x2e, 0x58, 0xc9, 0x15, 0x4a, 0x7e, 0xa2, 0x3c, 0x35, 0x94, 0x38,
	0x27, 0x99, 0x64, 0x28, 0x27, 0xc1, 0x25, 0x5b, 0x9e, 0xb3, 0x69, 0xcb, 0xa5, 0x74, 0x5f, 0xb1,
	0xd7, 0x85, 0x10, 0x26, 0x60, 0xc5, 0x6e, 0xbb, 0x13, 0xbb, 0x5c, 0x07, 0xc0, 0xe6, 0xd7, 0xaa,
	0x9a, 0xf5, 0x33, 0x2b, 0xdc, 0x2d, 0x75, 0xdd, 0xe5, 0x81, 0x62, 0x27, 0xfa, 0x34, 0x7c, 0x0a,
	0x2e, 0x62, 0xaa, 0x25, 0x43, 0x23, 0x93, 0x75, 0x70, 0xae, 0x46, 0xb2, 0xa0, 0x10, 0xec, 0x2b,
	0x06, 0x77, 0xc0, 0x39, 0xb3, 0xc7, 0x83, 0xf3, 0x37, 0x1b, 0x77, 0xe7, 0x37, 0x1f, 0x4c, 0x4d,
	0xc9, 0x6e, 0xdc, 0x30, 0xc2, 0xaf, 0x47, 0x92, 0x6c, 0xf1, 0x41, 0x56, 0x3c, 0xba, 0x8d, 0x61,
	0x11, 0xf0, 0x1b, 0xb0, 0x8c, 0x30, 0x26, 0x38, 0x3e, 0x1c, 0xc5, 0x4e, 0x1b, 0x23, 0xac, 0x83,
	0x65, 0x9b, 0xd1, 0xea, 0xa9, 0x8c, 0x3a, 0x42, 0xb0, 0x63, 0x9b, 0x6b, 0xd1, 0x6a, 0x3b, 0xa3,
	0x17, 0x36, 0x2c, 0xc2, 0x1a, 0x7e, 0x0f, 0x96, 0xdc, 0x4b, 0x15, 0x4b, 0x45, 0xfa, 0x44, 0x11,
	0x9e, 0x90, 0xe0, 0x72, 0xad, 0x3c, 0x9f, 0x5b, 0x9d, 0xcd, 0xd3, 0x3d, 0x76, 0x17, 0x1d, 0x6a,
	0xd7, 0x93, 0x60, 0x0f, 0x2c, 0x4c, 0x1e, 0x0a, 0x3a, 0x58, 0xb5, 0xeb, 0xf2, 0x69, 0xd5, 0xba,
	0xec, 0x2b, 0xf6, 0xcc, 0xab, 0xba, 0xf3, 0x83, 0xe3, 0x4d, 0x0d, 0x1f, 0x81, 0x73, 0x1c, 0x65,
	0x24, 0xb8, 0x5a, 0xbd, 0x12, 0x66, 0xe6, 0xe7, 0xbb, 0x36, 0x1c, 0xfe, 0xd9, 0x00, 0xd7, 0x4f,
	0x9c, 0x0b, 0xe5, 0xe1, 0x5b, 0x9c, 0x0c, 0xc1, 0x9a, 0x9d, 0xfb, 0x9b, 0x8a, 0xb9, 0xef, 0x59,
	0xc8, 0x2b, 0xc7, 0xe8, 0x16, 0x88, 0x3d, 0xfb, 0x6b, 0x0b, 0x72, 0xc6, 0xb8, 0x5b, 0x89, 0x35,
	0x3d, 0x3d, 0x02, 0x6e, 0x81, 0xb9, 0x9c, 0xbc, 0xcd, 0x63, 0x84, 0x83, 0x59, 0x3b, 0xc1, 0x7b,
	0x55, 0xd5, 0x7a, 0x4d, 0xde, 0xe6, 0x11, 0xde, 0xe1, 0x7d, 0xb1, 0xfd, 0x5e, 0x77, 0x36, 0xb7,
	0x2d, 0xf8, 0x03, 0x58, 0x24, 0x6f, 0x25, 0xe2, 0x66, 0xbb, 0x94, 0xbc, 0x39, 0xcb, 0xdb, 0xac,
	0xe2, 0x6d, 0x15, 0xba, 0x09, 0xee, 0x3c, 0x99, 0xe8, 0x85, 0x5d, 0x70, 0x29, 0x41, 0x8c, 0xc5,
	0x82, 0xb3, 0x91, 0x61, 0x7f, 0x60, 0xd9, 0x61, 0xe5, 0x1b, 0x87, 0x18, 0xfb, 0x96, 0xb3, 0x91,
	0xe7, 0x82, 0xc4, 0xf7, 0xc0, 0x5f, 0xc0, 0xaa, 0xcf, 0x19, 0x8f, 0x38, 0xca, 0x68, 0x12, 0x6b,
	0x82, 0x54, 0x72, 0x64, 0x1c, 0xe6, 0xad, 0xc3, 0x93, 0xba, 0xd9, 0x3f, 0x77, 0x80, 0x3d, 0xab,
	0xf7, 0x76, 0x57, 0xc9, 0xbb, 0x87, 0xe1, 0x36, 0x78, 0xff, 0x48, 0xe4, 0x84, 0x19, 0xa7, 0x05,
	0xeb, 0x54, 0x79, 0x66, 0x6e, 0x9b, 0x78, 0x4f, 0x9e, 0x3b, 0x72, 0x4d, 0x88, 0xc0, 0x92, 0x3e,
	0x12, 0x52, 0x9a, 0x63, 0x4e, 0x67, 0x48, 0xd9, 0xd2, 0x2f, 0x59, 0xe4, 0xc3, 0x2a, 0xe4, 0x5e,
	0x21, 0xdc, 0x33, 0x3a, 0x8f, 0x5e, 0xd0, 0x93, 0xdd, 0x30, 0x05, 0xcb, 0xde, 0x42, 0x2a, 0x81,
	0x07, 0x89, 0x35, 0x81, 0xd6, 0xe4, 0x51, 0x5d, 0x93, 0x5d, 0xa7, 0xf4, 0x36, 0x3e, 0x6d, 0x3f,
	0x60, 0xaa, 0x92, 0x66, 0x88, 0xda, 0xaa, 0xac, 0xd4, 0xab, 0xca, 0x0b, 0x13, 0x3f, 0xae, 0x4a,
	0xea, 0x9a, 0x86, 0x44, 0x33, 0x94, 0x9a, 0x13, 0x2b, 0xb8, 0x52, 0x8f, 0xb4, 0x63, 0xe2, 0xc7,
	0x24, 0xea, 0x9a, 0x86, 0x34, 0xa4, 0x98, 0x08, 0x43, 0x0a, 0xea, 0x91, 0x7a, 0x26, 0x7e, 0x4c,
	0x1a, 0xba, 0x26, 0xfc, 0x11, 0x5c, 0x56, 0x44, 0x4b, 0xc1, 0x35, 0x1d, 0x92, 0x63, 0x3b, 0xed,
	0x9a, 0xa5, 0x3e, 0xae, 0xa2, 0x76, 0xbd, 0xf6, 0xc4, 0x26, 0x83, 0xea, 0xd4, 0x08, 0xfc, 0xb5,
	0x01, 0xd6, 0x19, 0x49, 0x51, 0x32, 0x8a, 0x8f, 0x79, 0x96, 0x17, 0x0b, 0xc2, 0xc1, 0xba, 0x35,
	0x7d, 0x5a, 0x65, 0xfa, 0xd2, 0x32, 0xc6, 0xd6, 0xcf, 0x1d, 0xc1, 0x7b, 0x5f, 0x63, 0xd3, 0x02,
	0x60, 0x07, 0xcc, 0x9a, 0xcf, 0x02, 0x84, 0x83, 0x0f, 0xad, 0xd7, 0x27, 0x55, 0x5e, 0x91, 0x94,
	0x9e, 0x7b, 0x1e, 0x99, 0x06, 0x94, 0x60, 0xa5, 0x98, 0x85, 0x41, 0x51, 0xae, 0x73, 0x73, 0x08,
	0x20, 0x1c, 0x5c, 0xaf, 0x57, 0x33, 0x97, 0x7e, 0x24, 0xe5, 0x8e, 0x93, 0x3a, 0xbe, 0x3d, 0xa6,
	0x4d, 0xe1, 0xd8, 0xa9, 0x61, 0x98, 0x81, 0x95, 0x77, 0x17, 0xec, 0x86, 0x75, 0xfc, 0xbc, 0xfe,
	0x2a, 0x9d, 0x2c, 0xd5, 0xb2, 0x7a, 0x47, 0x91, 0x10, 0x58, 0xf2, 0xb7, 0xbd, 0x64, 0x02, 0x61,
	0x63, 0x75, 0xab, 0xde, 0xdb, 0x5b, 0x50, 0xf6, 0xad, 0x6e, 0xfc, 0xf6, 0xe2, 0xc9, 0x6e, 0x63,
	0x61, 0x8a, 0x47, 0x78, 0x8a, 0x52, 0x92, 0x11, 0x6e, 0xdf, 0xdd, 0xdb, 0xf5, 0x2c, 0x22, 0x29,
	0xb7, 0xbc, 0x6e, 0x6c, 0x81, 0x26, 0xbb, 0xe1, 0x6f, 0xe6, 0xae, 0x2b, 0x4f, 0x88, 0x44, 0x64,
	0x12, 0x29, 0xaa, 0x05, 0x8f, 0x19, 0xd5, 0xb9, 0xe9, 0x42, 0x38, 0xf8, 0xd8, 0x1a, 0x7e, 0x51,
	0xf7, 0xb0, 0x78, 0xe6, 0x21, 0x2f, 0x1d, 0xc3, 0x9b, 0xaf, 0xe9, 0xe9, 0x21, 0x9d, 0x0b, 0x60,
	0x0e, 0xe1, 0x18, 0xa3, 0x1c, 0x75, 0xfe, 0x6b, 0x80, 0x3b, 0x89, 0xc8, 0xc2, 0xca, 0x7f, 0x42,
	0x9d, 0xb9, 0x08, 0xef, 0x9a, 0xcb, 0x7c, 0xb7, 0xf1, 0xe6, 0xeb, 0x22, 0x3a, 0x15, 0x0c, 0xf1,
	0x34, 0x14, 0x2a, 0x6d, 0xa5, 0x84, 0xdb, 0xab, 0xbe, 0xfc, 0xee, 0x97, 0x54, 0x9f, 0xf1, 0x17,
	0xec, 0x89, 0x7f, 0xfa, 0xa3, 0x39, 0xf3, 0x22, 0x8a, 0xfe, 0x6a, 0xde, 0x72, 0x1f, 0x40, 0x61,
	0x84, 0x75, 0xe8, 0xbf, 0x85, 0xc2, 0xde, 0x46, 0x58, 0x5e, 0xc4, 0xfa, 0xef, 0x32, 0xe6, 0x20,
	0xc2, 0xfa, 0xc0, 0xc7, 0x1c, 0xf4, 0x36, 0x0e, 0x7c, 0xcc, 0xbf, 0xcd, 0x3b, 0x6e, 0xa0, 0xdd,
	0x8e, 0xb0, 0x6e, 0xb7, 0x7d, 0x54, 0xbb, 0xdd, 0xdb, 0x68, 0xb7, 0x7d, 0xdc, 0xe1, 0xac, 0x4d,
	0xf6, 0xe1, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0x53, 0xf3, 0x7b, 0x7b, 0x2e, 0x0e, 0x00, 0x00,
}
