// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/table.proto

package admin

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates the type of the restore source.
type RestoreSourceType int32

const (
	// No restore associated.
	RestoreSourceType_RESTORE_SOURCE_TYPE_UNSPECIFIED RestoreSourceType = 0
	// A backup was used as the source of the restore.
	RestoreSourceType_BACKUP RestoreSourceType = 1
)

var RestoreSourceType_name = map[int32]string{
	0: "RESTORE_SOURCE_TYPE_UNSPECIFIED",
	1: "BACKUP",
}

var RestoreSourceType_value = map[string]int32{
	"RESTORE_SOURCE_TYPE_UNSPECIFIED": 0,
	"BACKUP":                          1,
}

func (x RestoreSourceType) String() string {
	return proto.EnumName(RestoreSourceType_name, int32(x))
}

func (RestoreSourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{0}
}

// Possible timestamp granularities to use when keeping multiple versions
// of data in a table.
type Table_TimestampGranularity int32

const (
	// The user did not specify a granularity. Should not be returned.
	// When specified during table creation, MILLIS will be used.
	Table_TIMESTAMP_GRANULARITY_UNSPECIFIED Table_TimestampGranularity = 0
	// The table keeps data versioned at a granularity of 1ms.
	Table_MILLIS Table_TimestampGranularity = 1
)

var Table_TimestampGranularity_name = map[int32]string{
	0: "TIMESTAMP_GRANULARITY_UNSPECIFIED",
	1: "MILLIS",
}

var Table_TimestampGranularity_value = map[string]int32{
	"TIMESTAMP_GRANULARITY_UNSPECIFIED": 0,
	"MILLIS":                            1,
}

func (x Table_TimestampGranularity) String() string {
	return proto.EnumName(Table_TimestampGranularity_name, int32(x))
}

func (Table_TimestampGranularity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{1, 0}
}

// Defines a view over a table's fields.
type Table_View int32

const (
	// Uses the default view for each method as documented in its request.
	Table_VIEW_UNSPECIFIED Table_View = 0
	// Only populates `name`.
	Table_NAME_ONLY Table_View = 1
	// Only populates `name` and fields related to the table's schema.
	Table_SCHEMA_VIEW Table_View = 2
	// Only populates `name` and fields related to the table's replication
	// state.
	Table_REPLICATION_VIEW Table_View = 3
	// Populates all fields.
	Table_FULL Table_View = 4
)

var Table_View_name = map[int32]string{
	0: "VIEW_UNSPECIFIED",
	1: "NAME_ONLY",
	2: "SCHEMA_VIEW",
	3: "REPLICATION_VIEW",
	4: "FULL",
}

var Table_View_value = map[string]int32{
	"VIEW_UNSPECIFIED": 0,
	"NAME_ONLY":        1,
	"SCHEMA_VIEW":      2,
	"REPLICATION_VIEW": 3,
	"FULL":             4,
}

func (x Table_View) String() string {
	return proto.EnumName(Table_View_name, int32(x))
}

func (Table_View) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{1, 1}
}

// Table replication states.
type Table_ClusterState_ReplicationState int32

const (
	// The replication state of the table is unknown in this cluster.
	Table_ClusterState_STATE_NOT_KNOWN Table_ClusterState_ReplicationState = 0
	// The cluster was recently created, and the table must finish copying
	// over pre-existing data from other clusters before it can begin
	// receiving live replication updates and serving Data API requests.
	Table_ClusterState_INITIALIZING Table_ClusterState_ReplicationState = 1
	// The table is temporarily unable to serve Data API requests from this
	// cluster due to planned internal maintenance.
	Table_ClusterState_PLANNED_MAINTENANCE Table_ClusterState_ReplicationState = 2
	// The table is temporarily unable to serve Data API requests from this
	// cluster due to unplanned or emergency maintenance.
	Table_ClusterState_UNPLANNED_MAINTENANCE Table_ClusterState_ReplicationState = 3
	// The table can serve Data API requests from this cluster. Depending on
	// replication delay, reads may not immediately reflect the state of the
	// table in other clusters.
	Table_ClusterState_READY Table_ClusterState_ReplicationState = 4
	// The table is fully created and ready for use after a restore, and is
	// being optimized for performance. When optimizations are complete, the
	// table will transition to `READY` state.
	Table_ClusterState_READY_OPTIMIZING Table_ClusterState_ReplicationState = 5
)

var Table_ClusterState_ReplicationState_name = map[int32]string{
	0: "STATE_NOT_KNOWN",
	1: "INITIALIZING",
	2: "PLANNED_MAINTENANCE",
	3: "UNPLANNED_MAINTENANCE",
	4: "READY",
	5: "READY_OPTIMIZING",
}

var Table_ClusterState_ReplicationState_value = map[string]int32{
	"STATE_NOT_KNOWN":       0,
	"INITIALIZING":          1,
	"PLANNED_MAINTENANCE":   2,
	"UNPLANNED_MAINTENANCE": 3,
	"READY":                 4,
	"READY_OPTIMIZING":      5,
}

func (x Table_ClusterState_ReplicationState) String() string {
	return proto.EnumName(Table_ClusterState_ReplicationState_name, int32(x))
}

func (Table_ClusterState_ReplicationState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{1, 0, 0}
}

// Possible states of a snapshot.
type Snapshot_State int32

const (
	// The state of the snapshot could not be determined.
	Snapshot_STATE_NOT_KNOWN Snapshot_State = 0
	// The snapshot has been successfully created and can serve all requests.
	Snapshot_READY Snapshot_State = 1
	// The snapshot is currently being created, and may be destroyed if the
	// creation process encounters an error. A snapshot may not be restored to a
	// table while it is being created.
	Snapshot_CREATING Snapshot_State = 2
)

var Snapshot_State_name = map[int32]string{
	0: "STATE_NOT_KNOWN",
	1: "READY",
	2: "CREATING",
}

var Snapshot_State_value = map[string]int32{
	"STATE_NOT_KNOWN": 0,
	"READY":           1,
	"CREATING":        2,
}

func (x Snapshot_State) String() string {
	return proto.EnumName(Snapshot_State_name, int32(x))
}

func (Snapshot_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{4, 0}
}

// Indicates the current state of the backup.
type Backup_State int32

const (
	// Not specified.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The pending backup is still being created. Operations on the
	// backup may fail with `FAILED_PRECONDITION` in this state.
	Backup_CREATING Backup_State = 1
	// The backup is complete and ready for use.
	Backup_READY Backup_State = 2
)

var Backup_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
}

var Backup_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
}

func (x Backup_State) String() string {
	return proto.EnumName(Backup_State_name, int32(x))
}

func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{5, 0}
}

// Information about a table restore.
type RestoreInfo struct {
	// The type of the restore source.
	SourceType RestoreSourceType `protobuf:"varint,1,opt,name=source_type,json=sourceType,proto3,enum=google.bigtable.admin.v2.RestoreSourceType" json:"source_type,omitempty"`
	// Information about the source used to restore the table.
	//
	// Types that are valid to be assigned to SourceInfo:
	//	*RestoreInfo_BackupInfo
	SourceInfo           isRestoreInfo_SourceInfo `protobuf_oneof:"source_info"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *RestoreInfo) Reset()         { *m = RestoreInfo{} }
func (m *RestoreInfo) String() string { return proto.CompactTextString(m) }
func (*RestoreInfo) ProtoMessage()    {}
func (*RestoreInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{0}
}

func (m *RestoreInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreInfo.Unmarshal(m, b)
}
func (m *RestoreInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreInfo.Marshal(b, m, deterministic)
}
func (m *RestoreInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreInfo.Merge(m, src)
}
func (m *RestoreInfo) XXX_Size() int {
	return xxx_messageInfo_RestoreInfo.Size(m)
}
func (m *RestoreInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreInfo proto.InternalMessageInfo

func (m *RestoreInfo) GetSourceType() RestoreSourceType {
	if m != nil {
		return m.SourceType
	}
	return RestoreSourceType_RESTORE_SOURCE_TYPE_UNSPECIFIED
}

type isRestoreInfo_SourceInfo interface {
	isRestoreInfo_SourceInfo()
}

type RestoreInfo_BackupInfo struct {
	BackupInfo *BackupInfo `protobuf:"bytes,2,opt,name=backup_info,json=backupInfo,proto3,oneof"`
}

func (*RestoreInfo_BackupInfo) isRestoreInfo_SourceInfo() {}

func (m *RestoreInfo) GetSourceInfo() isRestoreInfo_SourceInfo {
	if m != nil {
		return m.SourceInfo
	}
	return nil
}

func (m *RestoreInfo) GetBackupInfo() *BackupInfo {
	if x, ok := m.GetSourceInfo().(*RestoreInfo_BackupInfo); ok {
		return x.BackupInfo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RestoreInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RestoreInfo_BackupInfo)(nil),
	}
}

// A collection of user data indexed by row, column, and timestamp.
// Each table is served using the resources of its parent cluster.
type Table struct {
	// Output only. The unique name of the table. Values are of the form
	// `projects/<project>/instances/<instance>/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
	// Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Map from cluster ID to per-cluster table state.
	// If it could not be determined whether or not the table has data in a
	// particular cluster (for example, if its zone is unavailable), then
	// there will be an entry for the cluster with UNKNOWN `replication_status`.
	// Views: `REPLICATION_VIEW`, `FULL`
	ClusterStates map[string]*Table_ClusterState `protobuf:"bytes,2,rep,name=cluster_states,json=clusterStates,proto3" json:"cluster_states,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (`CreationOnly`)
	// The column families configured for this table, mapped by column family ID.
	// Views: `SCHEMA_VIEW`, `FULL`
	ColumnFamilies map[string]*ColumnFamily `protobuf:"bytes,3,rep,name=column_families,json=columnFamilies,proto3" json:"column_families,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (`CreationOnly`)
	// The granularity (i.e. `MILLIS`) at which timestamps are stored in
	// this table. Timestamps not matching the granularity will be rejected.
	// If unspecified at creation time, the value will be set to `MILLIS`.
	// Views: `SCHEMA_VIEW`, `FULL`.
	Granularity Table_TimestampGranularity `protobuf:"varint,4,opt,name=granularity,proto3,enum=google.bigtable.admin.v2.Table_TimestampGranularity" json:"granularity,omitempty"`
	// Output only. If this table was restored from another data source (e.g. a
	// backup), this field will be populated with information about the restore.
	RestoreInfo          *RestoreInfo `protobuf:"bytes,6,opt,name=restore_info,json=restoreInfo,proto3" json:"restore_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Table) Reset()         { *m = Table{} }
func (m *Table) String() string { return proto.CompactTextString(m) }
func (*Table) ProtoMessage()    {}
func (*Table) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{1}
}

func (m *Table) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Table.Unmarshal(m, b)
}
func (m *Table) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Table.Marshal(b, m, deterministic)
}
func (m *Table) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Table.Merge(m, src)
}
func (m *Table) XXX_Size() int {
	return xxx_messageInfo_Table.Size(m)
}
func (m *Table) XXX_DiscardUnknown() {
	xxx_messageInfo_Table.DiscardUnknown(m)
}

var xxx_messageInfo_Table proto.InternalMessageInfo

func (m *Table) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Table) GetClusterStates() map[string]*Table_ClusterState {
	if m != nil {
		return m.ClusterStates
	}
	return nil
}

func (m *Table) GetColumnFamilies() map[string]*ColumnFamily {
	if m != nil {
		return m.ColumnFamilies
	}
	return nil
}

func (m *Table) GetGranularity() Table_TimestampGranularity {
	if m != nil {
		return m.Granularity
	}
	return Table_TIMESTAMP_GRANULARITY_UNSPECIFIED
}

func (m *Table) GetRestoreInfo() *RestoreInfo {
	if m != nil {
		return m.RestoreInfo
	}
	return nil
}

// The state of a table's data in a particular cluster.
type Table_ClusterState struct {
	// Output only. The state of replication for the table in this cluster.
	ReplicationState     Table_ClusterState_ReplicationState `protobuf:"varint,1,opt,name=replication_state,json=replicationState,proto3,enum=google.bigtable.admin.v2.Table_ClusterState_ReplicationState" json:"replication_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *Table_ClusterState) Reset()         { *m = Table_ClusterState{} }
func (m *Table_ClusterState) String() string { return proto.CompactTextString(m) }
func (*Table_ClusterState) ProtoMessage()    {}
func (*Table_ClusterState) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{1, 0}
}

func (m *Table_ClusterState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Table_ClusterState.Unmarshal(m, b)
}
func (m *Table_ClusterState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Table_ClusterState.Marshal(b, m, deterministic)
}
func (m *Table_ClusterState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Table_ClusterState.Merge(m, src)
}
func (m *Table_ClusterState) XXX_Size() int {
	return xxx_messageInfo_Table_ClusterState.Size(m)
}
func (m *Table_ClusterState) XXX_DiscardUnknown() {
	xxx_messageInfo_Table_ClusterState.DiscardUnknown(m)
}

var xxx_messageInfo_Table_ClusterState proto.InternalMessageInfo

func (m *Table_ClusterState) GetReplicationState() Table_ClusterState_ReplicationState {
	if m != nil {
		return m.ReplicationState
	}
	return Table_ClusterState_STATE_NOT_KNOWN
}

// A set of columns within a table which share a common configuration.
type ColumnFamily struct {
	// Garbage collection rule specified as a protobuf.
	// Must serialize to at most 500 bytes.
	//
	// NOTE: Garbage collection executes opportunistically in the background, and
	// so it's possible for reads to return a cell even if it matches the active
	// GC expression for its family.
	GcRule               *GcRule  `protobuf:"bytes,1,opt,name=gc_rule,json=gcRule,proto3" json:"gc_rule,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ColumnFamily) Reset()         { *m = ColumnFamily{} }
func (m *ColumnFamily) String() string { return proto.CompactTextString(m) }
func (*ColumnFamily) ProtoMessage()    {}
func (*ColumnFamily) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{2}
}

func (m *ColumnFamily) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ColumnFamily.Unmarshal(m, b)
}
func (m *ColumnFamily) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ColumnFamily.Marshal(b, m, deterministic)
}
func (m *ColumnFamily) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ColumnFamily.Merge(m, src)
}
func (m *ColumnFamily) XXX_Size() int {
	return xxx_messageInfo_ColumnFamily.Size(m)
}
func (m *ColumnFamily) XXX_DiscardUnknown() {
	xxx_messageInfo_ColumnFamily.DiscardUnknown(m)
}

var xxx_messageInfo_ColumnFamily proto.InternalMessageInfo

func (m *ColumnFamily) GetGcRule() *GcRule {
	if m != nil {
		return m.GcRule
	}
	return nil
}

// Rule for determining which cells to delete during garbage collection.
type GcRule struct {
	// Garbage collection rules.
	//
	// Types that are valid to be assigned to Rule:
	//	*GcRule_MaxNumVersions
	//	*GcRule_MaxAge
	//	*GcRule_Intersection_
	//	*GcRule_Union_
	Rule                 isGcRule_Rule `protobuf_oneof:"rule"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GcRule) Reset()         { *m = GcRule{} }
func (m *GcRule) String() string { return proto.CompactTextString(m) }
func (*GcRule) ProtoMessage()    {}
func (*GcRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{3}
}

func (m *GcRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcRule.Unmarshal(m, b)
}
func (m *GcRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcRule.Marshal(b, m, deterministic)
}
func (m *GcRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcRule.Merge(m, src)
}
func (m *GcRule) XXX_Size() int {
	return xxx_messageInfo_GcRule.Size(m)
}
func (m *GcRule) XXX_DiscardUnknown() {
	xxx_messageInfo_GcRule.DiscardUnknown(m)
}

var xxx_messageInfo_GcRule proto.InternalMessageInfo

type isGcRule_Rule interface {
	isGcRule_Rule()
}

type GcRule_MaxNumVersions struct {
	MaxNumVersions int32 `protobuf:"varint,1,opt,name=max_num_versions,json=maxNumVersions,proto3,oneof"`
}

type GcRule_MaxAge struct {
	MaxAge *duration.Duration `protobuf:"bytes,2,opt,name=max_age,json=maxAge,proto3,oneof"`
}

type GcRule_Intersection_ struct {
	Intersection *GcRule_Intersection `protobuf:"bytes,3,opt,name=intersection,proto3,oneof"`
}

type GcRule_Union_ struct {
	Union *GcRule_Union `protobuf:"bytes,4,opt,name=union,proto3,oneof"`
}

func (*GcRule_MaxNumVersions) isGcRule_Rule() {}

func (*GcRule_MaxAge) isGcRule_Rule() {}

func (*GcRule_Intersection_) isGcRule_Rule() {}

func (*GcRule_Union_) isGcRule_Rule() {}

func (m *GcRule) GetRule() isGcRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *GcRule) GetMaxNumVersions() int32 {
	if x, ok := m.GetRule().(*GcRule_MaxNumVersions); ok {
		return x.MaxNumVersions
	}
	return 0
}

func (m *GcRule) GetMaxAge() *duration.Duration {
	if x, ok := m.GetRule().(*GcRule_MaxAge); ok {
		return x.MaxAge
	}
	return nil
}

func (m *GcRule) GetIntersection() *GcRule_Intersection {
	if x, ok := m.GetRule().(*GcRule_Intersection_); ok {
		return x.Intersection
	}
	return nil
}

func (m *GcRule) GetUnion() *GcRule_Union {
	if x, ok := m.GetRule().(*GcRule_Union_); ok {
		return x.Union
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GcRule) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GcRule_MaxNumVersions)(nil),
		(*GcRule_MaxAge)(nil),
		(*GcRule_Intersection_)(nil),
		(*GcRule_Union_)(nil),
	}
}

// A GcRule which deletes cells matching all of the given rules.
type GcRule_Intersection struct {
	// Only delete cells which would be deleted by every element of `rules`.
	Rules                []*GcRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GcRule_Intersection) Reset()         { *m = GcRule_Intersection{} }
func (m *GcRule_Intersection) String() string { return proto.CompactTextString(m) }
func (*GcRule_Intersection) ProtoMessage()    {}
func (*GcRule_Intersection) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{3, 0}
}

func (m *GcRule_Intersection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcRule_Intersection.Unmarshal(m, b)
}
func (m *GcRule_Intersection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcRule_Intersection.Marshal(b, m, deterministic)
}
func (m *GcRule_Intersection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcRule_Intersection.Merge(m, src)
}
func (m *GcRule_Intersection) XXX_Size() int {
	return xxx_messageInfo_GcRule_Intersection.Size(m)
}
func (m *GcRule_Intersection) XXX_DiscardUnknown() {
	xxx_messageInfo_GcRule_Intersection.DiscardUnknown(m)
}

var xxx_messageInfo_GcRule_Intersection proto.InternalMessageInfo

func (m *GcRule_Intersection) GetRules() []*GcRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// A GcRule which deletes cells matching any of the given rules.
type GcRule_Union struct {
	// Delete cells which would be deleted by any element of `rules`.
	Rules                []*GcRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GcRule_Union) Reset()         { *m = GcRule_Union{} }
func (m *GcRule_Union) String() string { return proto.CompactTextString(m) }
func (*GcRule_Union) ProtoMessage()    {}
func (*GcRule_Union) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{3, 1}
}

func (m *GcRule_Union) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcRule_Union.Unmarshal(m, b)
}
func (m *GcRule_Union) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcRule_Union.Marshal(b, m, deterministic)
}
func (m *GcRule_Union) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcRule_Union.Merge(m, src)
}
func (m *GcRule_Union) XXX_Size() int {
	return xxx_messageInfo_GcRule_Union.Size(m)
}
func (m *GcRule_Union) XXX_DiscardUnknown() {
	xxx_messageInfo_GcRule_Union.DiscardUnknown(m)
}

var xxx_messageInfo_GcRule_Union proto.InternalMessageInfo

func (m *GcRule_Union) GetRules() []*GcRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// A snapshot of a table at a particular time. A snapshot can be used as a
// checkpoint for data restoration or a data source for a new table.
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type Snapshot struct {
	// Output only. The unique name of the snapshot.
	// Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>/snapshots/<snapshot>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The source table at the time the snapshot was taken.
	SourceTable *Table `protobuf:"bytes,2,opt,name=source_table,json=sourceTable,proto3" json:"source_table,omitempty"`
	// Output only. The size of the data in the source table at the time the
	// snapshot was taken. In some cases, this value may be computed
	// asynchronously via a background process and a placeholder of 0 will be used
	// in the meantime.
	DataSizeBytes int64 `protobuf:"varint,3,opt,name=data_size_bytes,json=dataSizeBytes,proto3" json:"data_size_bytes,omitempty"`
	// Output only. The time when the snapshot is created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the snapshot will be deleted. The maximum amount
	// of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
	// the default maximum of 365 days will be used.
	DeleteTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The current state of the snapshot.
	State Snapshot_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.bigtable.admin.v2.Snapshot_State" json:"state,omitempty"`
	// Output only. Description of the snapshot.
	Description          string   `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Snapshot) Reset()         { *m = Snapshot{} }
func (m *Snapshot) String() string { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()    {}
func (*Snapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{4}
}

func (m *Snapshot) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Snapshot.Unmarshal(m, b)
}
func (m *Snapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Snapshot.Marshal(b, m, deterministic)
}
func (m *Snapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Snapshot.Merge(m, src)
}
func (m *Snapshot) XXX_Size() int {
	return xxx_messageInfo_Snapshot.Size(m)
}
func (m *Snapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_Snapshot.DiscardUnknown(m)
}

var xxx_messageInfo_Snapshot proto.InternalMessageInfo

func (m *Snapshot) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Snapshot) GetSourceTable() *Table {
	if m != nil {
		return m.SourceTable
	}
	return nil
}

func (m *Snapshot) GetDataSizeBytes() int64 {
	if m != nil {
		return m.DataSizeBytes
	}
	return 0
}

func (m *Snapshot) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Snapshot) GetDeleteTime() *timestamp.Timestamp {
	if m != nil {
		return m.DeleteTime
	}
	return nil
}

func (m *Snapshot) GetState() Snapshot_State {
	if m != nil {
		return m.State
	}
	return Snapshot_STATE_NOT_KNOWN
}

func (m *Snapshot) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// A backup of a Cloud Bigtable table.
type Backup struct {
	// Output only. A globally unique identifier for the backup which cannot be
	// changed. Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}/
	//    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
	// The final segment of the name must be between 1 and 50 characters
	// in length.
	//
	// The backup is stored in the cluster identified by the prefix of the backup
	// name of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Name of the table from which this backup was created.
	// This needs to be in the same instance as the backup. Values are of the form
	// `projects/{project}/instances/{instance}/tables/{source_table}`.
	SourceTable string `protobuf:"bytes,2,opt,name=source_table,json=sourceTable,proto3" json:"source_table,omitempty"`
	// Required. The expiration time of the backup, with microseconds
	// granularity that must be at least 6 hours and at most 30 days
	// from the time the request is received. Once the `expire_time`
	// has passed, Cloud Bigtable will delete the backup and free the
	// resources used by the backup.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. `start_time` is the time that the backup was started
	// (i.e. approximately the time the
	// [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup]
	// request is received).  The row data in this backup will be no older than
	// this timestamp.
	StartTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. `end_time` is the time that the backup was finished. The row
	// data in the backup will be no newer than this timestamp.
	EndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Size of the backup in bytes.
	SizeBytes int64 `protobuf:"varint,6,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. The current state of the backup.
	State                Backup_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.bigtable.admin.v2.Backup_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Backup) Reset()         { *m = Backup{} }
func (m *Backup) String() string { return proto.CompactTextString(m) }
func (*Backup) ProtoMessage()    {}
func (*Backup) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{5}
}

func (m *Backup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Backup.Unmarshal(m, b)
}
func (m *Backup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Backup.Marshal(b, m, deterministic)
}
func (m *Backup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Backup.Merge(m, src)
}
func (m *Backup) XXX_Size() int {
	return xxx_messageInfo_Backup.Size(m)
}
func (m *Backup) XXX_DiscardUnknown() {
	xxx_messageInfo_Backup.DiscardUnknown(m)
}

var xxx_messageInfo_Backup proto.InternalMessageInfo

func (m *Backup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Backup) GetSourceTable() string {
	if m != nil {
		return m.SourceTable
	}
	return ""
}

func (m *Backup) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *Backup) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Backup) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Backup) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

func (m *Backup) GetState() Backup_State {
	if m != nil {
		return m.State
	}
	return Backup_STATE_UNSPECIFIED
}

// Information about a backup.
type BackupInfo struct {
	// Output only. Name of the backup.
	Backup string `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// Output only. The time that the backup was started. Row data in the backup
	// will be no older than this timestamp.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. This time that the backup was finished. Row data in the
	// backup will be no newer than this timestamp.
	EndTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Name of the table the backup was created from.
	SourceTable          string   `protobuf:"bytes,4,opt,name=source_table,json=sourceTable,proto3" json:"source_table,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupInfo) Reset()         { *m = BackupInfo{} }
func (m *BackupInfo) String() string { return proto.CompactTextString(m) }
func (*BackupInfo) ProtoMessage()    {}
func (*BackupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ea1666be9e81bb35, []int{6}
}

func (m *BackupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupInfo.Unmarshal(m, b)
}
func (m *BackupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupInfo.Marshal(b, m, deterministic)
}
func (m *BackupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupInfo.Merge(m, src)
}
func (m *BackupInfo) XXX_Size() int {
	return xxx_messageInfo_BackupInfo.Size(m)
}
func (m *BackupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_BackupInfo proto.InternalMessageInfo

func (m *BackupInfo) GetBackup() string {
	if m != nil {
		return m.Backup
	}
	return ""
}

func (m *BackupInfo) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *BackupInfo) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *BackupInfo) GetSourceTable() string {
	if m != nil {
		return m.SourceTable
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.bigtable.admin.v2.RestoreSourceType", RestoreSourceType_name, RestoreSourceType_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Table_TimestampGranularity", Table_TimestampGranularity_name, Table_TimestampGranularity_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Table_View", Table_View_name, Table_View_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Table_ClusterState_ReplicationState", Table_ClusterState_ReplicationState_name, Table_ClusterState_ReplicationState_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Snapshot_State", Snapshot_State_name, Snapshot_State_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Backup_State", Backup_State_name, Backup_State_value)
	proto.RegisterType((*RestoreInfo)(nil), "google.bigtable.admin.v2.RestoreInfo")
	proto.RegisterType((*Table)(nil), "google.bigtable.admin.v2.Table")
	proto.RegisterMapType((map[string]*Table_ClusterState)(nil), "google.bigtable.admin.v2.Table.ClusterStatesEntry")
	proto.RegisterMapType((map[string]*ColumnFamily)(nil), "google.bigtable.admin.v2.Table.ColumnFamiliesEntry")
	proto.RegisterType((*Table_ClusterState)(nil), "google.bigtable.admin.v2.Table.ClusterState")
	proto.RegisterType((*ColumnFamily)(nil), "google.bigtable.admin.v2.ColumnFamily")
	proto.RegisterType((*GcRule)(nil), "google.bigtable.admin.v2.GcRule")
	proto.RegisterType((*GcRule_Intersection)(nil), "google.bigtable.admin.v2.GcRule.Intersection")
	proto.RegisterType((*GcRule_Union)(nil), "google.bigtable.admin.v2.GcRule.Union")
	proto.RegisterType((*Snapshot)(nil), "google.bigtable.admin.v2.Snapshot")
	proto.RegisterType((*Backup)(nil), "google.bigtable.admin.v2.Backup")
	proto.RegisterType((*BackupInfo)(nil), "google.bigtable.admin.v2.BackupInfo")
}

func init() {
	proto.RegisterFile("google/bigtable/admin/v2/table.proto", fileDescriptor_ea1666be9e81bb35)
}

var fileDescriptor_ea1666be9e81bb35 = []byte{
	// 1395 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0xdb, 0x6e, 0xdb, 0x46,
	0x13, 0x36, 0x45, 0x49, 0xb6, 0x47, 0xb2, 0xcd, 0x6c, 0x12, 0xc4, 0xd1, 0xff, 0x37, 0x76, 0xd5,
	0xc4, 0x70, 0xd3, 0x96, 0x04, 0x94, 0x34, 0x6d, 0x9d, 0x26, 0x2d, 0x25, 0xd3, 0x36, 0x11, 0x99,
	0x12, 0x28, 0xda, 0x81, 0x03, 0x03, 0x04, 0x45, 0xad, 0x15, 0x26, 0x3c, 0x08, 0x3c, 0xb8, 0x76,
	0x0c, 0x3f, 0x41, 0x81, 0xa2, 0x37, 0xbd, 0xeb, 0x13, 0x14, 0xe8, 0x55, 0xdf, 0xa2, 0x40, 0xdf,
	0x21, 0x17, 0xbd, 0xca, 0x53, 0x14, 0xdc, 0x25, 0x25, 0xfa, 0xa0, 0xca, 0x69, 0xae, 0x34, 0x9c,
	0x9d, 0xef, 0x9b, 0xe5, 0xcc, 0xc7, 0xd9, 0x15, 0xdc, 0xed, 0x7b, 0x5e, 0xdf, 0xc6, 0x42, 0xd7,
	0xea, 0x87, 0x46, 0xd7, 0xc6, 0x82, 0xd1, 0x73, 0x2c, 0x57, 0x38, 0xac, 0x09, 0xe4, 0x91, 0x1f,
	0xf8, 0x5e, 0xe8, 0xa1, 0x45, 0x1a, 0xc5, 0xa7, 0x51, 0x3c, 0x89, 0xe2, 0x0f, 0x6b, 0x95, 0xa5,
	0x04, 0x6f, 0x0c, 0x2c, 0xe1, 0xc0, 0xc2, 0x76, 0x4f, 0xef, 0xe2, 0x97, 0xc6, 0xa1, 0xe5, 0xf9,
	0x14, 0x5a, 0xb9, 0x9d, 0x09, 0xf0, 0x71, 0xe0, 0x45, 0xbe, 0x99, 0xb0, 0x56, 0xee, 0x24, 0x4b,
	0xe4, 0xa9, 0x1b, 0x1d, 0x08, 0xbd, 0xc8, 0x37, 0x42, 0xcb, 0x73, 0x93, 0xf5, 0xa5, 0xf3, 0xeb,
	0xa1, 0xe5, 0xe0, 0x20, 0x34, 0x9c, 0x01, 0x0d, 0xa8, 0xfe, 0xc1, 0x40, 0x49, 0xc5, 0x41, 0xe8,
	0xf9, 0x58, 0x76, 0x0f, 0x3c, 0xd4, 0x84, 0x12, 0x4d, 0xa0, 0x87, 0xc7, 0x03, 0xbc, 0xc8, 0x2c,
	0x33, 0xab, 0xf3, 0xb5, 0xcf, 0xf8, 0x71, 0x9b, 0xe7, 0x13, 0x6c, 0x87, 0x60, 0xb4, 0xe3, 0x01,
	0x56, 0x21, 0x18, 0xda, 0x68, 0x13, 0x4a, 0x5d, 0xc3, 0x7c, 0x1d, 0x0d, 0x74, 0xcb, 0x3d, 0xf0,
	0x16, 0x73, 0xcb, 0xcc, 0x6a, 0xa9, 0x76, 0x77, 0x3c, 0x5b, 0x9d, 0x04, 0xc7, 0x1b, 0xd9, 0x9a,
	0x52, 0xa1, 0x3b, 0x7c, 0xaa, 0xcf, 0x0d, 0xb7, 0x15, 0x13, 0x55, 0xff, 0x9e, 0x81, 0x82, 0x16,
	0x43, 0x11, 0x82, 0xbc, 0x6b, 0x38, 0x74, 0xa3, 0xb3, 0x2a, 0xb1, 0xd1, 0x1e, 0xcc, 0x9b, 0x76,
	0x14, 0x84, 0xd8, 0xd7, 0x83, 0xd0, 0x08, 0x71, 0xb0, 0x98, 0x5b, 0x66, 0x57, 0x4b, 0xb5, 0xda,
	0xf8, 0xc4, 0x84, 0x8c, 0x6f, 0x50, 0x54, 0x87, 0x80, 0x24, 0x37, 0xf4, 0x8f, 0xd5, 0x39, 0x33,
	0xeb, 0x43, 0xfb, 0xb0, 0x60, 0x7a, 0x76, 0xe4, 0xb8, 0xfa, 0x81, 0xe1, 0x58, 0xb6, 0x85, 0x83,
	0x45, 0x96, 0x70, 0x3f, 0x98, 0xc8, 0x4d, 0x60, 0x1b, 0x09, 0x8a, 0x92, 0xcf, 0x9b, 0x67, 0x9c,
	0x68, 0x17, 0x4a, 0x7d, 0xdf, 0x70, 0x23, 0xdb, 0xf0, 0xad, 0xf0, 0x78, 0x31, 0x4f, 0x8a, 0xff,
	0x70, 0x12, 0xb3, 0x96, 0xb6, 0x74, 0x73, 0x84, 0x55, 0xb3, 0x44, 0x68, 0x0b, 0xca, 0x3e, 0xed,
	0x13, 0xed, 0x43, 0x91, 0xf4, 0xe1, 0xde, 0xc4, 0xae, 0xc6, 0xa5, 0x57, 0x4b, 0xfe, 0xe8, 0xa1,
	0xf2, 0x63, 0x0e, 0xca, 0xd9, 0x2a, 0xa1, 0x57, 0x70, 0xcd, 0xc7, 0x03, 0xdb, 0x32, 0x89, 0xea,
	0x68, 0xbd, 0x13, 0xd5, 0x3c, 0x79, 0x9f, 0x72, 0xf3, 0xea, 0x88, 0x85, 0x38, 0x54, 0xce, 0x3f,
	0xe7, 0xa9, 0xfe, 0xc4, 0x00, 0x77, 0x3e, 0x0c, 0x5d, 0x87, 0x85, 0x8e, 0x26, 0x6a, 0x92, 0xae,
	0xb4, 0x34, 0xfd, 0x99, 0xd2, 0x7a, 0xae, 0x70, 0x53, 0x88, 0x83, 0xb2, 0xac, 0xc8, 0x9a, 0x2c,
	0x36, 0xe5, 0x17, 0xb2, 0xb2, 0xc9, 0x31, 0xe8, 0x16, 0x5c, 0x6f, 0x37, 0x45, 0x45, 0x91, 0xd6,
	0xf5, 0x6d, 0x51, 0x56, 0x34, 0x49, 0x11, 0x95, 0x86, 0xc4, 0xe5, 0xd0, 0x6d, 0xb8, 0xb9, 0xa3,
	0x5c, 0xb6, 0xc4, 0xa2, 0x59, 0x28, 0xa8, 0x92, 0xb8, 0xbe, 0xc7, 0xe5, 0xd1, 0x0d, 0xe0, 0x88,
	0xa9, 0xb7, 0xda, 0x9a, 0xbc, 0x4d, 0x49, 0x0b, 0x15, 0x17, 0xd0, 0x45, 0xc9, 0x20, 0x0e, 0xd8,
	0xd7, 0xf8, 0x38, 0x51, 0x64, 0x6c, 0xa2, 0x3a, 0x14, 0x0e, 0x0d, 0x3b, 0xc2, 0xc9, 0x07, 0xf0,
	0xf9, 0xfb, 0x14, 0x46, 0xa5, 0xd0, 0xb5, 0xdc, 0xd7, 0x4c, 0xc5, 0x82, 0xeb, 0x97, 0xc8, 0xe8,
	0x92, 0x84, 0xdf, 0x9e, 0x4d, 0xb8, 0x32, 0x3e, 0x61, 0x86, 0xef, 0x38, 0x93, 0xaa, 0x2a, 0xc3,
	0x8d, 0xcb, 0x74, 0x85, 0xee, 0xc1, 0xc7, 0x9a, 0xbc, 0x2d, 0x75, 0x34, 0x71, 0xbb, 0xad, 0x6f,
	0xaa, 0xa2, 0xb2, 0xd3, 0x14, 0x55, 0x59, 0xdb, 0xd3, 0x77, 0x94, 0x4e, 0x5b, 0x6a, 0xc8, 0x1b,
	0xb2, 0xb4, 0xce, 0x4d, 0x21, 0x80, 0xe2, 0xb6, 0xdc, 0x6c, 0xca, 0x1d, 0x8e, 0xa9, 0xee, 0x43,
	0x7e, 0xd7, 0xc2, 0x3f, 0xc4, 0x35, 0xdc, 0x95, 0xa5, 0xe7, 0xe7, 0x22, 0xe7, 0x60, 0x56, 0x11,
	0xb7, 0x25, 0xbd, 0xa5, 0x34, 0xf7, 0x38, 0x06, 0x2d, 0x40, 0xa9, 0xd3, 0xd8, 0x92, 0xb6, 0x45,
	0x3d, 0x8e, 0xe5, 0x72, 0xb4, 0xf2, 0xed, 0xa6, 0xdc, 0x10, 0x35, 0xb9, 0xa5, 0x50, 0x2f, 0x8b,
	0x66, 0x20, 0xbf, 0xb1, 0xd3, 0x6c, 0x72, 0xf9, 0xb5, 0x17, 0xef, 0xc4, 0xe7, 0xf0, 0xd1, 0xf0,
	0xc5, 0xe8, 0x8b, 0x1a, 0x03, 0x2b, 0xe0, 0x4d, 0xcf, 0x11, 0xe8, 0x90, 0x78, 0x34, 0xf0, 0xbd,
	0x57, 0xd8, 0x0c, 0x03, 0xe1, 0x24, 0xb1, 0x4e, 0x05, 0xcb, 0x0d, 0x42, 0xc3, 0x35, 0x71, 0x20,
	0x9c, 0xa4, 0xe6, 0x29, 0x1d, 0xd8, 0x81, 0x70, 0x42, 0x7e, 0x4f, 0xab, 0x32, 0x94, 0xb3, 0xf5,
	0x41, 0xdf, 0xc0, 0x74, 0xdf, 0xd4, 0xfd, 0xc8, 0xa6, 0x12, 0x2f, 0xd5, 0x96, 0xc7, 0x17, 0x76,
	0xd3, 0x54, 0x23, 0x1b, 0xab, 0xc5, 0x3e, 0xf9, 0xad, 0xfe, 0xcc, 0x42, 0x91, 0xba, 0xd0, 0x7d,
	0xe0, 0x1c, 0xe3, 0x48, 0x77, 0x23, 0x47, 0x3f, 0xc4, 0x7e, 0x60, 0x79, 0x6e, 0x40, 0xe8, 0x0a,
	0x5b, 0x53, 0xea, 0xbc, 0x63, 0x1c, 0x29, 0x91, 0xb3, 0x9b, 0xf8, 0xd1, 0x43, 0x98, 0x8e, 0x63,
	0x8d, 0x7e, 0xda, 0xca, 0xdb, 0x69, 0xc6, 0x74, 0xa2, 0xf3, 0xeb, 0xc9, 0xc4, 0xdf, 0x9a, 0x52,
	0x8b, 0x8e, 0x71, 0x24, 0xf6, 0x31, 0xea, 0x40, 0xd9, 0x72, 0x43, 0xec, 0x07, 0xd8, 0x8c, 0x57,
	0x16, 0x59, 0x02, 0xfd, 0x62, 0xd2, 0x66, 0x79, 0x39, 0x03, 0xda, 0x9a, 0x52, 0xcf, 0x90, 0xa0,
	0xa7, 0x50, 0x88, 0xdc, 0x98, 0x2d, 0x3f, 0x49, 0x53, 0x09, 0xdb, 0x8e, 0x4b, 0x69, 0x28, 0xac,
	0xb2, 0x01, 0xe5, 0x2c, 0x3f, 0x7a, 0x04, 0x85, 0xb8, 0x92, 0xf1, 0xbb, 0xb3, 0x57, 0x2a, 0x25,
	0x0d, 0xaf, 0x7c, 0x07, 0x05, 0xc2, 0xfc, 0x5f, 0x09, 0xea, 0x45, 0xc8, 0xc7, 0x46, 0xf5, 0x97,
	0x3c, 0xcc, 0x74, 0x5c, 0x63, 0x10, 0xbc, 0xf4, 0xc2, 0x4b, 0xcf, 0x91, 0x3a, 0x94, 0xd3, 0xb3,
	0x30, 0xe6, 0x4b, 0x3a, 0xb0, 0x34, 0xe1, 0xeb, 0x55, 0x93, 0x93, 0x8a, 0x4a, 0x6f, 0x05, 0x16,
	0x7a, 0x46, 0x68, 0xe8, 0x81, 0xf5, 0x06, 0xeb, 0xdd, 0xe3, 0x90, 0x1c, 0x18, 0xcc, 0x2a, 0xab,
	0xce, 0xc5, 0xee, 0x8e, 0xf5, 0x06, 0xd7, 0x63, 0x27, 0x7a, 0x0c, 0x25, 0xd3, 0xc7, 0x46, 0x88,
	0xf5, 0xf8, 0x84, 0x4e, 0x6a, 0x5c, 0xb9, 0xd0, 0xec, 0xe1, 0x37, 0xa9, 0x02, 0x0d, 0x8f, 0x1d,
	0x31, 0xb8, 0x87, 0x6d, 0x9c, 0x82, 0x0b, 0x93, 0xc1, 0x34, 0x9c, 0x80, 0x9f, 0x42, 0x81, 0x4e,
	0xed, 0x22, 0x99, 0xda, 0xab, 0xe3, 0x5f, 0x2f, 0x2d, 0x16, 0x9f, 0x0c, 0x26, 0x02, 0x43, 0xcb,
	0x71, 0xf2, 0xc0, 0xf4, 0xad, 0x01, 0xd1, 0xda, 0x34, 0x29, 0x60, 0xd6, 0x55, 0xfd, 0x12, 0x0a,
	0xff, 0x32, 0xab, 0x87, 0x53, 0x96, 0x41, 0x65, 0x98, 0x69, 0xa8, 0x92, 0xa8, 0xc5, 0xd3, 0x35,
	0xb7, 0x76, 0xf8, 0x4e, 0x0c, 0x60, 0x79, 0xdc, 0x97, 0x3d, 0xec, 0x5c, 0xeb, 0xaa, 0x1f, 0x77,
	0x72, 0x92, 0x07, 0xc2, 0x49, 0x62, 0x9d, 0x0a, 0x41, 0x42, 0x12, 0x08, 0x27, 0xa9, 0x79, 0x5a,
	0xfd, 0x35, 0x0f, 0x45, 0x7a, 0x11, 0x41, 0xb7, 0xb2, 0xaa, 0xa8, 0xb3, 0x6f, 0x45, 0x36, 0x91,
	0xc6, 0xa7, 0x97, 0x48, 0x63, 0xb6, 0x5e, 0x7c, 0x2b, 0x16, 0xde, 0x8a, 0xb9, 0xb3, 0x0a, 0xf8,
	0x1e, 0x4a, 0xf8, 0x68, 0x60, 0xf9, 0x49, 0x73, 0xd8, 0x49, 0xcd, 0x89, 0xd3, 0xe4, 0x54, 0xa0,
	0x98, 0xa4, 0x43, 0x10, 0x84, 0x86, 0x1f, 0x5e, 0x51, 0x1a, 0x74, 0x9f, 0xb3, 0x04, 0x42, 0xf0,
	0x6b, 0x30, 0x83, 0xdd, 0xde, 0x15, 0xb5, 0x41, 0xd1, 0xd3, 0xd8, 0xed, 0x11, 0x6c, 0x15, 0x20,
	0x23, 0xdd, 0x58, 0x22, 0x6c, 0xca, 0x3f, 0xd4, 0xae, 0x98, 0x2a, 0x68, 0x9a, 0x28, 0x68, 0x65,
	0xd2, 0xfd, 0x8e, 0xea, 0x87, 0xd2, 0x50, 0x64, 0xf5, 0xab, 0x54, 0x22, 0x37, 0xe1, 0x1a, 0x95,
	0xc8, 0xd9, 0x53, 0x22, 0xab, 0x0c, 0x66, 0x24, 0x99, 0xdc, 0xda, 0xe0, 0x9d, 0xe8, 0xc0, 0x9d,
	0x71, 0x22, 0x49, 0xda, 0xf8, 0xec, 0x03, 0x24, 0x42, 0x2f, 0xa1, 0x81, 0x70, 0x42, 0x8d, 0xd3,
	0xea, 0x5f, 0x0c, 0xc0, 0xe8, 0x9e, 0x8a, 0xfe, 0x07, 0x45, 0xba, 0x92, 0x15, 0x49, 0xe2, 0x3a,
	0xd7, 0xb9, 0xdc, 0x07, 0x75, 0x8e, 0x7d, 0xcf, 0xce, 0xad, 0x9c, 0x93, 0x68, 0x7e, 0xb4, 0xbd,
	0xac, 0x3e, 0xef, 0xaf, 0xc3, 0xb5, 0x0b, 0x97, 0x78, 0xf4, 0x09, 0x2c, 0xa9, 0x52, 0x47, 0x6b,
	0xa9, 0x92, 0xde, 0x69, 0xed, 0xa8, 0x0d, 0x49, 0xd7, 0xf6, 0xda, 0xd2, 0xc5, 0x43, 0xbe, 0x2e,
	0x36, 0x9e, 0xed, 0xb4, 0x39, 0xa6, 0xfe, 0x3b, 0x03, 0xff, 0x37, 0x3d, 0x67, 0x6c, 0xeb, 0xeb,
	0x40, 0xb2, 0xb5, 0xe3, 0x5d, 0xb7, 0x99, 0x17, 0x4f, 0x92, 0xb8, 0xbe, 0x67, 0x1b, 0x6e, 0x9f,
	0xf7, 0xfc, 0xbe, 0xd0, 0xc7, 0x2e, 0x79, 0x27, 0x61, 0xd4, 0xc3, 0x8b, 0x7f, 0xa9, 0x1e, 0x13,
	0xe3, 0xb7, 0xdc, 0x9d, 0x4d, 0x8a, 0x6f, 0xd8, 0x5e, 0xd4, 0xe3, 0xeb, 0x69, 0x36, 0x91, 0x64,
	0xdb, 0xad, 0xfd, 0x99, 0x06, 0xec, 0x93, 0x80, 0xfd, 0x34, 0x60, 0x9f, 0x04, 0xec, 0xef, 0xd6,
	0xba, 0x45, 0x92, 0xeb, 0xc1, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x8d, 0x66, 0xfe, 0xc3, 0xbd,
	0x0d, 0x00, 0x00,
}
