// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/featurestore_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class FeaturestoreServiceConnectionIdempotencyPolicy {
 public:
  virtual ~FeaturestoreServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<FeaturestoreServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency CreateFeaturestore(
      google::cloud::aiplatform::v1::CreateFeaturestoreRequest const& request);

  virtual google::cloud::Idempotency GetFeaturestore(
      google::cloud::aiplatform::v1::GetFeaturestoreRequest const& request);

  virtual google::cloud::Idempotency ListFeaturestores(
      google::cloud::aiplatform::v1::ListFeaturestoresRequest request);

  virtual google::cloud::Idempotency UpdateFeaturestore(
      google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const& request);

  virtual google::cloud::Idempotency DeleteFeaturestore(
      google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const& request);

  virtual google::cloud::Idempotency CreateEntityType(
      google::cloud::aiplatform::v1::CreateEntityTypeRequest const& request);

  virtual google::cloud::Idempotency GetEntityType(
      google::cloud::aiplatform::v1::GetEntityTypeRequest const& request);

  virtual google::cloud::Idempotency ListEntityTypes(
      google::cloud::aiplatform::v1::ListEntityTypesRequest request);

  virtual google::cloud::Idempotency UpdateEntityType(
      google::cloud::aiplatform::v1::UpdateEntityTypeRequest const& request);

  virtual google::cloud::Idempotency DeleteEntityType(
      google::cloud::aiplatform::v1::DeleteEntityTypeRequest const& request);

  virtual google::cloud::Idempotency CreateFeature(
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request);

  virtual google::cloud::Idempotency BatchCreateFeatures(
      google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const& request);

  virtual google::cloud::Idempotency GetFeature(
      google::cloud::aiplatform::v1::GetFeatureRequest const& request);

  virtual google::cloud::Idempotency ListFeatures(
      google::cloud::aiplatform::v1::ListFeaturesRequest request);

  virtual google::cloud::Idempotency UpdateFeature(
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request);

  virtual google::cloud::Idempotency DeleteFeature(
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request);

  virtual google::cloud::Idempotency ImportFeatureValues(
      google::cloud::aiplatform::v1::ImportFeatureValuesRequest const& request);

  virtual google::cloud::Idempotency BatchReadFeatureValues(
      google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&
          request);

  virtual google::cloud::Idempotency ExportFeatureValues(
      google::cloud::aiplatform::v1::ExportFeatureValuesRequest const& request);

  virtual google::cloud::Idempotency DeleteFeatureValues(
      google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const& request);

  virtual google::cloud::Idempotency SearchFeatures(
      google::cloud::aiplatform::v1::SearchFeaturesRequest request);
};

std::unique_ptr<FeaturestoreServiceConnectionIdempotencyPolicy>
MakeDefaultFeaturestoreServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_CONNECTION_IDEMPOTENCY_POLICY_H
