// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_backend_services/v1/region_backend_services.proto

#include "google/cloud/compute/region_backend_services/v1/internal/region_backend_services_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_backend_services_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegionBackendServicesTracingConnection::RegionBackendServicesTracingConnection(
    std::shared_ptr<
        compute_region_backend_services_v1::RegionBackendServicesConnection>
        child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesTracingConnection::DeleteBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        DeleteBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "DeleteBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteBackendService(request));
}

StatusOr<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesTracingConnection::GetBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        GetBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "GetBackendService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackendService(request));
}

StatusOr<google::cloud::cpp::compute::v1::BackendServiceGroupHealth>
RegionBackendServicesTracingConnection::GetHealth(
    google::cloud::cpp::compute::region_backend_services::v1::
        GetHealthRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "GetHealth");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetHealth(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionBackendServicesTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::region_backend_services::v1::
        GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesTracingConnection::InsertBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        InsertBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "InsertBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertBackendService(request));
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesTracingConnection::ListRegionBackendServices(
    google::cloud::cpp::compute::region_backend_services::v1::
        ListRegionBackendServicesRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "ListRegionBackendServices");
  internal::OTelScope scope(span);
  auto sr = child_->ListRegionBackendServices(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::BackendService>(std::move(span),
                                                       std::move(sr));
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesTracingConnection::ListUsable(
    google::cloud::cpp::compute::region_backend_services::v1::ListUsableRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "ListUsable");
  internal::OTelScope scope(span);
  auto sr = child_->ListUsable(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::BackendService>(std::move(span),
                                                       std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesTracingConnection::PatchBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        PatchBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "PatchBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchBackendService(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionBackendServicesTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::region_backend_services::v1::
        SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesTracingConnection::SetSecurityPolicy(
    google::cloud::cpp::compute::region_backend_services::v1::
        SetSecurityPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "SetSecurityPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetSecurityPolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionBackendServicesTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::region_backend_services::v1::
        TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesTracingConnection::UpdateBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        UpdateBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_backend_services_v1::RegionBackendServicesConnection::"
      "UpdateBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateBackendService(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<
    compute_region_backend_services_v1::RegionBackendServicesConnection>
MakeRegionBackendServicesTracingConnection(
    std::shared_ptr<
        compute_region_backend_services_v1::RegionBackendServicesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RegionBackendServicesTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_backend_services_v1_internal
}  // namespace cloud
}  // namespace google
