// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/internal/subscriber_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/pubsub/v1/pubsub.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SubscriberMetadata::SubscriberMetadata(
    std::shared_ptr<SubscriberStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::pubsub::v1::Subscription>
SubscriberMetadata::CreateSubscription(
    grpc::ClientContext& context,
    google::pubsub::v1::Subscription const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CreateSubscription(context, request);
}

StatusOr<google::pubsub::v1::Subscription> SubscriberMetadata::GetSubscription(
    grpc::ClientContext& context,
    google::pubsub::v1::GetSubscriptionRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("subscription=",
                           internal::UrlEncode(request.subscription())));
  return child_->GetSubscription(context, request);
}

StatusOr<google::pubsub::v1::Subscription>
SubscriberMetadata::UpdateSubscription(
    grpc::ClientContext& context,
    google::pubsub::v1::UpdateSubscriptionRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("subscription.name=",
                           internal::UrlEncode(request.subscription().name())));
  return child_->UpdateSubscription(context, request);
}

StatusOr<google::pubsub::v1::ListSubscriptionsResponse>
SubscriberMetadata::ListSubscriptions(
    grpc::ClientContext& context,
    google::pubsub::v1::ListSubscriptionsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("project=", internal::UrlEncode(request.project())));
  return child_->ListSubscriptions(context, request);
}

Status SubscriberMetadata::DeleteSubscription(
    grpc::ClientContext& context,
    google::pubsub::v1::DeleteSubscriptionRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("subscription=",
                           internal::UrlEncode(request.subscription())));
  return child_->DeleteSubscription(context, request);
}

StatusOr<google::pubsub::v1::PullResponse> SubscriberMetadata::Pull(
    grpc::ClientContext& context,
    google::pubsub::v1::PullRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("subscription=",
                           internal::UrlEncode(request.subscription())));
  return child_->Pull(context, request);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::pubsub::v1::StreamingPullRequest,
    google::pubsub::v1::StreamingPullResponse>>
SubscriberMetadata::AsyncStreamingPull(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context) {
  SetMetadata(*context, internal::CurrentOptions());
  return child_->AsyncStreamingPull(cq, std::move(context));
}

Status SubscriberMetadata::ModifyPushConfig(
    grpc::ClientContext& context,
    google::pubsub::v1::ModifyPushConfigRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("subscription=",
                           internal::UrlEncode(request.subscription())));
  return child_->ModifyPushConfig(context, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberMetadata::GetSnapshot(
    grpc::ClientContext& context,
    google::pubsub::v1::GetSnapshotRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("snapshot=", internal::UrlEncode(request.snapshot())));
  return child_->GetSnapshot(context, request);
}

StatusOr<google::pubsub::v1::ListSnapshotsResponse>
SubscriberMetadata::ListSnapshots(
    grpc::ClientContext& context,
    google::pubsub::v1::ListSnapshotsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("project=", internal::UrlEncode(request.project())));
  return child_->ListSnapshots(context, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberMetadata::CreateSnapshot(
    grpc::ClientContext& context,
    google::pubsub::v1::CreateSnapshotRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CreateSnapshot(context, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberMetadata::UpdateSnapshot(
    grpc::ClientContext& context,
    google::pubsub::v1::UpdateSnapshotRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("snapshot.name=",
                           internal::UrlEncode(request.snapshot().name())));
  return child_->UpdateSnapshot(context, request);
}

Status SubscriberMetadata::DeleteSnapshot(
    grpc::ClientContext& context,
    google::pubsub::v1::DeleteSnapshotRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("snapshot=", internal::UrlEncode(request.snapshot())));
  return child_->DeleteSnapshot(context, request);
}

StatusOr<google::pubsub::v1::SeekResponse> SubscriberMetadata::Seek(
    grpc::ClientContext& context,
    google::pubsub::v1::SeekRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("subscription=",
                           internal::UrlEncode(request.subscription())));
  return child_->Seek(context, request);
}

future<Status> SubscriberMetadata::AsyncModifyAckDeadline(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::pubsub::v1::ModifyAckDeadlineRequest const& request) {
  SetMetadata(*context, internal::CurrentOptions(),
              absl::StrCat("subscription=",
                           internal::UrlEncode(request.subscription())));
  return child_->AsyncModifyAckDeadline(cq, std::move(context), request);
}

future<Status> SubscriberMetadata::AsyncAcknowledge(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::pubsub::v1::AcknowledgeRequest const& request) {
  SetMetadata(*context, internal::CurrentOptions(),
              absl::StrCat("subscription=",
                           internal::UrlEncode(request.subscription())));
  return child_->AsyncAcknowledge(cq, std::move(context), request);
}

void SubscriberMetadata::SetMetadata(grpc::ClientContext& context,
                                     Options const& options,
                                     std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void SubscriberMetadata::SetMetadata(grpc::ClientContext& context,
                                     Options const& options) {
  for (auto const& kv : fixed_metadata_) {
    context.AddMetadata(kv.first, kv.second);
  }
  context.AddMetadata("x-goog-api-client", api_client_header_);
  if (options.has<UserProjectOption>()) {
    context.AddMetadata("x-goog-user-project",
                        options.get<UserProjectOption>());
  }
  auto const& authority = options.get<AuthorityOption>();
  if (!authority.empty()) context.set_authority(authority);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
