// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#include "google/cloud/vmwareengine/v1/internal/vmware_engine_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/vmwareengine/v1/vmwareengine.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vmwareengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VmwareEngineStub::~VmwareEngineStub() = default;

StatusOr<google::cloud::vmwareengine::v1::ListPrivateCloudsResponse>
DefaultVmwareEngineStub::ListPrivateClouds(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListPrivateCloudsRequest const& request) {
  google::cloud::vmwareengine::v1::ListPrivateCloudsResponse response;
  auto status = grpc_stub_->ListPrivateClouds(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
DefaultVmwareEngineStub::GetPrivateCloud(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request) {
  google::cloud::vmwareengine::v1::PrivateCloud response;
  auto status = grpc_stub_->GetPrivateCloud(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncCreatePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::CreatePrivateCloudRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreatePrivateCloud(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncUpdatePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdatePrivateCloud(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncDeletePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::DeletePrivateCloudRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeletePrivateCloud(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncUndeletePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUndeletePrivateCloud(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::vmwareengine::v1::ListClustersResponse>
DefaultVmwareEngineStub::ListClusters(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListClustersRequest const& request) {
  google::cloud::vmwareengine::v1::ListClustersResponse response;
  auto status = grpc_stub_->ListClusters(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
DefaultVmwareEngineStub::GetCluster(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetClusterRequest const& request) {
  google::cloud::vmwareengine::v1::Cluster response;
  auto status = grpc_stub_->GetCluster(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncCreateCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::CreateClusterRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::CreateClusterRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::CreateClusterRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateCluster(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncUpdateCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::UpdateClusterRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::UpdateClusterRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::UpdateClusterRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateCluster(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncDeleteCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::DeleteClusterRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::DeleteClusterRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::DeleteClusterRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteCluster(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::vmwareengine::v1::ListSubnetsResponse>
DefaultVmwareEngineStub::ListSubnets(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListSubnetsRequest const& request) {
  google::cloud::vmwareengine::v1::ListSubnetsResponse response;
  auto status = grpc_stub_->ListSubnets(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::Subnet>
DefaultVmwareEngineStub::GetSubnet(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetSubnetRequest const& request) {
  google::cloud::vmwareengine::v1::Subnet response;
  auto status = grpc_stub_->GetSubnet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncUpdateSubnet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::UpdateSubnetRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateSubnet(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::vmwareengine::v1::ListNodeTypesResponse>
DefaultVmwareEngineStub::ListNodeTypes(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListNodeTypesRequest const& request) {
  google::cloud::vmwareengine::v1::ListNodeTypesResponse response;
  auto status = grpc_stub_->ListNodeTypes(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
DefaultVmwareEngineStub::GetNodeType(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request) {
  google::cloud::vmwareengine::v1::NodeType response;
  auto status = grpc_stub_->GetNodeType(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
DefaultVmwareEngineStub::ShowNsxCredentials(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const& request) {
  google::cloud::vmwareengine::v1::Credentials response;
  auto status = grpc_stub_->ShowNsxCredentials(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
DefaultVmwareEngineStub::ShowVcenterCredentials(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
        request) {
  google::cloud::vmwareengine::v1::Credentials response;
  auto status =
      grpc_stub_->ShowVcenterCredentials(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncResetNsxCredentials(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncResetNsxCredentials(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncResetVcenterCredentials(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncResetVcenterCredentials(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncCreateHcxActivationKey(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateHcxActivationKey(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::vmwareengine::v1::ListHcxActivationKeysResponse>
DefaultVmwareEngineStub::ListHcxActivationKeys(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest const&
        request) {
  google::cloud::vmwareengine::v1::ListHcxActivationKeysResponse response;
  auto status = grpc_stub_->ListHcxActivationKeys(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
DefaultVmwareEngineStub::GetHcxActivationKey(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
        request) {
  google::cloud::vmwareengine::v1::HcxActivationKey response;
  auto status = grpc_stub_->GetHcxActivationKey(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
DefaultVmwareEngineStub::GetNetworkPolicy(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request) {
  google::cloud::vmwareengine::v1::NetworkPolicy response;
  auto status = grpc_stub_->GetNetworkPolicy(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::ListNetworkPoliciesResponse>
DefaultVmwareEngineStub::ListNetworkPolicies(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest const&
        request) {
  google::cloud::vmwareengine::v1::ListNetworkPoliciesResponse response;
  auto status = grpc_stub_->ListNetworkPolicies(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncCreateNetworkPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateNetworkPolicy(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncUpdateNetworkPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateNetworkPolicy(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncDeleteNetworkPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteNetworkPolicy(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncCreateVmwareEngineNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::
                 CreateVmwareEngineNetworkRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateVmwareEngineNetwork(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncUpdateVmwareEngineNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::
                 UpdateVmwareEngineNetworkRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateVmwareEngineNetwork(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncDeleteVmwareEngineNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::vmwareengine::v1::
                 DeleteVmwareEngineNetworkRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteVmwareEngineNetwork(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
DefaultVmwareEngineStub::GetVmwareEngineNetwork(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
        request) {
  google::cloud::vmwareengine::v1::VmwareEngineNetwork response;
  auto status =
      grpc_stub_->GetVmwareEngineNetwork(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::ListVmwareEngineNetworksResponse>
DefaultVmwareEngineStub::ListVmwareEngineNetworks(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest const&
        request) {
  google::cloud::vmwareengine::v1::ListVmwareEngineNetworksResponse response;
  auto status =
      grpc_stub_->ListVmwareEngineNetworks(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncCreatePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreatePrivateConnection(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
DefaultVmwareEngineStub::GetPrivateConnection(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
        request) {
  google::cloud::vmwareengine::v1::PrivateConnection response;
  auto status = grpc_stub_->GetPrivateConnection(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::vmwareengine::v1::ListPrivateConnectionsResponse>
DefaultVmwareEngineStub::ListPrivateConnections(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest const&
        request) {
  google::cloud::vmwareengine::v1::ListPrivateConnectionsResponse response;
  auto status =
      grpc_stub_->ListPrivateConnections(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncUpdatePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdatePrivateConnection(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncDeletePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeletePrivateConnection(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<
    google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesResponse>
DefaultVmwareEngineStub::ListPrivateConnectionPeeringRoutes(
    grpc::ClientContext& context,
    google::cloud::vmwareengine::v1::
        ListPrivateConnectionPeeringRoutesRequest const& request) {
  google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesResponse
      response;
  auto status = grpc_stub_->ListPrivateConnectionPeeringRoutes(
      &context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultVmwareEngineStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultVmwareEngineStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1_internal
}  // namespace cloud
}  // namespace google
