/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import snmp.SNMPBadValueException;
import snmp.SNMPGetException;
import snmp.SNMPObject;
import snmp.SNMPSequence;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

class Poller {
    static final int SNMP_TIMEOUT = 10;
    static final String[][] OIDS = new String[][]{{"sysDescr", "1.3.6.1.2.1.1.1.0"}, {"sysName", "1.3.6.1.2.1.1.5.0"}, {"ifDescr", "1.3.6.1.2.1.2.2.1.2"}, {"ifType", "1.3.6.1.2.1.2.2.1.3"}, {"ifSpeed", "1.3.6.1.2.1.2.2.1.5"}, {"sysUpTime", "1.3.6.1.2.1.1.3.0"}, {"ifOperStatus", "1.3.6.1.2.1.2.2.1.8"}, {"ifInOctets", "1.3.6.1.2.1.2.2.1.10"}, {"ifOutOctets", "1.3.6.1.2.1.2.2.1.16"}, {"ifInErrors", "1.3.6.1.2.1.2.2.1.14"}, {"ifOutErrors", "1.3.6.1.2.1.2.2.1.20"}, {"ifInDiscards", "1.3.6.1.2.1.2.2.1.13"}, {"ifOutDiscards", "1.3.6.1.2.1.2.2.1.19"}, {"ifAlias", "1.3.6.1.2.1.31.1.1.1.18"}};
    private SNMPv1CommunicationInterface comm;

    Poller(String string, String string2) throws IOException {
        Object object;
        String string3 = string;
        int n = 161;
        int n2 = string.indexOf(":");
        if (n2 != -1) {
            string3 = string.substring(0, n2);
            object = string.substring(n2 + 1);
            n = Integer.parseInt((String)object);
        }
        object = InetAddress.getByName(string3);
        this.comm = new SNMPv1CommunicationInterface(0, (InetAddress)object, string2, n);
        this.comm.setSocketTimeout(10000);
    }

    String getNumericOid(String string) {
        int n = OIDS.length;
        for (int i = 0; i < n; ++i) {
            String string2 = OIDS[i][0];
            String string3 = OIDS[i][1];
            if (!string.startsWith(string2)) continue;
            return string.replaceFirst(string2, string3);
        }
        return string;
    }

    String get(String string) throws IOException {
        String string2 = this.getNumericOid(string);
        try {
            SNMPVarBindList sNMPVarBindList = this.comm.getMIBEntry(string2);
            SNMPSequence sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence.getSNMPObjectAt(1);
            return sNMPObject.toString().trim();
        }
        catch (SNMPBadValueException sNMPBadValueException) {
            return null;
        }
        catch (SNMPGetException sNMPGetException) {
            return null;
        }
    }

    String get(String string, int n) throws IOException {
        return this.get(string + "." + n);
    }

    String[] get(String[] stringArray) throws IOException {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = this.get(stringArray[i]);
        }
        return stringArray2;
    }

    SortedMap walk(String string) throws IOException {
        String string2;
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        String string3 = string2 = this.getNumericOid(string);
        try {
            while (true) {
                SNMPVarBindList sNMPVarBindList = this.comm.getNextMIBEntry(string3);
                SNMPSequence sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                string3 = sNMPSequence.getSNMPObjectAt(0).toString();
                String string4 = sNMPSequence.getSNMPObjectAt(1).toString().trim();
                if (string3.startsWith(string2)) {
                    int n = string3.lastIndexOf(".");
                    String string5 = string3.substring(n + 1);
                    int n2 = Integer.parseInt(string5);
                    treeMap.put(new Integer(n2), string4);
                    continue;
                }
                break;
            }
        }
        catch (SNMPBadValueException sNMPBadValueException) {
        }
        catch (SNMPGetException sNMPGetException) {
            // empty catch block
        }
        return treeMap;
    }

    SortedMap walkIfDescr() throws IOException {
        SortedMap sortedMap = this.walk("ifDescr");
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        Collection collection = treeMap.values();
        Iterator iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            String string = (String)sortedMap.get(n);
            if (collection.contains(string)) {
                int n2 = 1;
                while (collection.contains(string + "#" + n2)) {
                    ++n2;
                }
                string = string + "#" + n2;
            }
            treeMap.put(n, string);
        }
        return treeMap;
    }

    int getIfIndexByIfDescr(String string) throws IOException {
        SortedMap sortedMap = this.walkIfDescr();
        Iterator iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            String string2 = (String)sortedMap.get(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            return n;
        }
        return -1;
    }

    void close() {
        if (this.comm != null) {
            try {
                this.comm.closeConnection();
                this.comm = null;
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        this.close();
    }
}

