/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.util.Comparator;
import org.jrobin.mrtg.client.LinkInfo;
import org.jrobin.mrtg.client.TreeElementInfo;

class RouterInfo
implements TreeElementInfo {
    private String host;
    private String descr;
    private String community;
    private boolean active;
    private LinkInfo[] linksInfo;

    RouterInfo() {
    }

    LinkInfo[] getLinkInfo() {
        return this.linksInfo;
    }

    void setLinkInfo(LinkInfo[] linkInfoArray) {
        this.linksInfo = linkInfoArray;
    }

    String getHost() {
        return this.host;
    }

    void setHost(String string) {
        this.host = string;
    }

    String getDescr() {
        return this.descr;
    }

    void setDescr(String string) {
        this.descr = string;
    }

    String getCommunity() {
        return this.community;
    }

    void setCommunity(String string) {
        this.community = string;
    }

    boolean isActive() {
        return this.active;
    }

    void setActive(boolean bl) {
        this.active = bl;
    }

    public String toString() {
        return this.host;
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Router address: " + this.getHost() + "\n");
        stringBuffer.append("Community: " + this.getCommunity() + "\n");
        stringBuffer.append("Description: " + this.getDescr() + "\n");
        stringBuffer.append("Active: " + this.isActive() + "\n");
        stringBuffer.append("Sampled links: " + this.getLinkInfo().length + "\n");
        return stringBuffer.toString();
    }

    static Comparator getComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                RouterInfo routerInfo = (RouterInfo)object;
                RouterInfo routerInfo2 = (RouterInfo)object2;
                return routerInfo.getHost().compareToIgnoreCase(routerInfo2.getHost());
            }
        };
    }

    public boolean equals(Object object) {
        if (object instanceof RouterInfo) {
            Comparator comparator = RouterInfo.getComparator();
            return comparator.compare(this, object) == 0;
        }
        return false;
    }

    String[] getInterfaces() {
        String[] stringArray = new String[this.linksInfo.length];
        for (int i = 0; i < this.linksInfo.length; ++i) {
            stringArray[i] = this.linksInfo[i].getIfDescr();
        }
        return stringArray;
    }
}

