/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Hashtable;
import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.DefaultFunctions;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.Token;

public abstract class Function
extends ParseTree
implements DefaultFunctions {
    protected Function simpleVersion = null;
    protected Hashtable evaluationCache = new Hashtable();

    protected Function(ParseTree pt) {
        super(pt);
    }

    public double evaluate() {
        return this.evaluate(null, null);
    }

    public double evaluate(ValueTable vt) {
        return this.evaluate(null, vt);
    }

    public abstract double evaluate(SymbolTable var1, ValueTable var2);

    public Function derivative(Token var) {
        Vector<Token> V = new Vector<Token>();
        V.add(var);
        return this.derivative(V);
    }

    public abstract Function derivative(Vector var1);

    public boolean isConstant() {
        return false;
    }

    public boolean isInequality() {
        return false;
    }

    public boolean isZero() {
        return this.evaluate() == 0.0;
    }

    public boolean isOne() {
        return this.evaluate() == 1.0;
    }

    public Function simplify() {
        if (this.simpleVersion != null) {
            return this.simpleVersion;
        }
        if (this.isConstant()) {
            this.simpleVersion = FunctionFactory.getFunction(this.evaluate());
            return this.simpleVersion;
        }
        this.simpleVersion = this;
        return this.simpleVersion;
    }

    public boolean isPolynomial() {
        if (this.isConstant()) {
            return true;
        }
        Token root = this.getRoot();
        if (root.isVariable()) {
            return true;
        }
        if (!root.isBinary()) {
            return false;
        }
        Function f0 = FunctionFactory.getFunction(this.getArg(0));
        Function f1 = FunctionFactory.getFunction(this.getArg(1));
        if (root.isCaret() && f0.isPolynomial() && f1.isInteger() && f1.isPositive()) {
            return true;
        }
        if ((root.isPlusSign() || root.isMinusSign() || root.isMultiply()) && f0.isPolynomial() && f1.isPolynomial()) {
            return true;
        }
        return (root.isPlusSign() || root.isMinusSign() || root.isMultiply()) && f0.isPolynomial() && f1.isPolynomial();
    }

    public boolean isInteger() {
        if (!this.isConstant()) {
            return false;
        }
        double value = this.evaluate();
        return value == (double)((int)value);
    }

    public boolean isPositive() {
        if (!this.isConstant()) {
            return false;
        }
        double value = this.evaluate();
        return value > 0.0;
    }
}

