/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class BufferedCanvas
extends JPanel {
    private int maxImgWidth = 0;
    private int maxImgHeight = 0;
    protected BufferedImage image = null;
    protected Graphics2D gr;
    private boolean antialiased;

    protected BufferedCanvas() {
        this(false);
    }

    protected BufferedCanvas(boolean antialiased) {
        this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.antialiased = antialiased;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.update(g);
    }

    public void update(Graphics g) {
        if (this.image == null) {
            this.initImage();
            this.clear();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    public void clear() {
        if (this.gr == null) {
            return;
        }
        this.gr.setColor(this.getBackground());
        this.gr.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.repaint();
    }

    public void initImage() {
        this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.gr = this.image.createGraphics();
        if (this.antialiased) {
            this.gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public void resetSize(Dimension d) {
        int x = d.width;
        int y = d.height;
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setSize(d);
        if (x > this.maxImgWidth || y > this.maxImgHeight) {
            BufferedImage oldimg = this.image;
            this.initImage();
            if (oldimg != null) {
                this.gr.drawImage(oldimg.getScaledInstance(x, y, 1), 0, 0, this);
            }
        }
    }
}

