/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import net.gcalc.calc.gui.ShutdownDialog;
import net.gcalc.calc.gui.ShutdownWindowAdapter;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.AbstractPlugin;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.ColoredModel;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.gui.SimpleColorChooser;
import net.gcalc.plugin.gui.TextInputPanel;

public class ModelEditingDialog
extends ShutdownDialog {
    private TextInputPanel ip;
    private RenderableModel originalModel;
    private RenderableModel newModel;
    private SimpleColorChooser colorChooser;
    private JButton apply;
    private JButton revert;
    private JButton cancel;
    private Action applyAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            String[] s = ModelEditingDialog.this.ip.getValues();
            Function[] F = new Function[s.length];
            try {
                int i = 0;
                while (i < s.length) {
                    F[i] = FunctionFactory.getFunction(s[i]);
                    ++i;
                }
                ModelEditingDialog.this.newModel = new ColoredModel(F, s, ModelEditingDialog.this.colorChooser.getColor());
                ModelEditingDialog.this.setVisible(false);
            }
            catch (BadSyntaxException exception) {
                SwingGUI.popupMessage("Bad Syntax in '" + s + "'!\n" + exception.getMessage(), (AbstractPlugin)ModelEditingDialog.this.getOwner(), 0);
            }
        }
    };
    private Action revertAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            ModelEditingDialog.this.ip.setValues(new String[]{ModelEditingDialog.this.originalModel.toString()});
            ModelEditingDialog.this.colorChooser.setColor(ModelEditingDialog.this.originalModel.getColor());
        }
    };
    private Action cancelAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            ModelEditingDialog.this.setVisible(false);
        }
    };

    public ModelEditingDialog(AbstractCartesianGraphPlugin plugin, RenderableModel model) {
        this(plugin, model, plugin.getModelLabels());
    }

    private ModelEditingDialog(AbstractPlugin plugin, RenderableModel model, String[] labels) {
        super(plugin, "Edit " + model, true);
        this.originalModel = model;
        this.addWindowListener(new ShutdownWindowAdapter(this));
        int n = model.getNumberOfFunctions();
        String[] text = new String[n];
        int i = 0;
        while (i < n) {
            text[i] = model.getFunction(i).toInfix();
            ++i;
        }
        this.ip = new TextInputPanel("Edit Expression", null, labels, text);
        this.colorChooser = new SimpleColorChooser(model.getColor(), 100, 50);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        this.apply = new JButton("OK");
        buttonBox.add(this.apply);
        this.revert = new JButton("Revert");
        buttonBox.add(this.revert);
        this.cancel = new JButton("Cancel");
        buttonBox.add(this.cancel);
        this.apply.addActionListener(this.applyAction);
        this.revert.addActionListener(this.revertAction);
        this.cancel.addActionListener(this.cancelAction);
        this.getContentPane().add((Component)this.ip, "North");
        this.getContentPane().add(SwingGUI.wrapTitledBorder(this.colorChooser, "Color"), "Center");
        this.getContentPane().add((Component)buttonBox, "South");
        this.pack();
        this.setResizable(false);
        this.center();
    }

    public void shutdown() {
        this.setVisible(false);
    }

    public RenderableModel getNewModel() {
        return this.newModel;
    }
}

