/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.mandelbrot;

class Mandelbrot {
    private int maxiter = 100;

    public Mandelbrot(int maxiter) {
        this.maxiter = maxiter;
    }

    public int escape(double a, double b) {
        double p = (a - 0.25) * (a - 0.25) + b * b;
        double t = 0.5 * (1.0 - Math.cos(Math.atan2(b, a - 0.25)));
        if (p < t * t) {
            return this.maxiter;
        }
        int i = 0;
        double x = 0.0;
        double y = 0.0;
        i = 0;
        while (i < this.maxiter) {
            if (x * x + y * y > 4.0) {
                return i;
            }
            double nx = x * x - y * y + a;
            double ny = 2.0 * x * y + b;
            x = nx;
            y = ny;
            ++i;
        }
        return i;
    }

    public int maxIteration() {
        return this.maxiter;
    }
}

