/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.inject.Inject;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.output.TestResultListener;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTestResultListener
implements TestResultListener {
    private final Set<TestResultListener> delegates;

    @Inject
    public MultiTestResultListener(Set<TestResultListener> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void onTestComplete(TestResult testResult) {
        for (TestResultListener delegate : this.delegates) {
            delegate.onTestComplete(testResult);
        }
    }

    @Override
    public void finish() {
        for (TestResultListener delegate : this.delegates) {
            delegate.finish();
        }
    }

    @Override
    public void onFileLoad(String browser, FileResult fileResult) {
        for (TestResultListener delegate : this.delegates) {
            delegate.onFileLoad(browser, fileResult);
        }
    }
}

