/* rikenCluster.h was originally generated by the autoSql program, which also 
 * generated rikenCluster.c and rikenCluster.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef RIKENCLUSTER_H
#define RIKENCLUSTER_H

struct rikenUcscCluster
/* A cluster of Riken (and other) mRNAs */
    {
    struct rikenUcscCluster *next;  /* Next in singly linked list. */
    char *chrom;	/* Chomosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Always 1000 */
    char strand[2];	/* + or - */
    unsigned refSeqCount;	/* Number of refSeq mrnas in cluster */
    char **refSeqs;	/* List of refSeq accessions */
    unsigned genBankCount;	/* Number of Genbank mrnas in cluster */
    char **genBanks;	/* List of Genbank accessions */
    unsigned rikenCount;	/* Number of Riken mrnas in cluster */
    char **rikens;	/* List of Riken IDs */
    };

struct rikenUcscCluster *rikenUcscClusterLoad(char **row);
/* Load a rikenUcscCluster from row fetched with select * from rikenUcscCluster
 * from database.  Dispose of this with rikenUcscClusterFree(). */

struct rikenUcscCluster *rikenUcscClusterLoadAll(char *fileName);
/* Load all rikenUcscCluster from a tab-separated file.
 * Dispose of this with rikenUcscClusterFreeList(). */

struct rikenUcscCluster *rikenUcscClusterLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all rikenUcscCluster from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with rikenUcscClusterFreeList(). */

struct rikenUcscCluster *rikenUcscClusterCommaIn(char **pS, struct rikenUcscCluster *ret);
/* Create a rikenUcscCluster out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rikenUcscCluster */

void rikenUcscClusterFree(struct rikenUcscCluster **pEl);
/* Free a single dynamically allocated rikenUcscCluster such as created
 * with rikenUcscClusterLoad(). */

void rikenUcscClusterFreeList(struct rikenUcscCluster **pList);
/* Free a list of dynamically allocated rikenUcscCluster's */

void rikenUcscClusterOutput(struct rikenUcscCluster *el, FILE *f, char sep, char lastSep);
/* Print out rikenUcscCluster.  Separate fields with sep. Follow last field with lastSep. */

#define rikenUcscClusterTabOut(el,f) rikenUcscClusterOutput(el,f,'\t','\n');
/* Print out rikenUcscCluster as a line in a tab-separated file. */

#define rikenUcscClusterCommaOut(el,f) rikenUcscClusterOutput(el,f,',',',');
/* Print out rikenUcscCluster as a comma separated list including final comma. */

#endif /* RIKENCLUSTER_H */

