# ld.sql was originally generated by the autoSql program, which also 
# generated ld.c and ld.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Linkage Disequilibrium values from SNP genotypes
CREATE TABLE ld (
    bin        smallint(5) unsigned   NOT NULL,
    chrom      enum( 'unknown', 
                   'chr1',  'chr2',  'chr3',  'chr4',  'chr5',  'chr6',  'chr7', 
                   'chr8',  'chr9',  'chr10', 'chr11', 'chr12', 'chr13', 'chr14', 
                   'chr15', 'chr16', 'chr17', 'chr18', 'chr19', 'chr20', 'chr21', 
                   'chr22', 'chr6_hla_hap1',  'chr6_hla_hap2',  'chrM',  'chrX', 
                   'chrY'
                  ) DEFAULT 'unknown' NOT NULL,	# Chromosome
    chromStart int(10) unsigned       NOT NULL,	# chromStart for reference marker
    chromEnd   int(10) unsigned       NOT NULL,	# chromEnd for last marker in list
    name       varchar(255)           NOT NULL,	# rsId at chromStart
    score      int unsigned           NOT NULL,	# Number of markers with LD values
    dprime     blob                   NOT NULL,	# Encoded lists of D' values
    rsquared   blob                   NOT NULL,	# Encoded lists of r^2 values
    lod        blob                   NOT NULL,	# Encoded lists of LOD values
              #Indices
    INDEX      chrom      (chrom,bin),
    INDEX      chromStart (chrom,chromStart)
);
