// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64 -target-feature +xandesperf -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s

#include <stdint.h>
#include <riscv_nds.h>

// CHECK-LABEL: @test_ffb(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.ffb.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-NEXT:    ret i64 [[TMP0]]
//
int64_t test_ffb(uint64_t a, uint64_t b) {
  return __riscv_nds_ffb_64(a, b);
}

// CHECK-LABEL: @test_ffzmism(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.ffzmism.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-NEXT:    ret i64 [[TMP0]]
//
int64_t test_ffzmism(uint64_t a, uint64_t b) {
  return __riscv_nds_ffzmism_64(a, b);
}

// CHECK-LABEL: @test_ffmism(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.ffmism.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-NEXT:    ret i64 [[TMP0]]
//
int64_t test_ffmism(uint64_t a, uint64_t b) {
  return __riscv_nds_ffmism_64(a, b);
}

// CHECK-LABEL: @test_flmism(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.flmism.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-NEXT:    ret i64 [[TMP0]]
//
int64_t test_flmism(uint64_t a, uint64_t b) {
  return __riscv_nds_flmism_64(a, b);
}
