(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive option
  (a:Type) {a_WT:WhyType a} :=
  | None : option a
  | Some : a -> option a.
Axiom option_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (option a).
Existing Instance option_WhyType.
Implicit Arguments None [[a] [a_WT]].
Implicit Arguments Some [[a] [a_WT]].

Axiom t : Type.
Parameter t_WhyType : WhyType t.
Existing Instance t_WhyType.

Axiom structure : Type.
Parameter structure_WhyType : WhyType structure.
Existing Instance structure_WhyType.

Parameter infix_breq: structure -> t -> Prop.

Parameter ffalse: t.

Parameter ttrue: t.

Parameter prefix_tl: t -> t.

Parameter infix_et: t -> t -> t.

Parameter infix_plpl: t -> t -> t.

Parameter infix_eqgt: t -> t -> t.

Parameter infix_breqeq: t -> t -> Prop.

Axiom true_false : ~ (ttrue = ffalse).

(* Why3 assumption *)
Definition sat (f:t): Prop := exists m:structure, (infix_breq m f).

(* Why3 assumption *)
Definition valid (f:t): Prop := ~ (sat (prefix_tl f)).

Axiom imply_def : forall (f1:t) (f2:t), ((infix_eqgt f1
  f2) = (infix_plpl (prefix_tl f1) f2)).

Axiom imply_models : forall (f1:t) (f2:t), (valid (infix_eqgt f1 f2)) <->
  (infix_breqeq f1 f2).

Axiom negneg : forall (f:t), ((prefix_tl (prefix_tl f)) = f).

Axiom and_a : forall (f1:t) (f2:t) (f3:t), ((infix_et (infix_et f1 f2)
  f3) = (infix_et f1 (infix_et f2 f3))).

Axiom and_c : forall (f1:t) (f2:t), ((infix_et f1 f2) = (infix_et f2 f1)).

Axiom or_a : forall (f1:t) (f2:t) (f3:t), ((infix_plpl (infix_plpl f1 f2)
  f3) = (infix_plpl f1 (infix_plpl f2 f3))).

Axiom or_c : forall (f1:t) (f2:t), ((infix_plpl f1 f2) = (infix_plpl f2 f1)).

Axiom distr_and : forall (f1:t) (f2:t) (f3:t), ((infix_et f1 (infix_plpl f2
  f3)) = (infix_plpl (infix_et f1 f2) (infix_et f1 f3))).

Axiom distr_or : forall (f1:t) (f2:t) (f3:t), ((infix_plpl f1 (infix_et f2
  f3)) = (infix_et (infix_plpl f1 f2) (infix_plpl f1 f3))).

Axiom neutral_and : forall (f:t), ((infix_et f ttrue) = f).

Axiom neutral_or : forall (f:t), ((infix_plpl f ffalse) = f).

Axiom absorb_and : forall (f:t), ((infix_et f ffalse) = ffalse).

Axiom absorb_or : forall (f:t), ((infix_plpl f ttrue) = ttrue).

Axiom ttrue_valid : (valid ttrue).

Axiom ffaslse_invalid : ~ (valid ffalse).

Axiom ttrue_sat : (sat ttrue).

Axiom ffalse_unsat : ~ (sat ffalse).

Axiom sat_or : forall (f1:t) (f2:t), (sat (infix_plpl f1 f2)) <-> ((sat
  f1) \/ (sat f2)).

Axiom forget_subsumed : forall (f:t) (v:t), (infix_breqeq f v) ->
  ((infix_plpl f v) = v).

Axiom forget_subsumed_imply : forall (f:t) (v:t), (valid (infix_eqgt f v)) ->
  ((infix_plpl f v) = v).

Axiom classic_neg : forall (f:t), ((infix_plpl (prefix_tl f) f) = ttrue).

Axiom imply_transitive : forall (f1:t) (f2:t) (f3:t), ((infix_breqeq f1
  f2) /\ (infix_breqeq f2 f3)) -> (infix_breqeq f1 f3).

Axiom imply_bigger : forall (f1:t) (f2:t), (infix_breqeq f1 (infix_plpl f1
  f2)).

Axiom imply_or : forall (f1:t) (f2:t) (f3:t), (infix_breqeq f1 f2) ->
  (infix_breqeq (infix_plpl f1 f3) (infix_plpl f2 f3)).

Axiom or_same : forall (f:t), ((infix_plpl f f) = f).

Axiom set : forall (a:Type) {a_WT:WhyType a}, Type.
Parameter set_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (set a).
Existing Instance set_WhyType.

Parameter mem: forall {a:Type} {a_WT:WhyType a}, a -> (set a) -> Prop.

(* Why3 assumption *)
Definition infix_eqeq {a:Type} {a_WT:WhyType a} (s1:(set a)) (s2:(set
  a)): Prop := forall (x:a), (mem x s1) <-> (mem x s2).

Axiom extensionality : forall {a:Type} {a_WT:WhyType a}, forall (s1:(set a))
  (s2:(set a)), (infix_eqeq s1 s2) -> (s1 = s2).

(* Why3 assumption *)
Definition subset {a:Type} {a_WT:WhyType a} (s1:(set a)) (s2:(set
  a)): Prop := forall (x:a), (mem x s1) -> (mem x s2).

Axiom subset_refl : forall {a:Type} {a_WT:WhyType a}, forall (s:(set a)),
  (subset s s).

Axiom subset_trans : forall {a:Type} {a_WT:WhyType a}, forall (s1:(set a))
  (s2:(set a)) (s3:(set a)), (subset s1 s2) -> ((subset s2 s3) -> (subset s1
  s3)).

Parameter empty: forall {a:Type} {a_WT:WhyType a}, (set a).

(* Why3 assumption *)
Definition is_empty {a:Type} {a_WT:WhyType a} (s:(set a)): Prop :=
  forall (x:a), ~ (mem x s).

Axiom empty_def1 : forall {a:Type} {a_WT:WhyType a}, (is_empty (empty :(set
  a))).

Axiom mem_empty : forall {a:Type} {a_WT:WhyType a}, forall (x:a), ~ (mem x
  (empty :(set a))).

Parameter add: forall {a:Type} {a_WT:WhyType a}, a -> (set a) -> (set a).

Axiom add_def1 : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (y:a),
  forall (s:(set a)), (mem x (add y s)) <-> ((x = y) \/ (mem x s)).

Parameter remove: forall {a:Type} {a_WT:WhyType a}, a -> (set a) -> (set a).

Axiom remove_def1 : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (y:a)
  (s:(set a)), (mem x (remove y s)) <-> ((~ (x = y)) /\ (mem x s)).

Axiom subset_remove : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (s:(set
  a)), (subset (remove x s) s).

Parameter union: forall {a:Type} {a_WT:WhyType a}, (set a) -> (set a) -> (set
  a).

Axiom union_def1 : forall {a:Type} {a_WT:WhyType a}, forall (s1:(set a))
  (s2:(set a)) (x:a), (mem x (union s1 s2)) <-> ((mem x s1) \/ (mem x s2)).

Parameter inter: forall {a:Type} {a_WT:WhyType a}, (set a) -> (set a) -> (set
  a).

Axiom inter_def1 : forall {a:Type} {a_WT:WhyType a}, forall (s1:(set a))
  (s2:(set a)) (x:a), (mem x (inter s1 s2)) <-> ((mem x s1) /\ (mem x s2)).

Parameter diff: forall {a:Type} {a_WT:WhyType a}, (set a) -> (set a) -> (set
  a).

Axiom diff_def1 : forall {a:Type} {a_WT:WhyType a}, forall (s1:(set a))
  (s2:(set a)) (x:a), (mem x (diff s1 s2)) <-> ((mem x s1) /\ ~ (mem x s2)).

Axiom subset_diff : forall {a:Type} {a_WT:WhyType a}, forall (s1:(set a))
  (s2:(set a)), (subset (diff s1 s2) s1).

Parameter choose: forall {a:Type} {a_WT:WhyType a}, (set a) -> a.

Axiom choose_def : forall {a:Type} {a_WT:WhyType a}, forall (s:(set a)),
  (~ (is_empty s)) -> (mem (choose s) s).

Parameter cardinal: forall {a:Type} {a_WT:WhyType a}, (set a) -> Z.

Axiom cardinal_nonneg : forall {a:Type} {a_WT:WhyType a}, forall (s:(set a)),
  (0%Z <= (cardinal s))%Z.

Axiom cardinal_empty : forall {a:Type} {a_WT:WhyType a}, forall (s:(set a)),
  ((cardinal s) = 0%Z) <-> (is_empty s).

Axiom cardinal_add : forall {a:Type} {a_WT:WhyType a}, forall (x:a),
  forall (s:(set a)), (~ (mem x s)) -> ((cardinal (add x
  s)) = (1%Z + (cardinal s))%Z).

Axiom cardinal_remove : forall {a:Type} {a_WT:WhyType a}, forall (x:a),
  forall (s:(set a)), (mem x s) -> ((cardinal s) = (1%Z + (cardinal (remove x
  s)))%Z).

Axiom cardinal_subset : forall {a:Type} {a_WT:WhyType a}, forall (s1:(set a))
  (s2:(set a)), (subset s1 s2) -> ((cardinal s1) <= (cardinal s2))%Z.

Axiom cardinal1 : forall {a:Type} {a_WT:WhyType a}, forall (s:(set a)),
  ((cardinal s) = 1%Z) -> forall (x:a), (mem x s) -> (x = (choose s)).

Parameter pre: t -> t.

Axiom pre_false : ((pre ffalse) = ffalse).

Parameter pre_star: t -> t.

Axiom pre_star_def1 : forall (f:t), (valid (infix_eqgt f (pre_star f))).

Axiom pre_star_def4 : forall (f:t), ((infix_plpl (pre_star (pre f))
  f) = (pre_star f)).

Axiom pre_star_false : ((pre_star ffalse) = ffalse).

Axiom pre_star_and : forall (f1:t) (f2:t), ((pre_star (infix_et f1
  f2)) = (infix_et (pre_star f1) (pre_star f2))).

Axiom pre_star_or : forall (f1:t) (f2:t), ((pre_star (infix_plpl f1
  f2)) = (infix_plpl (pre_star f1) (pre_star f2))).

(* Why3 assumption *)
Definition reachable (init:t) (f:t): Prop := (sat (infix_et (pre_star f)
  init)).

Axiom directly_reachable : forall (init:t) (f:t), (sat (infix_et init f)) ->
  (reachable init f).

Axiom false_unreachable : forall (init:t), ~ (reachable init ffalse).

Axiom reachable_or : forall (f1:t) (f2:t) (init:t), (reachable init
  (infix_plpl f1 f2)) <-> ((reachable init f1) \/ (reachable init f2)).

Axiom reachable_bigger : forall (f1:t) (f2:t) (init:t), (infix_breqeq f1
  f2) -> ((reachable init f1) -> (reachable init f2)).

Axiom pre_star_bigger : forall (f1:t) (f2:t), (infix_breqeq f1 f2) ->
  (infix_breqeq (pre_star f1) (pre_star f2)).

(* Why3 assumption *)
Definition f := t.

(* Why3 assumption *)
Inductive t1 :=
  | mk_t : t -> (set t) -> t1.
Axiom t1_WhyType : WhyType t1.
Existing Instance t1_WhyType.

(* Why3 assumption *)
Definition elts (v:t1): (set t) := match v with
  | (mk_t x x1) => x1
  end.

(* Why3 assumption *)
Definition formula (v:t1): t := match v with
  | (mk_t x x1) => x
  end.

(* Why3 assumption *)
Inductive result :=
  | Safe : result
  | Unsafe : result.
Axiom result_WhyType : WhyType result.
Existing Instance result_WhyType.

(* Why3 goal *)
Theorem WP_parameter_bwd : forall (init:t) (theta:t), forall (visited:t),
  (visited = ffalse) -> forall (rho:(set t)) (rho1:t), ((rho1 = ffalse) /\
  (rho = (empty :(set t)))) -> ((~ (sat (infix_et init theta))) ->
  forall (visited1:t), (visited1 = (infix_plpl theta visited)) ->
  forall (rho2:(set t)) (rho3:t), ((rho3 = (infix_plpl (pre theta) rho1)) /\
  (rho2 = (add (pre theta) rho))) -> forall (rho4:(set t)) (rho5:t)
  (visited2:t), ((~ (sat (infix_et init visited2))) /\ (infix_breqeq
  (pre_star theta) (infix_plpl visited2 (pre_star rho5)))) ->
  forall (o:bool), ((o = true) <-> ((is_empty rho4) /\ (rho5 = ffalse))) ->
  ((~ (o = true)) -> forall (old_q:t) (old_q1:(set t)), ((old_q = rho5) /\
  (old_q1 = rho4)) -> forall (rho6:(set t)) (rho7:t), let phi :=
  (choose rho4) in (((~ (is_empty rho4)) /\ ((rho6 = (remove phi rho4)) /\
  ((valid (infix_eqgt phi rho5)) /\ (rho7 = (infix_et (prefix_tl phi)
  rho5))))) -> ((~ (sat (infix_et init phi))) -> ((infix_breqeq phi
  visited2) -> (((valid (infix_eqgt (prefix_tl phi)
  (pre_star (prefix_tl phi)))) /\ (((infix_plpl visited2
  (infix_plpl (prefix_tl phi)
  (pre_star (prefix_tl phi)))) = (infix_plpl (infix_plpl phi visited2)
  (infix_plpl (prefix_tl phi) (pre_star (prefix_tl phi))))) /\
  (((infix_et (infix_plpl visited2 (infix_plpl (prefix_tl phi)
  (pre_star (prefix_tl phi)))) (infix_plpl visited2
  (pre_star old_q))) = (infix_et (infix_plpl visited2
  (infix_plpl (infix_plpl phi (prefix_tl phi)) (pre_star (prefix_tl phi))))
  (infix_plpl visited2 (pre_star old_q)))) /\
  (((infix_et (infix_plpl visited2 (infix_plpl (prefix_tl phi)
  (pre_star (prefix_tl phi)))) (infix_plpl visited2
  (pre_star old_q))) = (infix_et (infix_plpl visited2 (infix_plpl ttrue
  (pre_star (prefix_tl phi)))) (infix_plpl visited2 (pre_star old_q)))) /\
  ((infix_et (infix_plpl visited2 (infix_plpl (prefix_tl phi)
  (pre_star (prefix_tl phi)))) (infix_plpl visited2
  (pre_star old_q))) = (infix_et (infix_plpl visited2 ttrue)
  (infix_plpl visited2 (pre_star old_q)))))))) -> ((~ (sat (infix_et init
  visited2))) -> (infix_breqeq (pre_star theta) (infix_plpl visited2
  (pre_star rho7)))))))))).
(* Why3 intros init theta visited h1 rho rho1 (h2,h3) h4 visited1 h5 rho2
        rho3 (h6,h7) rho4 rho5 visited2 (h8,h9) o h10 h11 old_q old_q1
        (h12,h13) rho6 rho7 phi (h14,(h15,(h16,h17))) h18 h19
        (h20,(h21,(h22,(h23,h24)))) h25. *)
intros init theta visited h1 rho rho1 (h2,h3) h4 visited1 h5 rho2 rho3
(h6,h7) rho4 rho5 visited2 (h8,h9) o h10 h11 old_q old_q1 (h12,h13) rho6 rho7
phi (h14,(h15,(h16,h17))) h18 h19 assertions_else h20.


Notation "A & B" := (infix_et A B) (at level 80).
Notation "A | B" := (infix_plpl A B) (at level 85).
Notation "-- A" := (prefix_tl A) (at level 75).
Notation "A => B" := (infix_eqgt A B) (at level 70).
Notation "A |= B" := (infix_breq A B) (at level 65).
Notation "A |== B" := (infix_breqeq A B) (at level 64).


rewrite h17.
rewrite pre_star_and.
rewrite distr_or.
(* rewrite <- h9. *)

assert (valid ((-- phi) => pre_star (-- phi))).
apply pre_star_def1.
apply forget_subsumed_imply in H.
rewrite <- H.

apply forget_subsumed in h19.
assert (((visited2 | ((-- phi) | (pre_star (-- phi)))) =
        (((phi | visited2) | ((-- phi) | (pre_star (-- phi))))))).
rewrite h19. reflexivity.
rewrite H0.
rewrite or_c with (f1 := phi).
rewrite or_a.
rewrite <- or_a with (f1 := phi).
rewrite or_c with (f1 := phi). rewrite classic_neg.
rewrite or_c with (f1 := ttrue).
rewrite absorb_or.
rewrite absorb_or.
rewrite and_c.
rewrite neutral_and.
auto.

Qed.


