/* main.C
 * John Viega
 *
 * Jan 28-29 2000
 */

#include "resultsdb.H"
#include "scanner.H"
#include "formatter.H"
#include "config.H"
#include "fatal.H"
#include "handlers.H"
#include "strpool.H"

int main(int argc, char **argv)
{
  SetProgramName(argv[0]);
  InitStringPool();
  int start_arg;
  ParseOptions(argc, argv, start_arg);
  InitVulnDB();
  InitResultsDB();
  InitHandlers();
  RunQueries();
  int i;
  if(argc-start_arg == 0)
    {
      if(!GetArglessOkay())
	ShowHelp();
      exit(0);
    }
  for(i=start_arg;i<argc;i++)
    {
      FILE *f = fopen(argv[i], "r");  // its4: ignore fopen
      if(f == NULL)
	{
	  perror(argv[i]);
	  continue;
	}
      Lex *l = new Lex(f, argv[i], 1);
      if(!l)
	OutOfMemory();
      fclose(f);
      Scanner *s = new Scanner(l);
      if(!s)
	OutOfMemory();
      s->RunScan();
      delete s;
      delete l;
    }
  DoPostProcessing();
  FormatterOutput();
  return 0;
}
