/* query.C
 * John Viega
 *
 * Jan 29 2000
 */


#include "config.H"
#include "query.H"
#include "fatal.H"

static int num_queries = 0;
static const int incr = 100;

char **queries = 0;

void AddQuery(char *q)
{
  if(!queries)
    {
      queries = new char*[incr];
      if(!queries)
	OutOfMemory();
    }
  int size = strlen(q) + 1;
  char *str = new char[size];
  if(!str)
    OutOfMemory();
  strncpy(str, q, size);
  queries[num_queries++] = str;
  if(!(num_queries%incr))
    {
      char **new_queries = new char*[num_queries+incr];
      if(!new_queries)
	OutOfMemory();
      for(int i=0;i<num_queries;i++)
	new_queries[i] = queries[i];
      delete[] queries;
      queries = new_queries;
    }
}

char **GetQueries(int &num)
{
  num = num_queries;
  return queries;
}

void DeallocQueries()
{
  for(int i=0;i<num_queries;i++)
    delete[]queries[i];
  delete[] queries;
}
