---
layout: default
title: ICU Documentation
nav_order: 1
description: ICU Documentation
---

<!--
© 2020 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# ICU Documentation

[![ICU logo](https://github.com/unicode-org/icu-docs/raw/main/img/iculogo_64.png)](https://icu.unicode.org/)

## ICU User Guide

The [ICU User Guide](./userguide) provides information on i18n topics for which ICU has services, and
includes details that go beyond the C, C++, and Java API docs (and avoids some duplication between them).

This is the new home of the User Guide (since 2020 August).

## ICU Site

The official ICU Site is located at https://icu.unicode.org/.
It is the official landing page for the ICU project.

Some of the pages from the ICU Site have been migrated here.
The migrated sections and pages from the ICU Site are visible in the navigation bar of this site below the "ICU Site" section heading.

## Downloading ICU

The [Downloading ICU](download) page has been migrated here.

### Latest Release

***2025-03-13: ICU 77 is now available*** —
[releases/tag/release-77-1](https://github.com/unicode-org/icu/releases/tag/release-77-1) —
[Maven: com.ibm.icu / icu4j / version 77.1](https://mvnrepository.com/artifact/com.ibm.icu/icu4j/77.1)

[ICU 77](download/77.md) updates to [CLDR 47](https://cldr.unicode.org/downloads/cldr-47)
locale data with new locales, and various additions and corrections.

ICU 77 is mostly focused on bug fixes, segmentation conformance, and other refinements.
The technology preview implementations of the CLDR MessageFormat 2.0 specification have been updated to incorporate some, but not yet all, of the CLDR 47 changes. (Java more than C++)

## ICU team member pages

Other documentation pages here are written by and for team members.
