/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.PPTExporter;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractExportPage;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class PPTExportWizard
extends DocumentExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.story.export.pptExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.story.export.ppt";
    private static final String KEY_ALL_STORIES = "allTasksRadio";
    private static final String PPT_EXT = ".ppt";
    private static final String PPTX_EXT = ".pptx";
    private FileDialog fileDialog;
    private PPTExportPage page;
    private IWorkbook workbook;
    private String storyId;

    public PPTExportWizard(IWorkbook workbook, String storyId) {
        this.workbook = workbook;
        this.storyId = storyId;
        this.setWindowTitle(ExportMessages.PPTWizard_WindowTitle);
        this.setDialogSettings(AsposePlugin.getDialogSettings((String)SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected IExporter createExporter() {
        boolean allStories = this.getDialogSettings().getBoolean(KEY_ALL_STORIES);
        ArrayList<PresentationStory> stories = new ArrayList<PresentationStory>();
        if (allStories) {
            stories.addAll(PresentationStoryManager.instance.getStories(this.workbook));
        } else {
            stories.add(PresentationStoryManager.instance.getStory(this.workbook, this.storyId));
        }
        int version = this.getExtension();
        PPTExporter pptExporter = new PPTExporter(stories, this.getTargetPath(), version, this.getShell().getDisplay());
        pptExporter.setDialogSettings(this.getDialogSettings());
        pptExporter.init();
        if (!pptExporter.canStart()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PPTExportWizard.this.page.setErrorMessage(PresentationMessages.PptExportWizard_noSlideErrorTip_text);
                }
            });
        }
        return pptExporter;
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("StoryExportToPPT", ExportMessages.PPTExportJob_Name));
        this.page = new PPTExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getFormatName() {
        if (this.getExtension() == 2) {
            return ExportMessages.PPT2007Wizard_FormatName;
        }
        return ExportMessages.PPTWizard_FormatName;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && (PPT_EXT.equalsIgnoreCase(extension) || PPTX_EXT.equalsIgnoreCase(extension));
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private int getExtension() {
        if (this.fileDialog == null) {
            return 1;
        }
        int filterIndex = this.fileDialog.getFilterIndex();
        String filterExtension = this.fileDialog.getFilterExtensions()[filterIndex];
        if (filterExtension.equals("*.pptx")) {
            String target = this.getTargetPath();
            if (!target.contains(PPTX_EXT)) {
                this.setTargetPath(String.valueOf(target) + "x");
            }
            return 2;
        }
        return 1;
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + PPT_EXT;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("StoryExportToPPTCount");
        super.doExport(monitor, display, parentShell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PPTExportPage
    extends AbstractExportPage {
        private Button currentStoryRadio;
        private Button allStoriesRadio;

        public PPTExportPage() {
            super(PPTExportWizard.PAGE_NAME, ExportMessages.PPTPage_Title, null);
            this.setDescription(ExportMessages.PPTPage_Description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 20;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            this.creatContentSection(composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        private void creatContentSection(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(MindMapMessages.MultipageSetupDialog_Content);
            this.currentStoryRadio = new Button((Composite)group, 16);
            this.currentStoryRadio.setText(PresentationMessages.PptExportPage_currentStoryRadio_text);
            this.currentStoryRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.hookWidget((Widget)this.currentStoryRadio, 13);
            this.allStoriesRadio = new Button((Composite)group, 16);
            this.allStoriesRadio.setText(PresentationMessages.PptExportPage_allStoriesRadio_text);
            this.allStoriesRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.hookWidget((Widget)this.allStoriesRadio, 13);
            this.updateContentSelection();
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, ExportMessages.PPT2007Page_FilterName);
            filterNames.add(0, ExportMessages.PPTPage_FilterName);
            filterExtensions.add(0, "*.pptx");
            filterExtensions.add(0, "*.ppt");
            PPTExportWizard.this.fileDialog = dialog;
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.currentStoryRadio || event.widget == this.allStoriesRadio) {
                this.getDialogSettings().put(PPTExportWizard.KEY_ALL_STORIES, event.widget == this.allStoriesRadio);
            }
            super.handleWidgetEvent(event);
        }

        private void updateContentSelection() {
            boolean allStories = this.getDialogSettings().getBoolean(PPTExportWizard.KEY_ALL_STORIES);
            this.allStoriesRadio.setSelection(allStories);
            this.currentStoryRadio.setSelection(!allStories);
        }
    }
}

