/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentUndoManager;
import org.xmind.ui.richtext.RichDocumentUndoManager;

public class RichDocumentUndoManagerRegistry {
    private static Map<IRichDocument, Record> fgFactory = new HashMap<IRichDocument, Record>();

    private RichDocumentUndoManagerRegistry() {
    }

    public static synchronized void connect(IRichDocument document) {
        Assert.isNotNull((Object)document);
        Record record = fgFactory.get(document);
        if (record == null) {
            record = new Record(document);
            fgFactory.put(document, record);
        }
        Record record2 = record;
        record2.count = record2.count + 1;
    }

    public static synchronized void disconnect(IRichDocument document) {
        Assert.isNotNull((Object)document);
        Record record = fgFactory.get(document);
        if (record != null) {
            Record record2 = record;
            record2.count = record2.count - 1;
            if (record.count == 0) {
                fgFactory.remove(document);
            }
        }
    }

    public static synchronized IRichDocumentUndoManager getDocumentUndoManager(IRichDocument document) {
        Assert.isNotNull((Object)document);
        Record record = fgFactory.get(document);
        if (record == null) {
            return null;
        }
        return record.undoManager;
    }

    private static final class Record {
        private int count = 0;
        private IRichDocumentUndoManager undoManager;

        public Record(IRichDocument document) {
            this.undoManager = new RichDocumentUndoManager(document);
        }
    }
}

