/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.ContentPanePart;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.SimpleImagePart;
import org.xmind.ui.internal.views.ThemeFigure;
import org.xmind.ui.internal.wizards.TemplateLabelProvider;
import org.xmind.ui.mindmap.ITemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportResourceViewer
extends GalleryViewer {
    private List<Object> selectedItems = new LinkedList<Object>();
    private List<CheckBox> checkBoxes = new ArrayList<CheckBox>();
    private List<FramePart> frameParts = new ArrayList<FramePart>();

    public ExportResourceViewer(Composite parent) {
        this.init();
        this.createControl(parent);
    }

    protected void init() {
        this.setPartFactory(new ResourcePartFactory());
        this.setContentProvider((IStructuredContentProvider)new ResourceContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new ResourceSelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        this.setEditDomain(editDomain);
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 10, 10, 10, 10, 10, 10));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(128, 64));
        properties.set("constrained", true);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        this.checkBoxes.clear();
        this.frameParts.clear();
    }

    public List<Object> getSelectedItems() {
        return this.selectedItems;
    }

    public void selectAllItems(boolean selected) {
        if (selected) {
            if (!this.frameParts.isEmpty()) {
                for (FramePart framePart : this.frameParts) {
                    if (this.selectedItems.contains(framePart.getModel())) continue;
                    this.selectedItems.add(framePart.getModel());
                }
            }
        } else {
            this.selectedItems.clear();
        }
        if (!this.checkBoxes.isEmpty()) {
            for (CheckBox checkBox : this.checkBoxes) {
                checkBox.setSelected(selected);
            }
        }
        if (!this.frameParts.isEmpty()) {
            for (FramePart part : this.frameParts) {
                part.getFigure().setSelected(selected);
            }
        }
    }

    private class CheckboxPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            if (this.getModel() instanceof String) {
                CheckBox checkBox = new CheckBox();
                ExportResourceViewer.this.checkBoxes.add(checkBox);
                return checkBox;
            }
            Figure figure = new Figure();
            figure.setLayoutManager((LayoutManager)new StackLayout());
            return figure;
        }

        protected void updateChildren() {
            super.updateChildren();
            for (IPart child : this.getChildren()) {
                child.update();
            }
        }

        protected Object[] getModelChildren(Object model) {
            return new Object[]{model};
        }

        protected void updateView() {
            super.updateView();
        }

        public CheckboxPart(Object model) {
            this.setModel(model);
        }

        public IFigure getContentPane() {
            return super.getFigure();
        }

        protected void register() {
            this.registerModel(this.getModel());
            super.register();
        }

        protected void unregister() {
            super.unregister();
            this.unregisterModel(this.getModel());
        }

        protected void declareEditPolicies(IRequestHandler reqHandler) {
            super.declareEditPolicies(reqHandler);
            reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
            reqHandler.installEditPolicy("navigable role", "org.xmind.ui.gallery.editPolicy.navigable");
        }

        protected void handleStatusChanged(StatusEvent event) {
            if ((event.key & 2) != 0) {
                IFigure figure = this.getFigure();
                if (figure instanceof CheckBox) {
                    ((CheckBox)figure).setSelected(event.newValue);
                }
                IPart doublePart = this.getParent();
                List checkboxParts = doublePart.getChildren();
                for (IPart child : checkboxParts) {
                    List frameParts = child.getChildren();
                    for (IPart framePart : frameParts) {
                        if (!(framePart instanceof FramePart)) continue;
                        ((FramePart)framePart).getFigure().setSelected(event.newValue);
                        Object model = ((FramePart)framePart).getModel();
                        if (event.newValue) {
                            ExportResourceViewer.this.selectedItems.add(model);
                            continue;
                        }
                        ExportResourceViewer.this.selectedItems.remove(model);
                    }
                }
            } else if ((event.key & 4) == 0) {
                if ((event.key & 8) != 0) {
                    this.getFigure().repaint();
                } else {
                    super.handleStatusChanged(event);
                }
            }
        }
    }

    private static class DoublePart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            return new ContentLayout();
        }

        protected void addChildView(IPart child, int index) {
            GridData constraint = new GridData(1, 4, false, false);
            this.getContentPane().add(((IGraphicalPart)child).getFigure(), (Object)constraint, index);
        }

        protected Object[] getModelChildren(Object model) {
            return new Object[]{"XREN:" + model, model};
        }

        protected void updateView() {
            super.updateView();
        }

        public DoublePart(Object model) {
            this.setModel(model);
        }

        public IFigure getContentPane() {
            return super.getFigure();
        }

        protected void register() {
            this.registerModel(this.getModel());
            super.register();
        }

        protected void unregister() {
            super.unregister();
            this.unregisterModel(this.getModel());
        }

        private static class ContentLayout
        extends AbstractLayout {
            private static Rectangle BOUNDS = new Rectangle();
            private static Rectangle CHILD_BOUNDS = new Rectangle();

            public void layout(IFigure container) {
                Rectangle area = container.getClientArea(BOUNDS);
                int childX = area.x;
                int childY = 0;
                for (Object child : container.getChildren()) {
                    IFigure figure = (IFigure)child;
                    Dimension childSize = figure.getPreferredSize(-1, -1);
                    int childWidth = childSize.width;
                    int childHeight = childSize.height;
                    childY = area.y + (area.height - childHeight) / 2;
                    CHILD_BOUNDS.setBounds(childX, childY, childWidth, childHeight);
                    figure.setBounds(CHILD_BOUNDS);
                    childX += childWidth + 10;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                int childWidth = 0;
                int childHeight = 0;
                for (Object child : container.getChildren()) {
                    Dimension childSize = ((IFigure)child).getPreferredSize(-1, -1);
                    childWidth += childSize.width;
                    childHeight += childSize.height;
                }
                return new Dimension(childWidth + 20, childHeight);
            }
        }
    }

    private class ResourceContentProvider
    extends ArrayContentProvider {
        private ResourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof GalleryCore) {
                LinkedList items = new LinkedList();
                List groups = ((GalleryCore)inputElement).getGalleryGroups();
                for (IGalleryGroup group : groups) {
                    items.addAll(group.getItems());
                }
                return items.toArray();
            }
            if (inputElement instanceof IGalleryGroup) {
                return ((IGalleryGroup)inputElement).getItems().toArray();
            }
            return super.getElements(inputElement);
        }
    }

    private class ResourceFramePart
    extends FramePart {
        public ResourceFramePart(Object model) {
            super(model);
            ExportResourceViewer.this.frameParts.add(this);
        }

        protected void handleStatusChanged(StatusEvent event) {
            if ((event.key & 2) != 0) {
                Object model = this.getModel();
                if (event.newValue) {
                    ExportResourceViewer.this.selectedItems.add(model);
                } else {
                    ExportResourceViewer.this.selectedItems.remove(model);
                }
                IPart checkboxPart = this.getParent();
                IPart doublePart = checkboxPart.getParent();
                List checkboxParts = doublePart.getChildren();
                for (IPart checkbox : checkboxParts) {
                    CheckboxPart part;
                    IFigure figure;
                    if (!(checkbox instanceof CheckboxPart) || !((figure = (part = (CheckboxPart)checkbox).getFigure()) instanceof CheckBox)) continue;
                    ((CheckBox)figure).setSelected(event.newValue);
                }
            }
            super.handleStatusChanged(event);
        }
    }

    private class ResourceLabelProvider
    extends TemplateLabelProvider {
        private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());

        public String getText(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getName();
            }
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getName();
            }
            if (element instanceof IGalleryItem) {
                File file;
                if (element instanceof DownloadedGalleryItem) {
                    String path = ((DownloadedGalleryItem)element).getPath();
                    File file2 = new File(path);
                    if (file2.exists()) {
                        return file2.getName();
                    }
                } else if (element instanceof LocalGalleryItem && (file = ((LocalGalleryItem)element).getFile()) != null) {
                    return file.getName();
                }
            } else if (element instanceof IMarkerGroup) {
                return ((IMarkerGroup)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IGalleryItem) {
                URL url = ((IGalleryItem)element).getURL();
                if (url != null) {
                    return (Image)this.resources.get((DeviceResourceDescriptor)ImageDescriptor.createFromURL((URL)url));
                }
                return null;
            }
            return super.getImage(element);
        }

        public void dispose() {
            super.dispose();
            this.resources.dispose();
        }
    }

    private class ResourcePartFactory
    implements IPartFactory {
        private ResourcePartFactory() {
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof ContentPanePart) {
                return new DoublePart(model);
            }
            if (context instanceof DoublePart) {
                return new CheckboxPart(model);
            }
            if (model instanceof String) {
                return null;
            }
            if (context instanceof CheckboxPart) {
                return new ResourceFramePart(model);
            }
            if (context instanceof ResourceFramePart && model instanceof IStyle) {
                return new ThemePart((IStyle)model);
            }
            if (context instanceof ResourceFramePart) {
                return new SimpleImagePart(model);
            }
            return new ContentPanePart(model);
        }
    }

    private static class ResourceSelectTool
    extends GallerySelectTool {
        private ResourceSelectTool() {
        }

        protected boolean handleMouseDown(MouseEvent me) {
            this.getStatus().setStatus(4, true);
            return super.handleMouseDown(me);
        }

        public boolean handleMouseUp(MouseEvent me) {
            this.getStatus().setStatus(4, true);
            return super.handleMouseUp(me);
        }
    }

    private static class ThemePart
    extends GraphicalEditPart {
        public ThemePart(IStyle style) {
            this.setModel(style);
        }

        public IStyle getStyle() {
            return (IStyle)super.getModel();
        }

        protected IFigure createFigure() {
            return new ThemeFigure();
        }

        protected Object[] getModelChildren(Object model) {
            return new Object[0];
        }

        protected void updateView() {
            super.updateView();
            ((ThemeFigure)this.getFigure()).setTheme(this.getStyle());
            Properties properties = ((GalleryViewer)this.getSite().getViewer()).getProperties();
            Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            if (size != null) {
                this.getFigure().setPreferredSize(size);
            }
        }

        protected void register() {
            this.registerModel(this.getStyle().getId());
            super.register();
        }

        protected void unregister() {
            super.unregister();
            this.unregisterModel(this.getStyle().getId());
        }
    }
}

