/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.IDecorator;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.ui.internal.mindmap.MarkerDecorator;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.SelectionFeedbackHelper;
import org.xmind.ui.internal.mindmap.SimpleSelectionFeedback;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.internal.svgsupport.SVGImageData;
import org.xmind.ui.internal.svgsupport.SVGImageFigure;
import org.xmind.ui.internal.svgsupport.SVGReference;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ImageReference;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.style.TextStyleData;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MarkerPart
extends MindMapPartBase
implements IMarkerPart {
    private ImageReference imageRef = null;
    private SVGReference svgRef = null;
    private Dimension preferredSize = null;
    private LocalResourceManager resourceManager;

    public MarkerPart() {
        this.setDecorator((IDecorator)MarkerDecorator.getInstance());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IMarkerRef.class)) {
            return this.getMarkerRef();
        }
        if (adapter.isAssignableFrom(IMarker.class)) {
            return this.getMarker();
        }
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == Image.class) {
            return this.getImage();
        }
        if (adapter == SVGImageData.class) {
            return this.getSVGData();
        }
        return super.getAdapter(adapter);
    }

    protected IFigure createFigure() {
        if (this.svgRef != null) {
            SVGImageFigure figure = new SVGImageFigure();
            figure.setManager((ResourceManager)this.resourceManager);
            return figure;
        }
        return new SizeableImageFigure();
    }

    @Override
    public IMarkerRef getMarkerRef() {
        return (IMarkerRef)super.getRealModel();
    }

    protected void register() {
        this.registerModel(this.getMarkerRef());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getMarkerRef());
    }

    @Override
    public IMarker getMarker() {
        IMarkerRef markerRef = this.getMarkerRef();
        return markerRef == null ? null : markerRef.getMarker();
    }

    @Override
    public ITopic getTopic() {
        return this.getMarkerRef().getParent();
    }

    @Override
    public ITopicPart getTopicPart() {
        if (this.getParent() instanceof ITopicPart) {
            return (ITopicPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        if (this.getParent() instanceof TopicPart) {
            ((TopicPart)this.getParent()).removeMarker(this);
        }
        super.setParent(parent);
        this.updateMarker();
        if (this.getParent() instanceof TopicPart) {
            ((TopicPart)this.getParent()).addMarker(this);
        }
    }

    @Override
    public Image getImage() {
        if (this.imageRef != null && !this.imageRef.isDisposed()) {
            return this.imageRef.getImage();
        }
        return null;
    }

    @Override
    public SVGImageData getSVGData() {
        if (this.svgRef != null) {
            return this.svgRef.getSVGData();
        }
        return null;
    }

    @Override
    protected void onActivated() {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        super.onActivated();
    }

    @Override
    protected void onDeactivated() {
        if (this.imageRef != null) {
            this.imageRef.dispose();
            this.imageRef = null;
        }
        if (this.svgRef != null) {
            this.svgRef = null;
            this.resourceManager.dispose();
        }
        super.onDeactivated();
    }

    public void setModel(Object model) {
        String svgPath;
        super.setModel(model);
        IMarkerRef markerRef = (IMarkerRef)((ViewerModel)model).getRealModel();
        IMarker marker = markerRef.getMarker();
        String string = svgPath = marker != null ? marker.getSVGPath() : null;
        if (svgPath != null && !"".equals(svgPath)) {
            this.svgRef = this.createSVGReference();
        } else {
            this.imageRef = this.createImageReference();
        }
    }

    public boolean containsPoint(Point position) {
        return super.containsPoint(position);
    }

    @Override
    protected void updateView() {
        this.updateToolTip();
        super.updateView();
    }

    public IFigure findTooltipAt(Point position) {
        if (this.containsPoint(position)) {
            IFigure toolTip = this.getFigure().getToolTip();
            if (toolTip != null) {
                return toolTip;
            }
            return new Label(this.getMarkerRef().getDescription());
        }
        return null;
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.markerMovable");
    }

    @Override
    protected IFeedback createFeedback() {
        return new SimpleSelectionFeedback(this);
    }

    @Override
    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new SelectionFeedbackHelper();
    }

    @Override
    protected void installModelListeners() {
        super.installModelListeners();
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("style");
        ITopic topic = this.getMarkerRef().getParent();
        register.setNextSourceFrom((Object)topic);
        register.register("style");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("style".equals(type)) {
            this.updateMarker();
        }
    }

    private void updateMarker() {
        if (this.svgRef == null) {
            if (this.imageRef != null) {
                this.imageRef.dispose();
            }
            this.imageRef = this.createImageReference();
        } else {
            this.preferredSize = this.calculateSVGPreferredSize();
        }
        this.update();
    }

    private ImageReference createImageReference() {
        this.preferredSize = this.calculateImagePreferredSize();
        int hintSize = this.preferredSize == null ? -1 : this.preferredSize.width;
        return new ImageReference(MarkerImageDescriptor.createFromMarkerRef(this.getMarkerRef(), hintSize, hintSize), false);
    }

    private SVGReference createSVGReference() {
        this.preferredSize = this.calculateSVGPreferredSize();
        String resourcePath = "platform:/plugin/org.xmind.ui.resources/markers/" + this.getMarker().getSVGPath();
        SVGReference ref = new SVGReference(resourcePath);
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return ref;
    }

    private Dimension calculateSVGPreferredSize() {
        ITopicPart tp = this.getTopicPart();
        if (tp == null) {
            return null;
        }
        IStyleSelector ss = (IStyleSelector)tp.getAdapter(IStyleSelector.class);
        TextStyleData data = StyleUtils.getTextStyleData(tp, ss, null);
        int leading = GraphicsUtils.getAdvanced().getFontMetrics(JFaceResources.getDefaultFont()).getLeading();
        return new Dimension(data.height + leading, data.height + leading);
    }

    private Dimension calculateImagePreferredSize() {
        ITopicPart tp = this.getTopicPart();
        if (tp == null) {
            return null;
        }
        IStyleSelector ss = (IStyleSelector)tp.getAdapter(IStyleSelector.class);
        TextStyleData data = StyleUtils.getTextStyleData(tp, ss, null);
        int fontSize = data.height;
        if (fontSize < 13) {
            return new Dimension(16, 16);
        }
        if (fontSize >= 13 && fontSize < 25) {
            return new Dimension(24, 24);
        }
        return new Dimension(32, 32);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }
}

