/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.xmind.core.Core;
import org.xmind.core.ITopic;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.AbstractViewer;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.graphicalpolicy.AbstractGraphicalPolicy;
import org.xmind.gef.graphicalpolicy.AbstractStyleSelector;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.graphicalpolicy.IStyleValueProvider;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.PartRegistry;
import org.xmind.gef.service.IShadowService;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.IBranchPolicy;
import org.xmind.ui.branch.IBranchStyleSelector;
import org.xmind.ui.internal.mindmap.BranchPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.util.MindMapUtils;

public class BranchDummy {
    private IGraphicalViewer viewer;
    private IBranchPart branch;
    private ITopic topic;

    public BranchDummy(IGraphicalViewer viewer, boolean newTopic) {
        this(viewer, null, newTopic);
    }

    public BranchDummy(IGraphicalViewer viewer, IBranchPart sourceBranch) {
        this(viewer, sourceBranch, false);
    }

    private BranchDummy(IGraphicalViewer viewer, IBranchPart sourceBranch, boolean newTopic) {
        this.viewer = viewer;
        this.create(sourceBranch, newTopic);
        this.pack(sourceBranch);
    }

    private void create(IBranchPart sourceBranch, boolean newTopic) {
        this.topic = this.createDummyTopic(sourceBranch, newTopic);
        if (sourceBranch != null || !newTopic) {
            PartRegistry partRegistry = this.viewer.getPartRegistry();
            if (this.viewer instanceof AbstractViewer) {
                ((AbstractViewer)this.viewer).setPartRegistry(null);
            }
            BranchPart branchPart = new BranchPart();
            if (sourceBranch != null) {
                branchPart.setOverrideBranchType(sourceBranch.getBranchType());
            }
            this.branch = branchPart;
            this.branch.setModel(this.topic);
            this.branch.setParent((IPart)this.viewer.getRootPart());
            this.addBranchView();
            this.branch.addNotify();
            this.branch.getStatus().activate();
            this.removeShadow();
            if (sourceBranch != null) {
                ((BranchPart)this.branch).setGraphicalPolicy(new DummyBranchPolicy(sourceBranch));
            }
            if (this.viewer instanceof AbstractViewer) {
                ((AbstractViewer)this.viewer).setPartRegistry(partRegistry);
            }
        } else {
            IPart topicPart = this.viewer.findPart((Object)this.topic);
            this.branch = MindMapUtils.findBranch(topicPart);
            this.branch.getFigure().setEnabled(false);
        }
        this.branch.refresh();
    }

    private void removeShadow() {
        IShadowService shadowService = (IShadowService)this.viewer.getService(IShadowService.class);
        if (shadowService != null) {
            shadowService.removeShadow(this.branch.getTopicPart().getFigure());
        }
    }

    private void pack(IBranchPart sourceBranch) {
        this.pack();
        if (sourceBranch != null) {
            ((IReferencedFigure)this.branch.getFigure()).setReference(((IReferencedFigure)sourceBranch.getFigure()).getReference());
        }
    }

    public void pack() {
        IFigure figure = this.branch.getFigure();
        figure.setSize(figure.getPreferredSize());
    }

    private ITopic createDummyTopic(IBranchPart sourceBranch, boolean newTopic) {
        ITopic topic;
        if (sourceBranch == null && newTopic) {
            ITopic centralTopic = (ITopic)this.viewer.getAdapter(ITopic.class);
            topic = centralTopic.getOwnedWorkbook().createTopic();
            centralTopic.add(topic, "detached");
        } else if (sourceBranch != null) {
            ITopic sourceTopic = sourceBranch.getTopic();
            topic = sourceTopic.getOwnedWorkbook().createTopic();
            topic.setTitleText(sourceTopic.getTitleText());
            topic.setStyleId(sourceTopic.getStyleId());
            topic.setTitleWidth(sourceTopic.getTitleWidth());
        } else {
            topic = Core.getWorkbookBuilder().createWorkbook().createTopic();
        }
        return topic;
    }

    public IBranchPart getBranch() {
        return this.branch;
    }

    public ITopic getTopic() {
        return this.topic;
    }

    public void dispose() {
        if (this.topic != null) {
            ITopic parent = this.topic.getParent();
            if (parent != null) {
                parent.remove(this.topic);
                this.branch = null;
            } else if (this.branch != null) {
                this.branch.getStatus().deactivate();
                this.branch.removeNotify();
                this.removeBranchView();
                this.branch.setParent(null);
                this.branch = null;
            }
            this.topic = null;
        }
    }

    private void addBranchView() {
        Layer layer = this.viewer.getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            layer.add(this.branch.getFigure());
        }
    }

    private void removeBranchView() {
        IFigure figure = this.branch.getFigure();
        if (figure.getParent() != null) {
            figure.getParent().remove(figure);
        }
    }

    public void setStyle(String key, String value) {
        IStyleSelector ss = this.branch.getBranchPolicy().getStyleSelector(this.branch);
        if (ss instanceof DummyStyleSelector) {
            ((DummyStyleSelector)ss).setOverridedStyle(key, value);
        } else {
            IStyleSheet styleSheet = this.topic.getOwnedWorkbook().getStyleSheet();
            IStyle style = styleSheet.findStyle(this.topic.getStyleId());
            if (style == null) {
                style = styleSheet.createStyle("topic");
                styleSheet.addStyle(style, "normal-styles");
                this.topic.setStyleId(style.getId());
            }
            style.setProperty(key, value);
        }
    }

    public void removeOverridedStyle(String key) {
        IStyleSelector ss = this.branch.getBranchPolicy().getStyleSelector(this.branch);
        if (ss instanceof DummyStyleSelector) {
            ((DummyStyleSelector)ss).removeOverridedStyle(key);
        } else {
            this.setStyle(key, null);
        }
    }

    private static class DummyBranchPolicy
    extends AbstractGraphicalPolicy
    implements IBranchPolicy {
        private IBranchPart sourceBranch;

        public DummyBranchPolicy(IBranchPart sourceBranch) {
            this.sourceBranch = sourceBranch;
        }

        protected IStructure createDefaultStructureAlgorithm() {
            return DummyBranchStructure.instance;
        }

        protected IStyleSelector createDefaultStyleSelector() {
            return new DummyStyleSelector(this.sourceBranch);
        }

        @Override
        public void flushStructureCache(IBranchPart branch, boolean ancestors, boolean descendants) {
        }

        @Override
        public boolean isPropertyModifiable(IBranchPart branch, String propertyKey) {
            return false;
        }

        @Override
        public boolean isPropertyModifiable(IBranchPart branch, String propertyKey, String secondaryKey) {
            return false;
        }

        @Override
        public void postDeactivate(IBranchPart branch) {
        }
    }

    private static class DummyBranchStructure
    extends AbstractBranchStructure {
        private static DummyBranchStructure instance = new DummyBranchStructure();

        private DummyBranchStructure() {
        }

        @Override
        protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        }

        @Override
        protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        }
    }

    private static class DummyStyleSelector
    extends AbstractStyleSelector
    implements IBranchStyleSelector {
        private IBranchPart sourceBranch;
        private Map<String, String> overridedStyles = null;

        public DummyStyleSelector(IBranchPart sourceBranch) {
            this.sourceBranch = sourceBranch;
        }

        public String getAutoValue(IGraphicalPart part, String key, IStyleValueProvider defaultValueProvider) {
            if (this.overridedStyles != null && this.overridedStyles.containsKey(key)) {
                return this.overridedStyles.get(key);
            }
            if ("rotate-angle".equals(key)) {
                return Double.toString(0.0);
            }
            return this.sourceBranch.getBranchPolicy().getStyleSelector(this.sourceBranch).getAutoValue((IGraphicalPart)this.sourceBranch, key, defaultValueProvider);
        }

        public String getUserValue(IGraphicalPart part, String key) {
            if (this.overridedStyles != null && this.overridedStyles.containsKey(key)) {
                return this.overridedStyles.get(key);
            }
            if ("rotate-angle".equals(key)) {
                return Double.toString(0.0);
            }
            return this.sourceBranch.getBranchPolicy().getStyleSelector(this.sourceBranch).getUserValue((IGraphicalPart)this.sourceBranch, key);
        }

        public String getStyleValue(IGraphicalPart part, String key, IStyleValueProvider defaultValueProvider) {
            if (this.overridedStyles != null && this.overridedStyles.containsKey(key)) {
                return this.overridedStyles.get(key);
            }
            if ("rotate-angle".equals(key)) {
                return Double.toString(0.0);
            }
            return this.sourceBranch.getBranchPolicy().getStyleSelector(this.sourceBranch).getStyleValue((IGraphicalPart)this.sourceBranch, key, defaultValueProvider);
        }

        @Override
        public void flushStyleCaches(IBranchPart branch) {
        }

        public void setOverridedStyle(String key, String value) {
            if (this.overridedStyles == null) {
                this.overridedStyles = new HashMap<String, String>();
            }
            this.overridedStyles.put(key, value);
        }

        public void removeOverridedStyle(String key) {
            if (this.overridedStyles != null) {
                this.overridedStyles.remove(key);
            }
        }
    }
}

