/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.net.URI;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.cathy.internal.dashboard.RecentFileViewer;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.views.Page;

public class RecentFileGridPage
extends Page {
    private GalleryViewer viewer;
    private LocalResourceManager resources;

    protected Control doCreateControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        }
        Composite titleBar = new Composite(composite, 0);
        titleBar.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ececec")));
        titleBar.setForeground(composite.getForeground());
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(titleBar);
        GridData titleBarData = new GridData(4, 4, true, false);
        titleBarData.heightHint = 44;
        titleBar.setLayoutData((Object)titleBarData);
        Label titleLabel = new Label(titleBar, 0);
        titleLabel.setBackground(titleBar.getBackground());
        titleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#000000")));
        titleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getHeaderFontDescriptor().increaseHeight(-1)));
        titleLabel.setText(WorkbenchMessages.DashboardRecentFiles_message);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)titleLabel);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite panel = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(panel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        this.createViewer(panel);
        return composite;
    }

    private void createViewer(Composite parent) {
        this.viewer = new RecentFileViewer(parent);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RecentFileGridPage.this.handleOpenRecentFile(event.getSelection());
            }
        });
    }

    private void handleOpenRecentFile(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof URI)) {
            return;
        }
        URI uri = (URI)element;
        this.openFile(uri);
    }

    private void openFile(URI uri) {
        this.executeCommand("org.xmind.ui.command.openWorkbook", "org.xmind.ui.command.openWorkbook.uri", uri);
    }

    private void executeCommand(String commandId, String parameter, URI uri) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        EHandlerService hs = (EHandlerService)window.getService(EHandlerService.class);
        ECommandService cs = (ECommandService)window.getService(ECommandService.class);
        if (hs == null || cs == null) {
            return;
        }
        Command command = cs.getCommand(commandId);
        if (command == null || !command.isDefined()) {
            return;
        }
        try {
            IParameter param = command.getParameter(parameter);
            if (param == null) {
                return;
            }
            ParameterizedCommand pc = new ParameterizedCommand(command, new Parameterization[]{new Parameterization(param, uri.toString())});
            if (!hs.canExecute(pc)) {
                return;
            }
            hs.executeHandler(pc);
        }
        catch (NotDefinedException e) {
            CathyPlugin.log(e, String.valueOf(((Object)((Object)this)).getClass().getName()) + "-->execute openLocalFileHandler or openCloudFileHandler");
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.viewer != null) {
            if (adapter.isAssignableFrom(this.viewer.getClass())) {
                return adapter.cast(this.viewer);
            }
            Object obj = this.viewer.getAdapter(adapter);
            if (obj != null) {
                return (T)obj;
            }
        }
        return (T)super.getAdapter(adapter);
    }
}

