/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.SimpleRectangleFigure;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.service.AbstractFeedback;
import org.xmind.gef.service.IRectangleProvider;

public class RectangleFeedback
extends AbstractFeedback {
    private SimpleRectangleFigure figure;
    private Rectangle bounds;
    private Color borderColor;
    private Color fillColor;
    private int borderAlpha;
    private int fillAlpha;
    private IRectangleProvider boundsProvider;

    private SimpleRectangleFigure createFigure() {
        SimpleRectangleFigure figure = new SimpleRectangleFigure();
        figure.setForegroundColor(this.borderColor);
        figure.setBackgroundColor(this.fillColor);
        figure.setMainAlpha(this.borderAlpha);
        figure.setSubAlpha(this.fillAlpha);
        return figure;
    }

    public void addToLayer(IFigure layer) {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        layer.add((IFigure)this.figure);
    }

    public boolean containsPoint(Point point) {
        if (this.figure != null && this.bounds != null) {
            if (this.getZoomManager() != null) {
                point = this.getZoomManager().getScaled(point);
            }
            return this.figure.containsPoint(point) && this.figure.isShowing();
        }
        return false;
    }

    public void removeFromLayer(IFigure layer) {
        if (this.figure != null) {
            layer.remove((IFigure)this.figure);
        }
    }

    public void update() {
        Rectangle rect;
        if (this.figure == null) {
            return;
        }
        if (this.boundsProvider != null && (rect = this.boundsProvider.getRectangle()) != null) {
            this.setBounds(rect);
        }
        if (this.bounds != null) {
            this.figure.setClient(this.getScaledBounds(this.bounds));
        }
        this.figure.setForegroundColor(this.borderColor);
        this.figure.setBackgroundColor(this.fillColor);
        this.figure.setMainAlpha(this.borderAlpha);
        this.figure.setSubAlpha(this.fillAlpha);
    }

    private Rectangle getScaledBounds(Rectangle r) {
        if (this.getZoomManager() != null) {
            r = this.getZoomManager().getScaled(r);
        }
        return Geometry.getBounds(r, true, 1, 0);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public IRectangleProvider getBoundsProvider() {
        return this.boundsProvider;
    }

    public void setBoundsProvider(IRectangleProvider boundsProvider) {
        this.boundsProvider = boundsProvider;
    }

    public void setBorderAlpha(int borderAlpha) {
        this.borderAlpha = borderAlpha;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setFillAlpha(int fillAlpha) {
        this.fillAlpha = fillAlpha;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }
}

