/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.GlobalVariablesHolder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalVariablesHolder;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.JavaScriptConsoleViewContentTypes;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandlerKt;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/console/JavaScriptDebuggerConsoleExecuteActionHandler;", "Lcom/intellij/execution/console/BaseConsoleExecuteActionHandler;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "consolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/javascript/debugger/console/ConsolePrinter;)V", "getConsolePrinter", "()Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "vmSupplier", "Lkotlin/Function0;", "Lorg/jetbrains/debugger/Vm;", "localVariables", "Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "getLocalVariables", "()Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "globalVariables", "Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "getGlobalVariables", "()Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "globalVariables$delegate", "Lkotlin/Lazy;", "isEmptyCommandExecutionAllowed", "", "runExecuteAction", "", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "execute", "text", "", "console", "intellij.javascript.debugger.backend"})
public final class JavaScriptDebuggerConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final Function0<Vm> vmSupplier;
    @NotNull
    private final LocalVariablesHolder localVariables;
    @NotNull
    private final Lazy globalVariables$delegate;

    public JavaScriptDebuggerConsoleExecuteActionHandler(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull CoroutineScope coroutineScope, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        super(true);
        this.debugProcess = debugProcess;
        this.coroutineScope = coroutineScope;
        this.consolePrinter = consolePrinter;
        this.vmSupplier = (Function0)new PropertyReference0Impl(this.debugProcess.getConnection()){

            public Object get() {
                return ((VmConnection)this.receiver).getVm();
            }
        };
        this.localVariables = new LocalVariablesHolder(() -> JavaScriptDebuggerConsoleExecuteActionHandler.localVariables$lambda$0(this.vmSupplier));
        this.globalVariables$delegate = LazyKt.lazy(() -> JavaScriptDebuggerConsoleExecuteActionHandler.globalVariables_delegate$lambda$0(this));
        this.debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                this.updateConsoleContext();
            }

            private final void updateConsoleContext() {
                this.getLocalVariables().setCallFrame(null);
                XDebugSession xDebugSession = debugProcess.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
                XDebugSession session2 = xDebugSession;
                ConsoleView consoleView = debugProcess.getJSConsoleView(false);
                LanguageConsoleView languageConsoleView = consoleView instanceof LanguageConsoleView ? (LanguageConsoleView)consoleView : null;
                if (languageConsoleView == null) {
                    return;
                }
                LanguageConsoleView consoleView2 = languageConsoleView;
                XSourcePosition position = session2.getCurrentPosition();
                ActionsKt.runReadAction(() -> 1.updateConsoleContext$lambda$0(session2, consoleView2, position));
            }

            public void sessionStopped() {
                this.updateConsoleContext();
            }

            public void sessionResumed() {
                this.updateConsoleContext();
            }

            public void sessionPaused() {
                this.updateConsoleContext();
            }

            private static final Unit updateConsoleContext$lambda$0(XDebugSession $session, LanguageConsoleView $consoleView, XSourcePosition $position) {
                if ($session.getProject().isDisposed()) {
                    return Unit.INSTANCE;
                }
                PsiFile psiFile = $consoleView.getFile();
                JSExpressionCodeFragmentImpl jSExpressionCodeFragmentImpl = psiFile instanceof JSExpressionCodeFragmentImpl ? (JSExpressionCodeFragmentImpl)psiFile : null;
                if (jSExpressionCodeFragmentImpl == null) {
                    return Unit.INSTANCE;
                }
                JSExpressionCodeFragmentImpl consolePsiFile = jSExpressionCodeFragmentImpl;
                if ($position == null || $position.getOffset() < 0) {
                    consolePsiFile.setContext(null);
                } else {
                    PsiFile contextPsiFile;
                    PsiFile psiFile2 = contextPsiFile = PsiManager.getInstance((Project)$session.getProject()).findFile($position.getFile());
                    PsiElement context = psiFile2 != null ? psiFile2.findElementAt($position.getOffset()) : null;
                    consolePsiFile.setContext(context);
                }
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final ConsolePrinter getConsolePrinter() {
        return this.consolePrinter;
    }

    @NotNull
    public final LocalVariablesHolder getLocalVariables() {
        return this.localVariables;
    }

    @NotNull
    public final GlobalVariablesHolder getGlobalVariables() {
        Lazy lazy = this.globalVariables$delegate;
        return (GlobalVariablesHolder)lazy.getValue();
    }

    public boolean isEmptyCommandExecutionAllowed() {
        return false;
    }

    public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        if (!(consoleView instanceof WebConsoleView)) {
            super.runExecuteAction(consoleView);
            return;
        }
        this.beforeExecution(consoleView);
        String text = WebConsoleView.printInputFromExecutionEditor$default((WebConsoleView)consoleView, false, false, 3, null);
        UndoManager undoManager = UndoManager.getInstance((Project)((WebConsoleView)consoleView).getProject());
        Intrinsics.checkNotNull((Object)undoManager, (String)"null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
        ((UndoManagerImpl)undoManager).invalidateActionsFor(DocumentReferenceManager.getInstance().create((Document)((WebConsoleView)consoleView).getCurrentEditor().getDocument()));
        ConsoleHistoryController.addToHistory((LanguageConsoleView)consoleView, (String)text);
        this.execute(text, consoleView);
    }

    public void execute(@NotNull String text, @NotNull LanguageConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession session2 = xDebugSession;
        XStackFrame xStackFrame = session2.getCurrentStackFrame();
        CallFrameView currentCallFrame = xStackFrame instanceof CallFrameView ? (CallFrameView)xStackFrame : null;
        Vm vm = this.debugProcess.getActiveOrMainVm();
        Intrinsics.checkNotNull((Object)vm);
        Vm vm2 = vm;
        if (console instanceof WebConsoleView) {
            XDebuggerEvaluator.XEvaluationCallback callback2 = new XDebuggerEvaluator.XEvaluationCallback(this, vm2, currentCallFrame, session2){
                final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                final /* synthetic */ Vm $vm;
                final /* synthetic */ CallFrameView $currentCallFrame;
                final /* synthetic */ XDebugSession $session;
                {
                    this.this$0 = $receiver;
                    this.$vm = $vm;
                    this.$currentCallFrame = $currentCallFrame;
                    this.$session = $session;
                }

                public void errorOccurred(String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    BuildersKt.launch$default((CoroutineScope)JavaScriptDebuggerConsoleExecuteActionHandler.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$vm, errorMessage, null){
                        int label;
                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                        final /* synthetic */ Vm $vm;
                        final /* synthetic */ String $errorMessage;
                        {
                            this.this$0 = $receiver;
                            this.$vm = $vm;
                            this.$errorMessage = $errorMessage;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object>(this.$errorMessage, null){
                                        int label;
                                        private /* synthetic */ Object L$0;
                                        final /* synthetic */ String $errorMessage;
                                        {
                                            this.$errorMessage = $errorMessage;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            ConsoleMessageBuilder consoleMessageBuilder = (ConsoleMessageBuilder)this.L$0;
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    void $this$submitMessage;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$errorHandler((ConsoleMessageBuilder)$this$submitMessage, this.$errorMessage);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                            var3_3.L$0 = value;
                                            return (Continuation)var3_3;
                                        }

                                        public final Object invoke(ConsoleMessageBuilder p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }

                public void evaluated(XValue result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    BuildersKt.launch$default((CoroutineScope)JavaScriptDebuggerConsoleExecuteActionHandler.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$vm, result, this.$currentCallFrame, this.$session, null){
                        int label;
                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                        final /* synthetic */ Vm $vm;
                        final /* synthetic */ XValue $result;
                        final /* synthetic */ CallFrameView $currentCallFrame;
                        final /* synthetic */ XDebugSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$vm = $vm;
                            this.$result = $result;
                            this.$currentCallFrame = $currentCallFrame;
                            this.$session = $session;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object>(this.$result, this.this$0, this.$currentCallFrame, this.$session, null){
                                        int label;
                                        private /* synthetic */ Object L$0;
                                        final /* synthetic */ XValue $result;
                                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                                        final /* synthetic */ CallFrameView $currentCallFrame;
                                        final /* synthetic */ XDebugSession $session;
                                        {
                                            this.$result = $result;
                                            this.this$0 = $receiver;
                                            this.$currentCallFrame = $currentCallFrame;
                                            this.$session = $session;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            ConsoleMessageBuilder consoleMessageBuilder = (ConsoleMessageBuilder)this.L$0;
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    void $this$submitMessage;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$successHandler((ConsoleMessageBuilder)$this$submitMessage, this.this$0, this.$currentCallFrame, this.$session);
                                                    ConsoleMessageBuilder.printValue$default((ConsoleMessageBuilder)$this$submitMessage, this.$result, false, 2, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                            var3_3.L$0 = value;
                                            return (Continuation)var3_3;
                                        }

                                        public final Object invoke(ConsoleMessageBuilder p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            };
            XDebuggerEvaluator xDebuggerEvaluator = this.debugProcess.getEvaluator();
            Intrinsics.checkNotNull((Object)xDebuggerEvaluator);
            xDebuggerEvaluator.evaluate(text, callback2, null);
        } else {
            CallFrameView callFrameView = currentCallFrame;
            if (callFrameView == null || (callFrameView = callFrameView.getEvaluateContext()) == null) {
                EvaluateContext evaluateContext = vm2.getEvaluateContext();
                callFrameView = evaluateContext;
                Intrinsics.checkNotNull((Object)evaluateContext);
            }
            Promise promise = EvaluateContext.evaluate$default((EvaluateContext)callFrameView, (String)text, null, (boolean)true, (Project)session2.getProject(), (int)2, null).onSuccess(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$lambda$3(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$lambda$2(this, vm2, text, console, currentCallFrame, session2, arg_0), arg_0)).onError(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$lambda$5(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$lambda$4(this, vm2, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)promise);
        }
    }

    private static final Vm localVariables$lambda$0(Function0 $tmp0) {
        return (Vm)$tmp0.invoke();
    }

    private static final GlobalVariablesHolder globalVariables_delegate$lambda$0(JavaScriptDebuggerConsoleExecuteActionHandler this$0) {
        GlobalVariablesHolder holder = new GlobalVariablesHolder(() -> JavaScriptDebuggerConsoleExecuteActionHandler.globalVariables_delegate$lambda$0$0(this$0.vmSupplier));
        holder.update();
        return holder;
    }

    private static final Vm globalVariables_delegate$lambda$0$0(Function0 $tmp0) {
        return (Vm)$tmp0.invoke();
    }

    private static final void execute$successHandler(ConsoleMessageBuilder $this$execute_u24successHandler, JavaScriptDebuggerConsoleExecuteActionHandler this$0, CallFrameView currentCallFrame, XDebugSession session2) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        ConsoleMessageBuilder.startMessage$default($this$execute_u24successHandler, consoleViewContentType, MessageType.EVAL_OUT, null, 4, null);
        ConsoleMessageBuilder.append$default($this$execute_u24successHandler, "\u200c", null, null, 6, null);
        this$0.getGlobalVariables().update();
        boolean rebuildViewsRequested = false;
        if (Intrinsics.areEqual((Object)currentCallFrame, (Object)session2.getCurrentStackFrame()) && currentCallFrame != null) {
            CallFrame callFrame = currentCallFrame.getCallFrame();
            this$0.localVariables.setCallFrame(callFrame);
            Scope localScope = JavaScriptDebuggerConsoleExecuteActionHandlerKt.getLocalScope(callFrame);
            if (localScope != null) {
                rebuildViewsRequested = true;
                localScope.getVariablesHost().clearCaches().onSuccess(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$successHandler$lambda$1(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$successHandler$lambda$0(this$0, $this$execute_u24successHandler, arg_0), arg_0)).onError((Consumer)new RejectErrorReporter(session2, null, 2, null));
            }
        }
        if (!rebuildViewsRequested) {
            $this$execute_u24successHandler.getDebugProcess().getSession().rebuildViews();
        }
    }

    private static final Unit execute$successHandler$lambda$0(JavaScriptDebuggerConsoleExecuteActionHandler this$0, ConsoleMessageBuilder $this_successHandler, Object it) {
        this$0.localVariables.update();
        $this_successHandler.getDebugProcess().getSession().rebuildViews();
        return Unit.INSTANCE;
    }

    private static final void execute$successHandler$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void execute$errorHandler(ConsoleMessageBuilder $this$execute_u24errorHandler, String errorMessage) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.startMessage$default($this$execute_u24errorHandler, consoleViewContentType, MessageType.EVAL_OUT, null, 4, null);
        ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.append$default($this$execute_u24errorHandler, "\u200c", consoleViewContentType2, null, 4, null);
        ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.append$default($this$execute_u24errorHandler, errorMessage, consoleViewContentType3, null, 4, null);
        ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType4, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.append$default($this$execute_u24errorHandler, "\n", consoleViewContentType4, null, 4, null);
    }

    private static final Unit execute$lambda$2(JavaScriptDebuggerConsoleExecuteActionHandler this$0, Vm $vm, String $text, LanguageConsoleView $console, CallFrameView $currentCallFrame, XDebugSession $session, EvaluateResult it) {
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $vm, it, $text, $console, $currentCallFrame, $session, null){
            int label;
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
            final /* synthetic */ Vm $vm;
            final /* synthetic */ EvaluateResult $it;
            final /* synthetic */ String $text;
            final /* synthetic */ LanguageConsoleView $console;
            final /* synthetic */ CallFrameView $currentCallFrame;
            final /* synthetic */ XDebugSession $session;
            {
                this.this$0 = $receiver;
                this.$vm = $vm;
                this.$it = $it;
                this.$text = $text;
                this.$console = $console;
                this.$currentCallFrame = $currentCallFrame;
                this.$session = $session;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object>(this.$it, this.$text, this.$console, this.this$0, this.$currentCallFrame, this.$session, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ EvaluateResult $it;
                            final /* synthetic */ String $text;
                            final /* synthetic */ LanguageConsoleView $console;
                            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                            final /* synthetic */ CallFrameView $currentCallFrame;
                            final /* synthetic */ XDebugSession $session;
                            {
                                this.$it = $it;
                                this.$text = $text;
                                this.$console = $console;
                                this.this$0 = $receiver;
                                this.$currentCallFrame = $currentCallFrame;
                                this.$session = $session;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (ConsoleMessageBuilder)this.L$0;
                                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!this.$it.getWasThrown()) break;
                                        v0 = ConsoleViewContentType.ERROR_OUTPUT;
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ERROR_OUTPUT");
                                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)$this$submitMessage, "\u200c", v0, null, 4, null);
                                        v1 = $this$submitMessage.getDebugProcess().getGlobalEvaluator();
                                        v2 = this.$it.getValue();
                                        v3 = ConsoleViewContentType.ERROR_OUTPUT;
                                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ERROR_OUTPUT");
                                        this.L$0 = $this$submitMessage;
                                        this.label = 1;
                                        v4 = v1.printAndStoreValueToInspect(v2, this.$text, v3, (ConsoleView)this.$console, (Continuation<? super Unit>)((Continuation)this));
                                        if (v4 == var3_3) {
                                            return var3_3;
                                        }
                                        ** GOTO lbl23
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v4 = $result;
lbl23:
                                        // 2 sources

                                        v5 = ConsoleViewContentType.ERROR_OUTPUT;
                                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"ERROR_OUTPUT");
                                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)$this$submitMessage, "\n", v5, null, 4, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$successHandler((ConsoleMessageBuilder)$this$submitMessage, this.this$0, this.$currentCallFrame, this.$session);
                                v6 = $this$submitMessage.getDebugProcess().getGlobalEvaluator();
                                v7 = this.$it.getValue();
                                v8 = ConsoleViewContentType.getConsoleViewType(JavaScriptConsoleViewContentTypes.INSTANCE.getValueKey(this.$it.getValue()));
                                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getConsoleViewType(...)");
                                this.L$0 = $this$submitMessage;
                                this.label = 2;
                                v9 = v6.printAndStoreValueToInspect(v7, this.$text, v8, (ConsoleView)this.$console, (Continuation<? super Unit>)((Continuation)this));
                                if (v9 == var3_3) {
                                    return var3_3;
                                }
                                ** GOTO lbl41
                                {
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v9 = $result;
lbl41:
                                        // 2 sources

                                        v10 = ConsoleViewContentType.NORMAL_OUTPUT;
                                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"NORMAL_OUTPUT");
                                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)$this$submitMessage, "\n", v10, null, 4, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ConsoleMessageBuilder p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$4(JavaScriptDebuggerConsoleExecuteActionHandler this$0, Vm $vm, Throwable it) {
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $vm, it, null){
            int label;
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
            final /* synthetic */ Vm $vm;
            final /* synthetic */ Throwable $it;
            {
                this.this$0 = $receiver;
                this.$vm = $vm;
                this.$it = $it;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object>(this.$it, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ Throwable $it;
                            {
                                this.$it = $it;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ConsoleMessageBuilder consoleMessageBuilder = (ConsoleMessageBuilder)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$submitMessage;
                                        ResultKt.throwOnFailure((Object)$result);
                                        String string = this.$it.getMessage();
                                        Intrinsics.checkNotNull((Object)string);
                                        JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$errorHandler((ConsoleMessageBuilder)$this$submitMessage, string);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ConsoleMessageBuilder p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(JavaScriptDebuggerConsoleExecuteActionHandler $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ void access$execute$errorHandler(ConsoleMessageBuilder $receiver, String errorMessage) {
        JavaScriptDebuggerConsoleExecuteActionHandler.execute$errorHandler($receiver, errorMessage);
    }

    public static final /* synthetic */ void access$execute$successHandler(ConsoleMessageBuilder $receiver, JavaScriptDebuggerConsoleExecuteActionHandler this$0, CallFrameView currentCallFrame, XDebugSession session2) {
        JavaScriptDebuggerConsoleExecuteActionHandler.execute$successHandler($receiver, this$0, currentCallFrame, session2);
    }
}

