/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.shared;

import com.intellij.debugger.streams.shared.ChainStatus;
import com.intellij.debugger.streams.shared.TraceDebuggerStateListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.FrontendXDebuggerManagerListener;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.rpc.XDebugSessionId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/debugger/streams/shared/StreamDebuggerManager;", "Lcom/intellij/xdebugger/impl/FrontendXDebuggerManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionStates", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/xdebugger/impl/rpc/XDebugSessionId;", "Lcom/intellij/debugger/streams/shared/TraceDebuggerStateListener;", "sessionStarted", "", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "sessionStopped", "getChainStatus", "Lcom/intellij/debugger/streams/shared/ChainStatus;", "id", "Companion", "intellij.debugger.streams.shared"})
public final class StreamDebuggerManager
implements FrontendXDebuggerManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<XDebugSessionId, TraceDebuggerStateListener> sessionStates;

    public StreamDebuggerManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.sessionStates = new ConcurrentHashMap();
        project.getMessageBus().connect().subscribe(FrontendXDebuggerManagerListener.TOPIC, (Object)this);
    }

    public void sessionStarted(@NotNull XDebugSessionProxy session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ((Map)this.sessionStates).put(session.getId(), new TraceDebuggerStateListener(session.getCoroutineScope(), session.getId()));
    }

    public void sessionStopped(@NotNull XDebugSessionProxy session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.sessionStates.remove(session.getId());
    }

    @Nullable
    public final ChainStatus getChainStatus(@NotNull XDebugSessionId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        TraceDebuggerStateListener traceDebuggerStateListener = this.sessionStates.get(id);
        return traceDebuggerStateListener != null ? traceDebuggerStateListener.getChainStatus() : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/streams/shared/StreamDebuggerManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/debugger/streams/shared/StreamDebuggerManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.debugger.streams.shared"})
    @SourceDebugExtension(value={"SMAP\nStreamDebuggerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamDebuggerManager.kt\ncom/intellij/debugger/streams/shared/StreamDebuggerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,63:1\n30#2,2:64\n*S KotlinDebug\n*F\n+ 1 StreamDebuggerManager.kt\ncom/intellij/debugger/streams/shared/StreamDebuggerManager$Companion\n*L\n38#1:64,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamDebuggerManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<StreamDebuggerManager> serviceClass$iv = StreamDebuggerManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (StreamDebuggerManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

