/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.lang.jvm.actions.ExpectedTypesKt;
import com.intellij.lang.jvm.actions.FieldRequestsKt;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmSubstitutor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.VisibilityUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;

public final class JavaFxUnresolvedFxIdReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new XmlElementVisitor(this){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                PsiClass fieldClass;
                PsiReference reference;
                PsiClass controllerClass;
                XmlAttributeValue valueElement;
                if (attribute == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitXmlAttribute(attribute);
                if ("fx:id".equals(attribute.getName()) && (valueElement = attribute.getValueElement()) != null && valueElement.getTextLength() > 0 && (controllerClass = JavaFxPsiUtil.getControllerClass(attribute.getContainingFile())) != null && (reference = valueElement.getReference()) instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef && ((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).isUnresolved() && (fieldClass = JavaFxUnresolvedFxIdReferenceInspection.checkContext(((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).getXmlAttributeValue())) != null) {
                    String text = reference.getCanonicalText();
                    boolean validName = LanguageNamesValidation.isIdentifier((Language)fieldClass.getLanguage(), (String)text, (Project)fieldClass.getProject());
                    holder.registerProblem(reference.getElement(), reference.getRangeInElement(), JavaFXBundle.message("inspection.javafx.unresolved.fx.id.reference.problem", new Object[0]), isOnTheFly && validName ? JavaFxUnresolvedFxIdReferenceInspection.createFixes((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference, holder.getFile()) : LocalQuickFix.EMPTY_ARRAY);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$1", "visitXmlAttribute"));
            }
        };
    }

    private static LocalQuickFix @NotNull [] createFixes(JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef reference, PsiFile file) {
        String visibility = JavaCodeStyleSettings.getInstance((PsiFile)file).VISIBILITY;
        List<Object> annotations = !"public".equals(visibility) ? Collections.singletonList(AnnotationRequestsKt.annotationRequest((String)"javafx.fxml.FXML", (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0])) : Collections.emptyList();
        JvmModifier modifier = JvmUtil.getAccessModifier((int)VisibilityUtil.getAccessLevel((String)visibility));
        List expectedTypes = ExpectedTypesKt.expectedTypes((JvmType)JavaPsiFacade.getElementFactory((Project)file.getProject()).createType(JavaFxUnresolvedFxIdReferenceInspection.checkContext(reference.getXmlAttributeValue())), (ExpectedType.Kind)ExpectedType.Kind.SUBTYPE);
        CreateFieldRequest request = FieldRequestsKt.fieldRequest((String)reference.getCanonicalText(), annotations, Collections.singletonList(modifier), (List)expectedTypes, (JvmSubstitutor)new PsiJvmSubstitutor(file.getProject(), PsiSubstitutor.EMPTY), null, (boolean)false);
        LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createAddFieldActions((JvmClass)reference.getAClass(), (CreateFieldRequest)request), (PsiFile)file).toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(3);
        }
        return localQuickFixArray;
    }

    private static PsiClass checkContext(XmlAttributeValue attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        PsiElement parent = attributeValue.getParent();
        if (parent instanceof XmlAttribute) {
            return JavaFxUnresolvedFxIdReferenceInspection.checkClass(((XmlAttribute)parent).getParent());
        }
        return null;
    }

    private static PsiClass checkClass(XmlTag tag) {
        if (tag != null) {
            XmlTag includedRoot;
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor instanceof JavaFxClassTagDescriptorBase) {
                PsiElement declaration = descriptor.getDeclaration();
                if (declaration instanceof PsiClass) {
                    return (PsiClass)declaration;
                }
            } else if (descriptor instanceof JavaFxBuiltInTagDescriptor && (includedRoot = JavaFxBuiltInTagDescriptor.getIncludedRoot(tag)) != null && !includedRoot.equals((Object)tag)) {
                return JavaFxUnresolvedFxIdReferenceInspection.checkClass(includedRoot);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class CreateFieldFromUsageQuickFix
    implements LocalQuickFix {
        private final String myCanonicalName;

        private CreateFieldFromUsageQuickFix(String canonicalName) {
            this.myCanonicalName = canonicalName;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.create.title.x", (Object[])new Object[]{JavaElementKind.FIELD.object(), this.myCanonicalName});
            if (string == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"create.field.from.usage.family", (Object[])new Object[0]);
            if (string == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement psiElement = descriptor.getPsiElement();
            XmlAttributeValue attrValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlAttributeValue.class, (boolean)false);
            assert (attrValue != null);
            JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef reference = (JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)attrValue.getReference();
            assert (reference != null);
            PsiClass targetClass = reference.getAClass();
            if (!FileModificationService.getInstance().prepareFileForWrite(targetClass.getContainingFile())) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiField field = factory.createField(reference.getCanonicalText(), (PsiType)PsiTypes.intType());
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList != null) {
                String visibility = JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).VISIBILITY;
                if ("EscalateVisible".equals(visibility)) {
                    visibility = "private";
                }
                VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)visibility);
                if (!"public".equals(visibility)) {
                    modifierList.addAnnotation("javafx.fxml.FXML");
                }
            }
            field = CreateFieldFromUsageHelper.insertField((PsiClass)targetClass, (PsiField)field, (PsiElement)psiElement);
            PsiClassType fieldType = factory.createType(JavaFxUnresolvedFxIdReferenceInspection.checkContext(reference.getXmlAttributeValue()));
            ExpectedTypeInfo[] types = new ExpectedTypeInfo[]{new ExpectedTypeInfoImpl((PsiType)fieldType, 1, (PsiType)fieldType, TailTypes.noneType(), null, ExpectedTypeInfoImpl.NULL)};
            CreateFieldFromUsageFix.createFieldFromUsageTemplate((PsiClass)targetClass, (Project)project, (Object)types, (PsiField)field, (boolean)false, (PsiElement)psiElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

