/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.validation.inspections.InspectionUtil;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SuppressInspectionAction
extends SuppressIntentionAction {
    private final String myToolId;
    @IntentionName
    private final String myMsg;

    SuppressInspectionAction(String toolId, @IntentionName String msg) {
        this.myToolId = toolId;
        this.myMsg = msg;
    }

    @NotNull
    public String getText() {
        String string = this.myMsg;
        if (string == null) {
            SuppressInspectionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.suppress.inspection", new Object[0]);
        if (string == null) {
            SuppressInspectionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected abstract XmlTag getAnchor(@NotNull PsiElement var1);

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SuppressInspectionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SuppressInspectionAction.$$$reportNull$$$0(3);
        }
        return this.getAnchor(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        XmlTag anchor;
        if (project == null) {
            SuppressInspectionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SuppressInspectionAction.$$$reportNull$$$0(5);
        }
        if ((anchor = this.getAnchor(element)) == null) {
            return;
        }
        PsiElement prevSibling = anchor.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof XmlText) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof XmlProlog && (prevSibling = prevSibling.getLastChild()) != null && !(prevSibling instanceof XmlComment)) {
            prevSibling = PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevSibling, XmlComment.class);
        }
        if (prevSibling instanceof XmlComment) {
            XmlComment comment = (XmlComment)prevSibling;
            String text = comment.getCommentText();
            if (InspectionUtil.SUPPRESSION_PATTERN.matcher(text).matches()) {
                String s = text.trim() + ", " + this.myToolId;
                XmlComment newComment = SuppressInspectionAction.createComment(project, s);
                CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project).getProject()).reformat(comment.replace((PsiElement)newComment));
            } else {
                this.addNoinspectionComment(project, anchor);
            }
        } else {
            this.addNoinspectionComment(project, anchor);
        }
    }

    private void addNoinspectionComment(Project project, XmlTag anchor) throws IncorrectOperationException {
        XmlComment newComment = SuppressInspectionAction.createComment(project, "noinspection " + this.myToolId);
        XmlTag parent = anchor.getParentTag();
        if (parent == null) {
            parent = PsiTreeUtil.getPrevSiblingOfType((PsiElement)anchor, XmlProlog.class);
            if (parent != null) {
                CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project).getProject()).reformat(parent.add((PsiElement)newComment));
            }
        } else {
            CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project).getProject()).reformat(parent.addBefore((PsiElement)newComment, (PsiElement)anchor));
        }
    }

    @NotNull
    private static XmlComment createComment(Project project, String s) throws IncorrectOperationException {
        XmlTag element = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<foo><!-- " + s + " --></foo>"), (Language)XMLLanguage.INSTANCE);
        XmlComment newComment = (XmlComment)PsiTreeUtil.getChildOfType((PsiElement)element, XmlComment.class);
        assert (newComment != null);
        XmlComment xmlComment = newComment;
        if (xmlComment == null) {
            SuppressInspectionAction.$$$reportNull$$$0(6);
        }
        return xmlComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createComment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

